/*
 * Decompiled with CFR 0.152.
 */
package mcjty.theoneprobe.items;

import mcjty.theoneprobe.TheOneProbe;
import mcjty.theoneprobe.compat.BaubleTools;
import mcjty.theoneprobe.items.CreativeProbe;
import mcjty.theoneprobe.items.Probe;
import mcjty.theoneprobe.items.ProbeNote;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModItems {
    public static CreativeProbe creativeProbe;
    public static Probe probe;
    public static Item diamondHelmetProbe;
    public static Item goldHelmetProbe;
    public static Item ironHelmetProbe;
    public static Item probeGoggles;
    public static ProbeNote probeNote;
    public static String PROBETAG;
    public static String PROBETAG_HAND;

    public static void init() {
        probe = new Probe();
        creativeProbe = new CreativeProbe();
        ItemArmor.ArmorMaterial materialDiamondHelmet = EnumHelper.addArmorMaterial((String)"diamond_helmet_probe", (String)"theoneprobe:probe_diamond", (int)33, (int[])new int[]{3, 6, 8, 3}, (int)10, (SoundEvent)SoundEvents.field_187716_o, (float)2.0f);
        ItemArmor.ArmorMaterial materialGoldHelmet = EnumHelper.addArmorMaterial((String)"gold_helmet_probe", (String)"theoneprobe:probe_gold", (int)7, (int[])new int[]{1, 3, 5, 2}, (int)25, (SoundEvent)SoundEvents.field_187722_q, (float)0.0f);
        ItemArmor.ArmorMaterial materialIronHelmet = EnumHelper.addArmorMaterial((String)"iron_helmet_probe", (String)"theoneprobe:probe_iron", (int)15, (int[])new int[]{2, 5, 6, 2}, (int)9, (SoundEvent)SoundEvents.field_187725_r, (float)0.0f);
        diamondHelmetProbe = ModItems.makeHelmet(materialDiamondHelmet, 3, "diamond_helmet_probe");
        goldHelmetProbe = ModItems.makeHelmet(materialGoldHelmet, 4, "gold_helmet_probe");
        ironHelmetProbe = ModItems.makeHelmet(materialIronHelmet, 2, "iron_helmet_probe");
        probeNote = new ProbeNote();
        if (TheOneProbe.baubles) {
            probeGoggles = BaubleTools.initProbeGoggle();
        }
    }

    private static Item makeHelmet(ItemArmor.ArmorMaterial material, int renderIndex, String name) {
        ItemArmor item = new ItemArmor(material, renderIndex, EntityEquipmentSlot.HEAD){

            public boolean func_77614_k() {
                return true;
            }

            public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
                if (this.func_194125_a(tab)) {
                    ItemStack stack = new ItemStack((Item)this);
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74768_a(PROBETAG, 1);
                    stack.func_77982_d(tag);
                    subItems.add((Object)stack);
                }
            }
        };
        item.func_77655_b("theoneprobe." + name);
        item.setRegistryName(name);
        item.func_77637_a(TheOneProbe.tabProbe);
        return item;
    }

    @SideOnly(value=Side.CLIENT)
    public static void initClient() {
        probe.initModel();
        creativeProbe.initModel();
        ModelLoader.setCustomModelResourceLocation((Item)diamondHelmetProbe, (int)0, (ModelResourceLocation)new ModelResourceLocation(diamondHelmetProbe.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)goldHelmetProbe, (int)0, (ModelResourceLocation)new ModelResourceLocation(goldHelmetProbe.getRegistryName(), "inventory"));
        ModelLoader.setCustomModelResourceLocation((Item)ironHelmetProbe, (int)0, (ModelResourceLocation)new ModelResourceLocation(ironHelmetProbe.getRegistryName(), "inventory"));
        probeNote.initModel();
        if (TheOneProbe.baubles) {
            BaubleTools.initProbeModel(probeGoggles);
        }
    }

    public static boolean isProbeInHand(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() == probe || stack.func_77973_b() == creativeProbe) {
            return true;
        }
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(PROBETAG_HAND);
    }

    private static boolean isProbeHelmet(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77978_p() == null) {
            return false;
        }
        return stack.func_77978_p().func_74764_b(PROBETAG);
    }

    public static boolean hasAProbeSomewhere(EntityPlayer player) {
        return ModItems.hasProbeInHand(player, EnumHand.MAIN_HAND) || ModItems.hasProbeInHand(player, EnumHand.OFF_HAND) || ModItems.hasProbeInHelmet(player) || ModItems.hasProbeInBauble(player);
    }

    private static boolean hasProbeInHand(EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        return ModItems.isProbeInHand(item);
    }

    private static boolean hasProbeInHelmet(EntityPlayer player) {
        ItemStack helmet = player.field_71071_by.func_70301_a(39);
        return ModItems.isProbeHelmet(helmet);
    }

    private static boolean hasProbeInBauble(EntityPlayer player) {
        if (TheOneProbe.baubles) {
            return BaubleTools.hasProbeGoggle(player);
        }
        return false;
    }

    static {
        PROBETAG = "theoneprobe";
        PROBETAG_HAND = "theoneprobe_hand";
    }
}

