/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.world.objects;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.common.world.objects.WorldGenCustomFlowers;

public class WorldGenSilverwoodTrees
extends WorldGenAbstractTree {
    private int minTreeHeight;
    private int randomTreeHeight;
    boolean worldgen = false;

    public WorldGenSilverwoodTrees(boolean doBlockNotify, int minTreeHeight, int randomTreeHeight) {
        super(doBlockNotify);
        this.worldgen = !doBlockNotify;
        this.minTreeHeight = minTreeHeight;
        this.randomTreeHeight = randomTreeHeight;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        int height = random.nextInt(this.randomTreeHeight) + this.minTreeHeight;
        boolean flag = true;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y < 1 || y + height + 1 > 256) {
            return false;
        }
        for (int i1 = y; i1 <= y + 1 + height; ++i1) {
            int spread = 1;
            if (i1 == y) {
                spread = 0;
            }
            if (i1 >= y + 1 + height - 2) {
                spread = 3;
            }
            for (int j1 = x - spread; j1 <= x + spread && flag; ++j1) {
                for (int k1 = z - spread; k1 <= z + spread && flag; ++k1) {
                    if (i1 >= 0 && i1 < 256) {
                        IBlockState state = world.func_180495_p(new BlockPos(j1, i1, k1));
                        Block block = state.func_177230_c();
                        if (block.isAir(state, (IBlockAccess)world, new BlockPos(j1, i1, k1)) || block.isLeaves(state, (IBlockAccess)world, new BlockPos(j1, i1, k1)) || block.func_176200_f((IBlockAccess)world, new BlockPos(j1, i1, k1)) || i1 <= y) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        IBlockState state2 = world.func_180495_p(new BlockPos(x, y - 1, z));
        Block block2 = state2.func_177230_c();
        boolean isSoil = block2.canSustainPlant(state2, (IBlockAccess)world, new BlockPos(x, y - 1, z), EnumFacing.UP, (IPlantable)Blocks.field_150345_g);
        if (isSoil && y < 256 - height - 1) {
            int k2;
            block2.onPlantGrow(state2, world, new BlockPos(x, y - 1, z), new BlockPos(x, y, z));
            int start = y + height - 5;
            int end = y + height + 3 + random.nextInt(3);
            for (int k22 = start; k22 <= end; ++k22) {
                int cty = MathHelper.func_76125_a((int)k22, (int)(y + height - 3), (int)(y + height));
                for (int xx = x - 5; xx <= x + 5; ++xx) {
                    for (int zz = z - 5; zz <= z + 5; ++zz) {
                        double d3 = xx - x;
                        double d4 = k22 - cty;
                        double d5 = zz - z;
                        double dist = d3 * d3 + d4 * d4 + d5 * d5;
                        IBlockState s2 = world.func_180495_p(new BlockPos(xx, k22, zz));
                        if (!(dist < (double)(10 + random.nextInt(8))) || !s2.func_177230_c().canBeReplacedByLeaves(s2, (IBlockAccess)world, new BlockPos(xx, k22, zz))) continue;
                        this.func_175903_a(world, new BlockPos(xx, k22, zz), BlocksTC.leafSilverwood.func_176203_a(1));
                    }
                }
            }
            for (k2 = 0; k2 < height; ++k2) {
                IBlockState s3 = world.func_180495_p(new BlockPos(x, y + k2, z));
                Block block3 = s3.func_177230_c();
                if (!block3.isAir(s3, (IBlockAccess)world, new BlockPos(x, y + k2, z)) && !block3.isLeaves(s3, (IBlockAccess)world, new BlockPos(x, y + k2, z)) && !block3.func_176200_f((IBlockAccess)world, new BlockPos(x, y + k2, z))) continue;
                this.func_175903_a(world, new BlockPos(x, y + k2, z), BlocksTC.logSilverwood.func_176203_a(1));
                this.func_175903_a(world, new BlockPos(x - 1, y + k2, z), BlocksTC.logSilverwood.func_176203_a(1));
                this.func_175903_a(world, new BlockPos(x + 1, y + k2, z), BlocksTC.logSilverwood.func_176203_a(1));
                this.func_175903_a(world, new BlockPos(x, y + k2, z - 1), BlocksTC.logSilverwood.func_176203_a(1));
                this.func_175903_a(world, new BlockPos(x, y + k2, z + 1), BlocksTC.logSilverwood.func_176203_a(1));
            }
            this.func_175903_a(world, new BlockPos(x, y + k2, z), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x - 1, y, z - 1), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x + 1, y, z + 1), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x - 1, y, z + 1), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x + 1, y, z - 1), BlocksTC.logSilverwood.func_176203_a(1));
            if (random.nextInt(3) != 0) {
                this.func_175903_a(world, new BlockPos(x - 1, y + 1, z - 1), BlocksTC.logSilverwood.func_176203_a(1));
            }
            if (random.nextInt(3) != 0) {
                this.func_175903_a(world, new BlockPos(x + 1, y + 1, z + 1), BlocksTC.logSilverwood.func_176203_a(1));
            }
            if (random.nextInt(3) != 0) {
                this.func_175903_a(world, new BlockPos(x - 1, y + 1, z + 1), BlocksTC.logSilverwood.func_176203_a(1));
            }
            if (random.nextInt(3) != 0) {
                this.func_175903_a(world, new BlockPos(x + 1, y + 1, z - 1), BlocksTC.logSilverwood.func_176203_a(1));
            }
            this.func_175903_a(world, new BlockPos(x - 2, y, z), BlocksTC.logSilverwood.func_176203_a(0));
            this.func_175903_a(world, new BlockPos(x + 2, y, z), BlocksTC.logSilverwood.func_176203_a(0));
            this.func_175903_a(world, new BlockPos(x, y, z - 2), BlocksTC.logSilverwood.func_176203_a(2));
            this.func_175903_a(world, new BlockPos(x, y, z + 2), BlocksTC.logSilverwood.func_176203_a(2));
            this.func_175903_a(world, new BlockPos(x - 2, y - 1, z), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x + 2, y - 1, z), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x, y - 1, z - 2), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x, y - 1, z + 2), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x - 1, y + (height - 4), z - 1), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x + 1, y + (height - 4), z + 1), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x - 1, y + (height - 4), z + 1), BlocksTC.logSilverwood.func_176203_a(1));
            this.func_175903_a(world, new BlockPos(x + 1, y + (height - 4), z - 1), BlocksTC.logSilverwood.func_176203_a(1));
            if (random.nextInt(3) == 0) {
                this.func_175903_a(world, new BlockPos(x - 1, y + (height - 5), z - 1), BlocksTC.logSilverwood.func_176203_a(1));
            }
            if (random.nextInt(3) == 0) {
                this.func_175903_a(world, new BlockPos(x + 1, y + (height - 5), z + 1), BlocksTC.logSilverwood.func_176203_a(1));
            }
            if (random.nextInt(3) == 0) {
                this.func_175903_a(world, new BlockPos(x - 1, y + (height - 5), z + 1), BlocksTC.logSilverwood.func_176203_a(1));
            }
            if (random.nextInt(3) == 0) {
                this.func_175903_a(world, new BlockPos(x + 1, y + (height - 5), z - 1), BlocksTC.logSilverwood.func_176203_a(1));
            }
            this.func_175903_a(world, new BlockPos(x - 2, y + (height - 4), z), BlocksTC.logSilverwood.func_176203_a(0));
            this.func_175903_a(world, new BlockPos(x + 2, y + (height - 4), z), BlocksTC.logSilverwood.func_176203_a(0));
            this.func_175903_a(world, new BlockPos(x, y + (height - 4), z - 2), BlocksTC.logSilverwood.func_176203_a(2));
            this.func_175903_a(world, new BlockPos(x, y + (height - 4), z + 2), BlocksTC.logSilverwood.func_176203_a(2));
            if (this.worldgen) {
                WorldGenCustomFlowers flowers = new WorldGenCustomFlowers(BlocksTC.shimmerleaf, 0);
                flowers.func_180709_b(world, random, new BlockPos(x, y, z));
            }
            return true;
        }
        return false;
    }

    protected void func_175903_a(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState bs = worldIn.func_180495_p(pos);
        if (worldIn.func_175623_d(pos) || bs.func_177230_c().isLeaves(bs, (IBlockAccess)worldIn, pos) || bs.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
            super.func_175903_a(worldIn, pos, state);
        }
    }
}

