/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.world.aura;

import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import thaumcraft.Thaumcraft;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.common.lib.utils.PosXY;
import thaumcraft.common.world.aura.AuraChunk;
import thaumcraft.common.world.aura.AuraWorld;
import thaumcraft.common.world.biomes.BiomeHandler;

public class AuraHandler {
    public static int AURA_CEILING = 500;
    static ConcurrentHashMap<Integer, AuraWorld> auras = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, CopyOnWriteArrayList<ChunkPos>> dirtyChunks = new ConcurrentHashMap();
    public static ConcurrentHashMap<Integer, BlockPos> riftTrigger = new ConcurrentHashMap();

    public static AuraWorld getAuraWorld(int dim) {
        return auras.get(dim);
    }

    public static AuraChunk getAuraChunk(int dim, int x, int y) {
        if (auras.containsKey(dim)) {
            return auras.get(dim).getAuraChunkAt(x, y);
        }
        AuraHandler.addAuraWorld(dim);
        if (auras.containsKey(dim)) {
            return auras.get(dim).getAuraChunkAt(x, y);
        }
        return null;
    }

    public static void addAuraWorld(int dim) {
        if (!auras.containsKey(dim)) {
            auras.put(dim, new AuraWorld(dim));
            Thaumcraft.log.info("Creating aura cache for world " + dim);
        }
    }

    public static void removeAuraWorld(int dim) {
        auras.remove(dim);
        Thaumcraft.log.info("Removing aura cache for world " + dim);
    }

    public static void addAuraChunk(int dim, Chunk chunk, short base, float vis, float flux) {
        AuraWorld aw = auras.get(dim);
        if (aw == null) {
            aw = new AuraWorld(dim);
        }
        aw.getAuraChunks().put(new PosXY(chunk.field_76635_g, chunk.field_76647_h), new AuraChunk(chunk, base, vis, flux));
        auras.put(dim, aw);
    }

    public static void removeAuraChunk(int dim, int x, int y) {
        AuraWorld aw = auras.get(dim);
        if (aw != null) {
            aw.getAuraChunks().remove(new PosXY(x, y));
        }
    }

    public static float getTotalAura(World world, BlockPos pos) {
        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return ac != null ? ac.getVis() + ac.getFlux() : 0.0f;
    }

    public static float getFluxSaturation(World world, BlockPos pos) {
        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return ac != null ? ac.getFlux() / (float)ac.getBase() : 0.0f;
    }

    public static float getVis(World world, BlockPos pos) {
        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return ac != null ? ac.getVis() : 0.0f;
    }

    public static float getFlux(World world, BlockPos pos) {
        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return ac != null ? ac.getFlux() : 0.0f;
    }

    public static int getAuraBase(World world, BlockPos pos) {
        AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return ac != null ? ac.getBase() : (short)0;
    }

    public static boolean shouldPreserveAura(World world, EntityPlayer player, BlockPos pos) {
        return (player == null || ThaumcraftCapabilities.getKnowledge(player).isResearchComplete("AURAPRESERVE")) && (double)(AuraHandler.getVis(world, pos) / (float)AuraHandler.getAuraBase(world, pos)) < 0.1;
    }

    public static void addVis(World world, BlockPos pos, float amount) {
        if (amount < 0.0f) {
            return;
        }
        try {
            AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            AuraHandler.modifyVisInChunk(ac, amount, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addFlux(World world, BlockPos pos, float amount) {
        if (amount < 0.0f) {
            return;
        }
        try {
            AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            AuraHandler.modifyFluxInChunk(ac, amount, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static float drainVis(World world, BlockPos pos, float amount, boolean simulate) {
        boolean didit = false;
        try {
            AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            if (amount > ac.getVis()) {
                amount = ac.getVis();
            }
            didit = AuraHandler.modifyVisInChunk(ac, -amount, !simulate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return didit ? amount : 0.0f;
    }

    public static float drainFlux(World world, BlockPos pos, float amount, boolean simulate) {
        boolean didit = false;
        float totalamount = 0.0f;
        try {
            for (int i = -2; i < 3; ++i) {
                for (int j = -2; j < 3; ++j) {
                    AuraChunk ac = AuraHandler.getAuraChunk(world.field_73011_w.getDimension(), pos.func_177958_n() + i * 16 >> 4, pos.func_177952_p() + j * 16 >> 4);
                    if (amount > ac.getFlux()) {
                        amount = ac.getFlux();
                    }
                    didit = AuraHandler.modifyFluxInChunk(ac, -amount, !simulate);
                    totalamount += amount;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return didit ? totalamount : 0.0f;
    }

    public static boolean modifyVisInChunk(AuraChunk ac, float amount, boolean doit) {
        if (ac != null) {
            if (doit) {
                ac.setVis(Math.max(0.0f, ac.getVis() + amount));
            }
            return true;
        }
        return false;
    }

    private static boolean modifyFluxInChunk(AuraChunk ac, float amount, boolean doit) {
        if (ac != null) {
            if (doit) {
                ac.setFlux(Math.max(0.0f, ac.getFlux() + amount));
            }
            return true;
        }
        return false;
    }

    public static void generateAura(Chunk chunk, Random rand) {
        Biome bgb = chunk.func_177412_p().func_180494_b(new BlockPos(chunk.field_76635_g * 16 + 8, 50, chunk.field_76647_h * 16 + 8));
        if (BiomeHandler.getBiomeBlacklist(Biome.func_185362_a((Biome)bgb)) != -1) {
            return;
        }
        float life = BiomeHandler.getBiomeAuraModifier(bgb);
        for (int a = 0; a < 4; ++a) {
            EnumFacing dir = EnumFacing.func_176731_b((int)a);
            Biome bgb2 = chunk.func_177412_p().func_180494_b(new BlockPos((chunk.field_76635_g + dir.func_82601_c()) * 16 + 8, 50, (chunk.field_76647_h + dir.func_82599_e()) * 16 + 8));
            life += BiomeHandler.getBiomeAuraModifier(bgb2);
        }
        float noise = (float)(1.0 + rand.nextGaussian() * (double)0.1f);
        short base = (short)((life /= 5.0f) * 500.0f * noise);
        base = (short)MathHelper.func_76125_a((int)base, (int)0, (int)500);
        AuraHandler.addAuraChunk(chunk.func_177412_p().field_73011_w.getDimension(), chunk, base, base, 0.0f);
    }
}

