/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.tiles.devices;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftInvHelper;
import thaumcraft.api.aura.AuraHelper;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.internal.CommonInternals;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.lib.utils.BlockStateUtils;
import thaumcraft.common.lib.utils.InventoryUtils;
import thaumcraft.common.tiles.TileThaumcraftInventory;
import thaumcraft.common.tiles.devices.TileBellows;

public class TileInfernalFurnace
extends TileThaumcraftInventory {
    public int furnaceCookTime = 0;
    public int furnaceMaxCookTime = 0;
    public int speedyTime = 0;
    public int facingX = -5;
    public int facingZ = -5;

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 1.3, (double)this.func_174877_v().func_177956_o() - 1.3, (double)this.func_174877_v().func_177952_p() - 1.3, (double)this.func_174877_v().func_177958_n() + 2.3, (double)this.func_174877_v().func_177956_o() + 2.3, (double)this.func_174877_v().func_177952_p() + 2.3);
    }

    public TileInfernalFurnace() {
        super(32);
    }

    @Override
    public int[] func_180463_a(EnumFacing par1) {
        return par1 == EnumFacing.UP ? super.func_180463_a(par1) : new int[]{};
    }

    @Override
    public boolean func_180461_b(int par1, ItemStack stack2, EnumFacing par3) {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.furnaceCookTime = nbttagcompound.func_74765_d("CookTime");
        this.speedyTime = nbttagcompound.func_74765_d("SpeedyTime");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        super.func_189515_b(nbttagcompound);
        nbttagcompound.func_74777_a("CookTime", (short)this.furnaceCookTime);
        nbttagcompound.func_74777_a("SpeedyTime", (short)this.speedyTime);
        return nbttagcompound;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.facingX == -5) {
            this.setFacing();
        }
        if (!this.field_145850_b.field_72995_K) {
            int a;
            boolean cookedflag = false;
            if (this.furnaceCookTime > 0) {
                --this.furnaceCookTime;
                cookedflag = true;
            }
            if (this.furnaceMaxCookTime <= 0) {
                this.furnaceMaxCookTime = this.calcCookTime();
            }
            if (this.furnaceCookTime > this.furnaceMaxCookTime) {
                this.furnaceCookTime = this.furnaceMaxCookTime;
            }
            if (this.furnaceCookTime <= 0 && cookedflag) {
                for (a = 0; a < this.func_70302_i_(); ++a) {
                    if (this.func_70301_a(a) == null || this.func_70301_a(a).func_190926_b()) continue;
                    ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.func_70301_a(a));
                    if (itemstack != null && !itemstack.func_190926_b()) {
                        if (this.speedyTime > 0) {
                            --this.speedyTime;
                        }
                        this.ejectItem(itemstack.func_77946_l(), this.func_70301_a(a));
                        this.field_145850_b.func_175641_c(this.func_174877_v(), BlocksTC.infernalFurnace, 3, 0);
                        if (this.func_145831_w().field_73012_v.nextInt(20) == 0) {
                            AuraHelper.polluteAura(this.func_145831_w(), this.func_174877_v().func_177972_a(this.getFacing().func_176734_d()), 1.0f, true);
                        }
                        this.func_70298_a(a, 1);
                        break;
                    }
                    this.func_70299_a(a, ItemStack.field_190927_a);
                }
            }
            if (this.speedyTime <= 0) {
                this.speedyTime = (int)AuraHelper.drainVis(this.func_145831_w(), this.func_174877_v(), 20.0f, false);
            }
            if (this.furnaceCookTime == 0 && !cookedflag) {
                for (a = 0; a < this.func_70302_i_(); ++a) {
                    if (!this.canSmelt(this.func_70301_a(a))) continue;
                    this.furnaceCookTime = this.furnaceMaxCookTime = this.calcCookTime();
                    break;
                }
            }
        }
    }

    private int getBellows() {
        int bellows = 0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos p2;
            TileEntity tile;
            if (dir == EnumFacing.UP || (tile = this.field_145850_b.func_175625_s(p2 = this.field_174879_c.func_177967_a(dir, 2))) == null || !(tile instanceof TileBellows) || BlockStateUtils.getFacing(this.field_145850_b.func_180495_p(p2)) != dir.func_176734_d() || this.field_145850_b.func_175687_A(p2) != 0) continue;
            ++bellows;
        }
        return Math.min(4, bellows);
    }

    private int calcCookTime() {
        int b = this.getBellows();
        if (b > 0) {
            b *= 20 - (b - 1);
        }
        return Math.max(10, (this.speedyTime > 0 ? 80 : 140) - b);
    }

    public ItemStack addItemsToInventory(ItemStack items) {
        if (this.canSmelt(items)) {
            items = ThaumcraftInvHelper.insertStackAt(this.func_145831_w(), this.func_174877_v(), EnumFacing.UP, items, false);
        } else {
            this.destroyItem();
            items = ItemStack.field_190927_a;
        }
        return items;
    }

    private void destroyItem() {
        this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.3f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f, false);
        double var21 = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
        double var22 = this.field_174879_c.func_177956_o() + 1;
        double var23 = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
        this.field_145850_b.func_175688_a(EnumParticleTypes.LAVA, var21, var22, var23, 0.0, 0.0, 0.0, new int[0]);
    }

    public void ejectItem(ItemStack items, ItemStack furnaceItemStack) {
        if (items == null || items.func_190926_b()) {
            return;
        }
        ArrayList<ItemStack> ejecti = new ArrayList<ItemStack>();
        ejecti.add(items.func_77946_l());
        int bellows = this.getBellows() + 1;
        float lx = 0.5f;
        lx += (float)this.facingX * 1.2f;
        float lz = 0.5f;
        lz += (float)this.facingZ * 1.2f;
        float mx = 0.0f;
        float mz = 0.0f;
        for (int a = 0; a < bellows; ++a) {
            ItemStack[] boni = this.getSmeltingBonus(furnaceItemStack);
            if (boni == null) continue;
            for (ItemStack bonus : boni) {
                if (bonus.func_190926_b() || bonus.func_190916_E() <= 0) continue;
                ejecti.add(bonus);
            }
        }
        for (ItemStack outItem : ejecti) {
            if (outItem.func_190926_b()) continue;
            EnumFacing facing = BlockStateUtils.getFacing(this.func_145832_p()).func_176734_d();
            InventoryUtils.ejectStackAt(this.func_145831_w(), this.func_174877_v(), facing, outItem);
        }
        int cnt = items.func_190916_E();
        float xpf = FurnaceRecipes.func_77602_a().func_151398_b(items);
        if (xpf == 0.0f) {
            cnt = 0;
        } else if (xpf < 1.0f) {
            int var4 = MathHelper.func_76141_d((float)((float)cnt * xpf));
            if (var4 < MathHelper.func_76123_f((float)((float)cnt * xpf)) && (float)Math.random() < (float)cnt * xpf - (float)var4) {
                ++var4;
            }
            cnt = var4;
        }
        while (cnt > 0) {
            int var4 = EntityXPOrb.func_70527_a((int)cnt);
            cnt -= var4;
            EntityXPOrb xp = new EntityXPOrb(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + lx), (double)((float)this.field_174879_c.func_177956_o() + 0.4f), (double)((float)this.field_174879_c.func_177952_p() + lz), var4);
            mx = this.facingX == 0 ? (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.025f : (float)this.facingX * 0.13f;
            mz = this.facingZ == 0 ? (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.025f : (float)this.facingZ * 0.13f;
            xp.field_70159_w = mx;
            xp.field_70179_y = mz;
            xp.field_70181_x = 0.0;
            this.field_145850_b.func_72838_d((Entity)xp);
        }
    }

    private ItemStack[] getSmeltingBonus(ItemStack in) {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>();
        block0: for (ThaumcraftApi.SmeltBonus bonus : CommonInternals.smeltingBonus) {
            if (bonus.in instanceof ItemStack) {
                if (in.func_77973_b() != ((ItemStack)bonus.in).func_77973_b() || in.func_77952_i() != ((ItemStack)bonus.in).func_77952_i() && ((ItemStack)bonus.in).func_77952_i() != Short.MAX_VALUE || this.field_145850_b.field_73012_v.nextFloat() > bonus.chance) continue;
                ItemStack is = bonus.out.func_77946_l();
                if (is.func_190916_E() < 1) {
                    is.func_190920_e(1);
                }
                out.add(is);
                continue;
            }
            for (int id : OreDictionary.getOreIDs((ItemStack)in)) {
                String od = OreDictionary.getOreName((int)id);
                if (!bonus.in.equals(od)) continue;
                if (!(this.field_145850_b.field_73012_v.nextFloat() <= bonus.chance)) continue block0;
                ItemStack is2 = bonus.out.func_77946_l();
                if (is2.func_190916_E() < 1) {
                    is2.func_190920_e(1);
                }
                out.add(is2);
                continue block0;
            }
        }
        return out.toArray(new ItemStack[0]);
    }

    private boolean canSmelt(ItemStack stack) {
        return !FurnaceRecipes.func_77602_a().func_151395_a(stack).func_190926_b();
    }

    private void setFacing() {
        this.facingX = 0;
        this.facingZ = 0;
        EnumFacing face = this.getFacing().func_176734_d();
        this.facingX = face.func_82601_c();
        this.facingZ = face.func_82599_e();
    }

    public boolean func_145842_c(int i, int j) {
        if (i == 3) {
            if (this.field_145850_b.field_72995_K) {
                for (int a = 0; a < 5; ++a) {
                    FXDispatcher.INSTANCE.furnaceLavaFx(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.facingX, this.facingZ);
                    this.field_145850_b.func_184134_a((double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.1f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.9f + this.field_145850_b.field_73012_v.nextFloat() * 0.15f, false);
                }
            }
            return true;
        }
        return super.func_145842_c(i, j);
    }
}

