/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.playerdata;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.capabilities.ThaumcraftCapabilities;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchEntry;
import thaumcraft.api.research.ResearchStage;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.utils.InventoryUtils;

public class PacketSyncProgressToServer
implements IMessage,
IMessageHandler<PacketSyncProgressToServer, IMessage> {
    private String key;
    private boolean first;
    private boolean checks;
    private boolean noFlags;

    public PacketSyncProgressToServer() {
    }

    public PacketSyncProgressToServer(String key, boolean first, boolean checks, boolean noFlags) {
        this.key = key;
        this.first = first;
        this.checks = checks;
        this.noFlags = noFlags;
    }

    public PacketSyncProgressToServer(String key, boolean first) {
        this(key, first, false, true);
    }

    public void toBytes(ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.key);
        buffer.writeBoolean(this.first);
        buffer.writeBoolean(this.checks);
        buffer.writeBoolean(this.noFlags);
    }

    public void fromBytes(ByteBuf buffer) {
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.first = buffer.readBoolean();
        this.checks = buffer.readBoolean();
        this.noFlags = buffer.readBoolean();
    }

    public IMessage onMessage(final PacketSyncProgressToServer message, final MessageContext ctx) {
        WorldServer mainThread = ctx.getServerHandler().field_147369_b.func_71121_q();
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (player != null && message.first != ThaumcraftCapabilities.knowsResearch((EntityPlayer)player, message.key)) {
                    if (message.checks && !PacketSyncProgressToServer.this.checkRequisites((EntityPlayer)player, message.key)) {
                        return;
                    }
                    if (message.noFlags) {
                        ResearchManager.noFlags = true;
                    }
                    ResearchManager.progressResearch((EntityPlayer)player, message.key);
                }
            }
        });
        return null;
    }

    private boolean checkRequisites(EntityPlayer player, String key) {
        ResearchEntry research = ResearchCategories.getResearch(key);
        if (research.getStages() != null) {
            ResearchStage.Knowledge[] k;
            String[] r;
            Object[] c;
            int currentStage = ThaumcraftCapabilities.getKnowledge(player).getResearchStage(key) - 1;
            if (currentStage < 0) {
                return false;
            }
            if (currentStage >= research.getStages().length) {
                return true;
            }
            ResearchStage stage = research.getStages()[currentStage];
            Object[] o = stage.getObtain();
            if (o != null) {
                NonNullList nnl;
                int a;
                for (a = 0; a < o.length; ++a) {
                    ItemStack ts = ItemStack.field_190927_a;
                    boolean ore = false;
                    if (o[a] instanceof ItemStack) {
                        ts = (ItemStack)o[a];
                    } else {
                        nnl = OreDictionary.getOres((String)((String)o[a]));
                        ts = (ItemStack)nnl.get(0);
                        ore = true;
                    }
                    if (InventoryUtils.isPlayerCarryingAmount(player, ts, ore)) continue;
                    return false;
                }
                for (a = 0; a < o.length; ++a) {
                    boolean ore2 = false;
                    ItemStack ts2 = ItemStack.field_190927_a;
                    if (o[a] instanceof ItemStack) {
                        ts2 = (ItemStack)o[a];
                    } else {
                        nnl = OreDictionary.getOres((String)((String)o[a]));
                        ts2 = (ItemStack)nnl.get(0);
                        ore2 = true;
                    }
                    InventoryUtils.consumePlayerItem(player, ts2, true, ore2);
                }
            }
            if ((c = stage.getCraft()) != null) {
                for (int a2 = 0; a2 < c.length; ++a2) {
                    if (ThaumcraftCapabilities.getKnowledge(player).isResearchKnown("[#]" + stage.getCraftReference()[a2])) continue;
                    return false;
                }
            }
            if ((r = stage.getResearch()) != null) {
                for (int a3 = 0; a3 < r.length; ++a3) {
                    if (ThaumcraftCapabilities.knowsResearchStrict(player, r[a3])) continue;
                    return false;
                }
            }
            if ((k = stage.getKnow()) != null) {
                int a4;
                for (a4 = 0; a4 < k.length; ++a4) {
                    int pk = ThaumcraftCapabilities.getKnowledge(player).getKnowledge(k[a4].type, k[a4].category);
                    if (pk >= k[a4].amount) continue;
                    return false;
                }
                for (a4 = 0; a4 < k.length; ++a4) {
                    ResearchManager.addKnowledge(player, k[a4].type, k[a4].category, -k[a4].amount * k[a4].type.getProgression());
                }
            }
        }
        return true;
    }
}

