/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.lib.network.misc;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thaumcraft.Thaumcraft;
import thaumcraft.api.golems.seals.ISeal;
import thaumcraft.api.golems.seals.ISealConfigArea;
import thaumcraft.api.golems.seals.ISealConfigFilter;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.seals.SealPos;
import thaumcraft.common.golems.seals.SealEntity;
import thaumcraft.common.golems.seals.SealHandler;
import thaumcraft.common.lib.utils.Utils;

public class PacketSealToClient
implements IMessage,
IMessageHandler<PacketSealToClient, IMessage> {
    BlockPos pos;
    EnumFacing face;
    String type;
    long area;
    boolean[] props = null;
    boolean blacklist;
    byte filtersize;
    NonNullList<ItemStack> filter;
    NonNullList<Integer> filterStackSize;
    byte priority;
    byte color;
    boolean locked;
    boolean redstone;
    String owner;

    public PacketSealToClient() {
    }

    public PacketSealToClient(ISealEntity se) {
        this.pos = se.getSealPos().pos;
        this.face = se.getSealPos().face;
        String string = this.type = se.getSeal() == null ? "REMOVE" : se.getSeal().getKey();
        if (se.getSeal() != null && se.getSeal() instanceof ISealConfigArea) {
            this.area = se.getArea().func_177986_g();
        }
        if (se.getSeal() != null && se.getSeal() instanceof ISealConfigToggles) {
            ISealConfigToggles cp = (ISealConfigToggles)((Object)se.getSeal());
            this.props = new boolean[cp.getToggles().length];
            for (int a = 0; a < cp.getToggles().length; ++a) {
                this.props[a] = cp.getToggles()[a].getValue();
            }
        }
        if (se.getSeal() != null && se.getSeal() instanceof ISealConfigFilter) {
            ISealConfigFilter cp2 = (ISealConfigFilter)((Object)se.getSeal());
            this.blacklist = cp2.isBlacklist();
            this.filtersize = (byte)cp2.getFilterSize();
            this.filter = cp2.getInv();
            this.filterStackSize = cp2.getSizes();
        }
        this.priority = se.getPriority();
        this.color = se.getColor();
        this.locked = se.isLocked();
        this.redstone = se.isRedstoneSensitive();
        this.owner = se.getOwner();
    }

    public void toBytes(ByteBuf dos) {
        dos.writeLong(this.pos.func_177986_g());
        dos.writeByte(this.face.ordinal());
        dos.writeByte((int)this.priority);
        dos.writeByte((int)this.color);
        dos.writeBoolean(this.locked);
        dos.writeBoolean(this.redstone);
        ByteBufUtils.writeUTF8String((ByteBuf)dos, (String)this.owner);
        ByteBufUtils.writeUTF8String((ByteBuf)dos, (String)this.type);
        dos.writeBoolean(this.blacklist);
        dos.writeByte((int)this.filtersize);
        for (int a = 0; a < this.filtersize; ++a) {
            Utils.writeItemStackToBuffer(dos, (ItemStack)this.filter.get(a));
            dos.writeShort(((Integer)this.filterStackSize.get(a)).intValue());
        }
        if (this.area != 0L) {
            dos.writeLong(this.area);
        }
        if (this.props != null) {
            for (boolean b : this.props) {
                dos.writeBoolean(b);
            }
        }
    }

    public void fromBytes(ByteBuf dat) {
        this.pos = BlockPos.func_177969_a((long)dat.readLong());
        this.face = EnumFacing.field_82609_l[dat.readByte()];
        this.priority = dat.readByte();
        this.color = dat.readByte();
        this.locked = dat.readBoolean();
        this.redstone = dat.readBoolean();
        this.owner = ByteBufUtils.readUTF8String((ByteBuf)dat);
        this.type = ByteBufUtils.readUTF8String((ByteBuf)dat);
        this.blacklist = dat.readBoolean();
        this.filtersize = dat.readByte();
        this.filter = NonNullList.func_191197_a((int)this.filtersize, (Object)ItemStack.field_190927_a);
        this.filterStackSize = NonNullList.func_191197_a((int)this.filtersize, (Object)0);
        for (int a = 0; a < this.filtersize; ++a) {
            this.filter.set(a, (Object)Utils.readItemStackFromBuffer(dat));
            this.filterStackSize.set(a, (Object)dat.readShort());
        }
        if (!this.type.equals("REMOVE") && SealHandler.getSeal(this.type) != null) {
            if (SealHandler.getSeal(this.type) instanceof ISealConfigArea) {
                try {
                    this.area = dat.readLong();
                }
                catch (Exception a) {
                    // empty catch block
                }
            }
            if (SealHandler.getSeal(this.type) instanceof ISealConfigToggles) {
                try {
                    ISealConfigToggles cp = (ISealConfigToggles)((Object)SealHandler.getSeal(this.type));
                    this.props = new boolean[cp.getToggles().length];
                    for (int a2 = 0; a2 < cp.getToggles().length; ++a2) {
                        this.props[a2] = dat.readBoolean();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public IMessage onMessage(PacketSealToClient message, MessageContext ctx) {
        if (message.type.equals("REMOVE")) {
            SealHandler.removeSealEntity(Thaumcraft.proxy.getClientWorld(), new SealPos(message.pos, message.face), true);
        } else {
            try {
                int a;
                SealEntity seal = new SealEntity(Thaumcraft.proxy.getClientWorld(), new SealPos(message.pos, message.face), (ISeal)SealHandler.getSeal(message.type).getClass().newInstance());
                if (message.area != 0L) {
                    seal.setArea(BlockPos.func_177969_a((long)message.area));
                }
                if (message.props != null && seal.getSeal() instanceof ISealConfigToggles) {
                    ISealConfigToggles cp = (ISealConfigToggles)((Object)seal.getSeal());
                    for (a = 0; a < message.props.length; ++a) {
                        cp.setToggle(a, message.props[a]);
                    }
                }
                if (seal.getSeal() instanceof ISealConfigFilter) {
                    ISealConfigFilter cp2 = (ISealConfigFilter)((Object)seal.getSeal());
                    cp2.setBlacklist(message.blacklist);
                    for (a = 0; a < message.filtersize; ++a) {
                        cp2.setFilterSlot(a, (ItemStack)message.filter.get(a));
                        cp2.setFilterSlotSize(a, (Integer)message.filterStackSize.get(a));
                    }
                }
                seal.setPriority(message.priority);
                seal.setColor(message.color);
                seal.setLocked(message.locked);
                seal.setRedstoneSensitive(message.redstone);
                seal.setOwner(message.owner);
                SealHandler.addSealEntity(Thaumcraft.proxy.getClientWorld(), seal);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

