/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.predefined;

import com.wuest.prefab.proxy.CommonProxy;
import com.wuest.prefab.structures.base.BuildBlock;
import com.wuest.prefab.structures.base.BuildClear;
import com.wuest.prefab.structures.base.BuildShape;
import com.wuest.prefab.structures.base.BuildingMethods;
import com.wuest.prefab.structures.base.PositionOffset;
import com.wuest.prefab.structures.base.Structure;
import com.wuest.prefab.structures.config.HouseConfiguration;
import com.wuest.prefab.structures.config.StructureConfiguration;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockStone;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class StructureAlternateStart
extends Structure {
    private static ArrayList<BlockPos> torchPositions = null;
    private BlockPos chestPosition = null;
    private BlockPos furnacePosition = null;
    private BlockPos trapDoorPosition = null;
    private BlockPos signPosition = null;
    private BlockPos bedHeadPosition = null;
    private BlockPos bedFootPosition = null;

    public static void ScanBasicHouseStructure(World world, BlockPos originalPos, EnumFacing playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(EnumFacing.SOUTH);
        clearedSpace.getShape().setHeight(10);
        clearedSpace.getShape().setLength(12);
        clearedSpace.getShape().setWidth(13);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(5);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BlockPos corner = originalPos.func_177965_g(5).func_177968_d().func_177977_b();
        BlockPos corner2 = originalPos.func_177985_f(8).func_177970_e(13).func_177981_b(10);
        Structure.ScanStructure(world, originalPos, corner, corner2, "..\\src\\main\\resources\\assets\\prefab\\structures\\basic_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanRanchStructure(World world, BlockPos originalPos, EnumFacing playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(EnumFacing.SOUTH);
        clearedSpace.getShape().setHeight(7);
        clearedSpace.getShape().setLength(21);
        clearedSpace.getShape().setWidth(11);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        Structure.ScanStructure(world, originalPos, originalPos.func_177965_g(8).func_177968_d().func_177977_b(), originalPos.func_177970_e(22).func_177985_f(3).func_177981_b(8), "..\\src\\main\\resources\\assets\\prefab\\structures\\ranch_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanLoftStructure(World world, BlockPos originalPos, EnumFacing playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(EnumFacing.SOUTH);
        clearedSpace.getShape().setHeight(9);
        clearedSpace.getShape().setLength(13);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(7);
        Structure.ScanStructure(world, originalPos, originalPos.func_177965_g(7).func_177968_d(), originalPos.func_177970_e(14).func_177985_f(8).func_177981_b(9), "..\\src\\main\\resources\\assets\\prefab\\structures\\loft_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanHobbitStructure(World world, BlockPos originalPos, EnumFacing playerFacing) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(EnumFacing.SOUTH);
        clearedSpace.getShape().setHeight(12);
        clearedSpace.getShape().setLength(16);
        clearedSpace.getShape().setWidth(16);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-3);
        Structure.ScanStructure(world, originalPos, originalPos.func_177965_g(8).func_177968_d().func_177979_c(3), originalPos.func_177970_e(16).func_177985_f(8).func_177981_b(12), "..\\src\\main\\resources\\assets\\prefab\\structures\\hobbit_house.zip", clearedSpace, playerFacing, false, false);
    }

    public static void ScanStructure(World world, BlockPos originalPos, EnumFacing playerFacing, String structureFileName, boolean includeAir, boolean excludeWater) {
        BuildClear clearedSpace = new BuildClear();
        clearedSpace.getShape().setDirection(EnumFacing.SOUTH);
        clearedSpace.getShape().setHeight(8);
        clearedSpace.getShape().setLength(15);
        clearedSpace.getShape().setWidth(15);
        clearedSpace.getStartingPosition().setSouthOffset(1);
        clearedSpace.getStartingPosition().setEastOffset(8);
        clearedSpace.getStartingPosition().setHeightOffset(-1);
        BuildShape buildShape = clearedSpace.getShape();
        PositionOffset offset = clearedSpace.getStartingPosition();
        int downOffset = offset.getHeightOffset() < 0 ? Math.abs(offset.getHeightOffset()) : 0;
        BlockPos cornerPos = originalPos.func_177965_g(offset.getEastOffset()).func_177970_e(offset.getSouthOffset()).func_177979_c(downOffset);
        Structure.ScanStructure(world, originalPos, cornerPos, cornerPos.func_177970_e(buildShape.getLength()).func_177985_f(buildShape.getWidth()).func_177981_b(buildShape.getHeight()), "..\\src\\main\\resources\\assets\\prefab\\structures\\" + structureFileName + ".zip", clearedSpace, playerFacing, includeAir, excludeWater);
    }

    public static void FillChest(World world, BlockPos itemPosition, HouseConfiguration configuration, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(itemPosition);
        if (tileEntity instanceof TileEntityChest) {
            int itemSlot;
            TileEntityChest chestTile;
            block14: {
                chestTile = (TileEntityChest)tileEntity;
                itemSlot = 0;
                if (CommonProxy.proxyConfiguration.addAxe) {
                    chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151049_t));
                }
                if (CommonProxy.proxyConfiguration.addHoe) {
                    chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151018_J));
                }
                if (CommonProxy.proxyConfiguration.addPickAxe) {
                    chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151050_s));
                    if (!configuration.addCraftingTable) break block14;
                }
            }
            if (CommonProxy.proxyConfiguration.addShovel) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151051_r));
            }
            if (CommonProxy.proxyConfiguration.addSword) {
                ResourceLocation name = new ResourceLocation("repurpose", "itemSwiftBladeStone");
                Item sword = (Item)Item.field_150901_e.func_82594_a((Object)name);
                if (sword == null) {
                    sword = Items.field_151052_q;
                }
                chestTile.func_70299_a(itemSlot++, new ItemStack(sword));
            }
            if (CommonProxy.proxyConfiguration.addArmor) {
                chestTile.func_70299_a(itemSlot++, new ItemStack((Item)Items.field_151021_T));
                chestTile.func_70299_a(itemSlot++, new ItemStack((Item)Items.field_151027_R));
                chestTile.func_70299_a(itemSlot++, new ItemStack((Item)Items.field_151024_Q));
                chestTile.func_70299_a(itemSlot++, new ItemStack((Item)Items.field_151026_S));
            }
            if (CommonProxy.proxyConfiguration.addFood) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151025_P, 20));
            }
            if (CommonProxy.proxyConfiguration.addCrops) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151174_bG, 3));
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151172_bF, 3));
                chestTile.func_70299_a(itemSlot++, new ItemStack(Items.field_151014_N, 3));
            }
            if (CommonProxy.proxyConfiguration.addCobble) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Item.func_150898_a((Block)Blocks.field_150347_e), 64));
            }
            if (CommonProxy.proxyConfiguration.addDirt) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Item.func_150898_a((Block)Blocks.field_150346_d), 64));
            }
            if (CommonProxy.proxyConfiguration.addSaplings) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Item.func_150898_a((Block)Blocks.field_150345_g), 3));
            }
            if (CommonProxy.proxyConfiguration.addTorches) {
                chestTile.func_70299_a(itemSlot++, new ItemStack(Item.func_150898_a((Block)Blocks.field_150478_aa), 20));
            }
        }
    }

    public static void PlaceMineShaft(World world, BlockPos pos, EnumFacing facing, boolean onlyGatherOres) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<Item> blocksToNotAdd = new ArrayList<Item>();
        if (onlyGatherOres) {
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150354_m));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150322_A));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150347_e));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150348_b));
            blocksToNotAdd.add(Item.func_150898_a((Block)Blocks.field_150346_d));
        }
        stacks = StructureAlternateStart.CreateLadderShaft(world, pos, stacks, facing, blocksToNotAdd);
        pos = pos.func_177979_c(pos.func_177956_o() - 10);
        ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>();
        BlockPos ceilingLevel = pos.func_177981_b(4);
        tempStacks = BuildingMethods.SetFloor(world, ceilingLevel.func_177967_a(facing, 2).func_177967_a(facing.func_176746_e(), 2).func_177972_a(facing.func_176734_d()), Blocks.field_150348_b, 4, 4, tempStacks, facing.func_176734_d(), blocksToNotAdd);
        BuildingMethods.ReplaceBlock(world, ceilingLevel, Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)facing));
        IBlockState torchState = Blocks.field_150478_aa.func_176203_a(5);
        for (BlockPos torchPos : torchPositions) {
            IBlockState surroundingState = world.func_180495_p(torchPos);
            Block surroundingBlock = surroundingState.func_177230_c();
            tempStacks = BuildingMethods.ConsolidateDrops(surroundingBlock, world, torchPos, surroundingState, tempStacks, blocksToNotAdd);
            BuildingMethods.ReplaceBlock(world, torchPos, torchState);
        }
        tempStacks.addAll(BuildingMethods.SetFloor(world, pos.func_177972_a(facing).func_177972_a(facing.func_176746_e()), Blocks.field_150348_b, 3, 4, tempStacks, facing.func_176734_d(), blocksToNotAdd));
        for (int i = 0; i < tempStacks.size(); ++i) {
            ItemStack stack = tempStacks.get(i);
            if (stack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150468_ap)) continue;
            tempStacks.remove(i);
            --i;
        }
        pos = pos.func_177984_a();
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.func_176746_e(), pos.func_177967_a(facing.func_176734_d(), 2).func_177972_a(facing.func_176735_f()), Blocks.field_150350_a, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.func_176746_e(), pos.func_177967_a(facing.func_176734_d(), 3).func_177972_a(facing.func_176735_f()), Blocks.field_150348_b, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.func_177967_a(facing.func_176734_d(), 2).func_177972_a(facing.func_176746_e()), Blocks.field_150350_a, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing, pos.func_177967_a(facing.func_176734_d(), 2).func_177967_a(facing.func_176746_e(), 2), Blocks.field_150348_b, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.func_176735_f(), pos.func_177972_a(facing).func_177972_a(facing.func_176746_e()), Blocks.field_150350_a, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 3, facing.func_176735_f(), pos.func_177967_a(facing, 2).func_177972_a(facing.func_176746_e()), Blocks.field_150348_b, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.func_176734_d(), pos.func_177972_a(facing).func_177972_a(facing.func_176735_f()), Blocks.field_150350_a, blocksToNotAdd));
        tempStacks.addAll(BuildingMethods.CreateWall(world, 3, 4, facing.func_176734_d(), pos.func_177967_a(facing, 1).func_177967_a(facing.func_176735_f(), 2), Blocks.field_150348_b, blocksToNotAdd));
        for (ItemStack tempStack : tempStacks) {
            Boolean foundStack = false;
            for (ItemStack existingStack : stacks) {
                if (!ItemStack.func_179545_c((ItemStack)existingStack, (ItemStack)tempStack) || existingStack.func_190916_E() + tempStack.func_190916_E() > tempStack.func_77976_d()) continue;
                existingStack.func_190920_e(existingStack.func_190916_E() + tempStack.func_190916_E());
                foundStack = true;
                break;
            }
            if (foundStack.booleanValue()) continue;
            stacks.add(tempStack);
        }
        IBlockState blockState = Blocks.field_150478_aa.func_176203_a(5);
        BuildingMethods.ReplaceBlock(world, pos.func_177972_a(facing.func_176735_f()), blockState);
        if (CommonProxy.proxyConfiguration.includeMineshaftChest) {
            IBlockState chestState = Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)facing);
            BuildingMethods.ReplaceBlock(world, pos.func_177972_a(facing.func_176746_e()), chestState);
            if (stacks.size() > 27) {
                BuildingMethods.ReplaceBlock(world, pos.func_177972_a(facing.func_176746_e()).func_177972_a(facing.func_176734_d()), chestState);
            }
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing.func_176746_e()));
            TileEntity tileEntity2 = world.func_175625_s(pos.func_177972_a(facing.func_176746_e()).func_177972_a(facing.func_176734_d()));
            if (tileEntity instanceof TileEntityChest) {
                TileEntityChest chestTile = (TileEntityChest)tileEntity;
                TileEntityChest chestTile2 = (TileEntityChest)tileEntity2;
                int i = 0;
                boolean fillSecond = false;
                for (ItemStack stack : stacks) {
                    if (i == 27 && !fillSecond) {
                        fillSecond = true;
                        i = 0;
                        chestTile = chestTile2;
                    }
                    if (i >= 27 && fillSecond) break;
                    chestTile.func_70299_a(i, stack);
                    ++i;
                }
            }
        }
    }

    private static ArrayList<ItemStack> CreateLadderShaft(World world, BlockPos pos, ArrayList<ItemStack> originalStacks, EnumFacing houseFacing, ArrayList<Item> blocksToNotAdd) {
        int torchCounter = 0;
        EnumFacing westWall = houseFacing.func_176735_f();
        IBlockState ladderState = Blocks.field_150468_ap.func_176223_P().func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)houseFacing);
        BuildingMethods.ReplaceBlock(world, pos, Blocks.field_150350_a);
        torchPositions = new ArrayList();
        while (pos.func_177956_o() > 8) {
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            ++torchCounter;
            for (int i = 0; i < 4; ++i) {
                EnumFacing facing = houseFacing;
                switch (i) {
                    case 1: {
                        facing = houseFacing.func_176746_e();
                        break;
                    }
                    case 2: {
                        facing = houseFacing.func_176734_d();
                        break;
                    }
                    case 3: {
                        facing = houseFacing.func_176735_f();
                        break;
                    }
                    default: {
                        facing = houseFacing;
                    }
                }
                if (facing == westWall && torchCounter == 6 && pos.func_177956_o() > 14) {
                    for (int j = 0; j <= 2; ++j) {
                        BlockPos tempPos = null;
                        IBlockState surroundingState = null;
                        Block surroundingBlock = null;
                        if (j == 0) {
                            tempPos = pos.func_177967_a(facing, 2);
                            surroundingState = world.func_180495_p(tempPos);
                            surroundingBlock = surroundingState.func_177230_c();
                        } else if (j == 1) {
                            tempPos = pos.func_177972_a(facing).func_177972_a(facing.func_176746_e());
                            surroundingState = world.func_180495_p(tempPos);
                            surroundingBlock = surroundingState.func_177230_c();
                        } else {
                            tempPos = pos.func_177972_a(facing).func_177972_a(facing.func_176735_f());
                            surroundingState = world.func_180495_p(tempPos);
                            surroundingBlock = surroundingState.func_177230_c();
                        }
                        if (surroundingBlock instanceof BlockStone) continue;
                        originalStacks = BuildingMethods.ConsolidateDrops(surroundingBlock, world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                        BuildingMethods.ReplaceBlock(world, tempPos, Blocks.field_150348_b);
                    }
                    torchPositions.add(pos.func_177972_a(facing));
                    torchCounter = 0;
                    continue;
                }
                BlockPos tempPos = pos.func_177972_a(facing);
                IBlockState surroundingState = world.func_180495_p(tempPos);
                Block surroundingBlock = surroundingState.func_177230_c();
                if (surroundingBlock.func_149637_q(surroundingState) && !(surroundingBlock instanceof BlockLiquid)) continue;
                originalStacks = BuildingMethods.ConsolidateDrops(surroundingBlock, world, tempPos, surroundingState, originalStacks, blocksToNotAdd);
                BuildingMethods.ReplaceBlock(world, tempPos, Blocks.field_150348_b);
            }
            originalStacks = BuildingMethods.ConsolidateDrops(block, world, pos, state, originalStacks, blocksToNotAdd);
            if (pos.func_177956_o() >= 10) {
                BuildingMethods.ReplaceBlock(world, pos, ladderState);
            }
            pos = pos.func_177977_b();
        }
        return originalStacks;
    }

    @Override
    protected Boolean CustomBlockProcessingHandled(StructureConfiguration configuration, BuildBlock block, World world, BlockPos originalPos, EnumFacing assumedNorth, Block foundBlock, IBlockState blockState, EntityPlayer player) {
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        if (!houseConfig.addBed && foundBlock instanceof BlockBed || !houseConfig.addChest && foundBlock instanceof BlockChest || !houseConfig.addTorches && foundBlock instanceof BlockTorch || !houseConfig.addCraftingTable && foundBlock instanceof BlockWorkbench || !houseConfig.addFurnace && foundBlock instanceof BlockFurnace) {
            return true;
        }
        if (foundBlock instanceof BlockFurnace) {
            this.furnacePosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BlockTrapDoor && houseConfig.addMineShaft) {
            this.trapDoorPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BlockChest && this.chestPosition == null) {
            this.chestPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BlockStandingSign) {
            this.signPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else if (foundBlock instanceof BlockBed) {
            this.bedHeadPosition = block.getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
            this.bedFootPosition = block.getSubBlock().getStartingPosition().getRelativePosition(originalPos, this.getClearSpace().getShape().getDirection(), configuration.houseFacing);
        } else {
            if (foundBlock instanceof BlockStainedGlass) {
                blockState = this.getStainedGlassBlock(houseConfig.glassColor);
                block.setBlockState(blockState);
                this.priorityOneBlocks.add(block);
                return true;
            }
            if (foundBlock instanceof BlockStainedGlassPane) {
                blockState = this.getStainedGlassPaneBlock(houseConfig.glassColor);
                block.setBlockState(blockState);
                this.priorityOneBlocks.add(block);
                return true;
            }
        }
        return false;
    }

    @Override
    public void AfterBuilding(StructureConfiguration configuration, World world, BlockPos originalPos, EnumFacing assumedNorth, EntityPlayer player) {
        TileEntity tileEntity;
        HouseConfiguration houseConfig = (HouseConfiguration)configuration;
        if (this.furnacePosition != null && (tileEntity = world.func_175625_s(this.furnacePosition)) instanceof TileEntityFurnace) {
            TileEntityFurnace furnaceTile = (TileEntityFurnace)tileEntity;
            furnaceTile.func_70299_a(1, new ItemStack(Items.field_151044_h, 20));
        }
        if (this.chestPosition != null && houseConfig.addChestContents) {
            StructureAlternateStart.FillChest(world, this.chestPosition, houseConfig, player);
        }
        if (this.trapDoorPosition != null && this.trapDoorPosition.func_177956_o() > 15 && houseConfig.addMineShaft) {
            StructureAlternateStart.PlaceMineShaft(world, this.trapDoorPosition.func_177977_b(), houseConfig.houseFacing, false);
        }
        if (this.signPosition != null && (tileEntity = world.func_175625_s(this.signPosition)) instanceof TileEntitySign) {
            TileEntitySign signTile = (TileEntitySign)tileEntity;
            signTile.field_145915_a[0] = new TextComponentString("This is");
            signTile.field_145915_a[1] = player.getDisplayNameString().length() >= 15 ? new TextComponentString(player.getDisplayNameString()) : new TextComponentString(player.getDisplayNameString() + "'s");
            signTile.field_145915_a[2] = new TextComponentString("house!");
        }
        if (this.bedHeadPosition != null && houseConfig.addBed) {
            BuildingMethods.PlaceColoredBed(world, this.bedHeadPosition, this.bedFootPosition, houseConfig.bedColor);
        }
    }
}

