/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.config;

import com.wuest.prefab.blocks.FullDyeColor;
import com.wuest.prefab.structures.config.StructureConfiguration;
import com.wuest.prefab.structures.config.enums.AquaBaseOptions;
import com.wuest.prefab.structures.config.enums.BarnAdvancedOptions;
import com.wuest.prefab.structures.config.enums.BarnOptions;
import com.wuest.prefab.structures.config.enums.BaseOption;
import com.wuest.prefab.structures.config.enums.DefenseBunkerOptions;
import com.wuest.prefab.structures.config.enums.GreenHouseOptions;
import com.wuest.prefab.structures.config.enums.HorseStableAdvancedOptions;
import com.wuest.prefab.structures.config.enums.HorseStableOptions;
import com.wuest.prefab.structures.config.enums.HouseAdvancedEstateOptions;
import com.wuest.prefab.structures.config.enums.HouseBasicOptions;
import com.wuest.prefab.structures.config.enums.HouseCabinOptions;
import com.wuest.prefab.structures.config.enums.HouseCampsiteOptions;
import com.wuest.prefab.structures.config.enums.HouseCottageOptions;
import com.wuest.prefab.structures.config.enums.HouseCrimsonOptions;
import com.wuest.prefab.structures.config.enums.HouseEarthenOptions;
import com.wuest.prefab.structures.config.enums.HouseHobbitOptions;
import com.wuest.prefab.structures.config.enums.HouseIzbaOptions;
import com.wuest.prefab.structures.config.enums.HouseJungleOptions;
import com.wuest.prefab.structures.config.enums.HouseMountainOptions;
import com.wuest.prefab.structures.config.enums.HouseMushroomOptions;
import com.wuest.prefab.structures.config.enums.HouseNetherOptions;
import com.wuest.prefab.structures.config.enums.HouseRanchOptions;
import com.wuest.prefab.structures.config.enums.HouseSnowOptions;
import com.wuest.prefab.structures.config.enums.HouseSpruceOptions;
import com.wuest.prefab.structures.config.enums.HouseSubAquaOptions;
import com.wuest.prefab.structures.config.enums.HouseTowerOptions;
import com.wuest.prefab.structures.config.enums.HouseTreeOptions;
import com.wuest.prefab.structures.config.enums.JailOptions;
import com.wuest.prefab.structures.config.enums.MachineryTowerOptions;
import com.wuest.prefab.structures.config.enums.MagicTempleOptions;
import com.wuest.prefab.structures.config.enums.ModernApartmentOptions;
import com.wuest.prefab.structures.config.enums.ModernBankOptions;
import com.wuest.prefab.structures.config.enums.ModernCinemaOptions;
import com.wuest.prefab.structures.config.enums.ModernCottageOptions;
import com.wuest.prefab.structures.config.enums.ModernGasStationOptions;
import com.wuest.prefab.structures.config.enums.ModernHipsterFruitStandOptions;
import com.wuest.prefab.structures.config.enums.ModernHouseOptions;
import com.wuest.prefab.structures.config.enums.ModernJuiceShopOptions;
import com.wuest.prefab.structures.config.enums.ModernLibraryOptions;
import com.wuest.prefab.structures.config.enums.ModernMallStoreOptions;
import com.wuest.prefab.structures.config.enums.ModernMiniHotelOptions;
import com.wuest.prefab.structures.config.enums.ModernRestaurantOptions;
import com.wuest.prefab.structures.config.enums.ModernWaterParkOptions;
import com.wuest.prefab.structures.config.enums.SaloonOptions;
import com.wuest.prefab.structures.config.enums.SkiLodgeOptions;
import com.wuest.prefab.structures.config.enums.TownHallOptions;
import com.wuest.prefab.structures.config.enums.VillagerHouseAngledOptions;
import com.wuest.prefab.structures.config.enums.VillagerHouseBlacksmithOptions;
import com.wuest.prefab.structures.config.enums.VillagerHouseFencedOptions;
import com.wuest.prefab.structures.config.enums.VillagerHouseFlatOptions;
import com.wuest.prefab.structures.config.enums.VillagerHouseLongOptions;
import com.wuest.prefab.structures.config.enums.WarehouseOptions;
import com.wuest.prefab.structures.config.enums.WatchTowerDarkOptions;
import com.wuest.prefab.structures.config.enums.WatchTowerOptions;
import com.wuest.prefab.structures.config.enums.WelcomeCenterOptions;
import com.wuest.prefab.structures.config.enums.WindMillOptions;
import com.wuest.prefab.structures.items.ItemBasicStructure;
import com.wuest.prefab.structures.predefined.StructureBasic;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BasicStructureConfiguration
extends StructureConfiguration {
    private static final String structureEnumNameTag = "structureEnumName";
    private static final String structureDisplayNameTag = "structureDisplayName";
    private static final String bedColorTag = "bedColor";
    private static final String glassColorTag = "glassColor";
    private static final String chosenOptionTag = "chosenOption";
    public EnumBasicStructureName basicStructureName;
    public String structureDisplayName;
    public EnumDyeColor bedColor;
    public FullDyeColor glassColor;
    public BaseOption chosenOption;

    public String getDisplayName() {
        if (this.basicStructureName == EnumBasicStructureName.Custom) {
            return this.structureDisplayName;
        }
        return this.basicStructureName.getItemTranslationString();
    }

    public int getCostToBuy() {
        return this.basicStructureName.getCostToBuy();
    }

    public boolean IsCustomStructure() {
        return this.basicStructureName == EnumBasicStructureName.Custom;
    }

    @Override
    public void Initialize() {
        super.Initialize();
        this.houseFacing = EnumFacing.NORTH;
        this.basicStructureName = EnumBasicStructureName.WindMill;
        this.bedColor = EnumDyeColor.RED;
        this.glassColor = FullDyeColor.CLEAR;
        this.chosenOption = this.basicStructureName.baseOption.getSpecificOptions().get(0);
    }

    @Override
    protected void CustomReadFromNBTTag(NBTTagCompound messageTag, StructureConfiguration config) {
        BasicStructureConfiguration basicConfig = (BasicStructureConfiguration)config;
        if (messageTag.func_74764_b(structureEnumNameTag)) {
            basicConfig.basicStructureName = EnumBasicStructureName.valueOf(messageTag.func_74779_i(structureEnumNameTag));
        }
        if (messageTag.func_74764_b(structureDisplayNameTag)) {
            basicConfig.structureDisplayName = messageTag.func_74779_i(structureDisplayNameTag);
        }
        if (messageTag.func_74764_b(bedColorTag)) {
            basicConfig.bedColor = EnumDyeColor.valueOf((String)messageTag.func_74779_i(bedColorTag));
        }
        if (messageTag.func_74764_b(glassColorTag)) {
            basicConfig.glassColor = FullDyeColor.valueOf(messageTag.func_74779_i(glassColorTag));
        }
        if (messageTag.func_74764_b(chosenOptionTag)) {
            basicConfig.chosenOption = BaseOption.getOptionByTranslationString(messageTag.func_74779_i(chosenOptionTag));
        }
    }

    @Override
    protected NBTTagCompound CustomWriteToCompoundNBT(NBTTagCompound tag) {
        tag.func_74778_a(structureEnumNameTag, this.basicStructureName.name());
        if (this.structureDisplayName != null) {
            tag.func_74778_a(structureDisplayNameTag, this.structureDisplayName);
        }
        tag.func_74778_a(bedColorTag, this.bedColor.func_176610_l().toUpperCase());
        tag.func_74778_a(glassColorTag, this.glassColor.func_176610_l().toUpperCase());
        tag.func_74778_a(chosenOptionTag, this.chosenOption.getTranslationString());
        return tag;
    }

    @Override
    public BasicStructureConfiguration ReadFromCompoundNBT(NBTTagCompound messageTag) {
        BasicStructureConfiguration config = new BasicStructureConfiguration();
        return (BasicStructureConfiguration)super.ReadFromCompoundNBT(messageTag, config);
    }

    @Override
    protected void ConfigurationSpecificBuildStructure(EntityPlayer player, WorldServer world, BlockPos hitBlockPos) {
        StructureBasic structure;
        String assetLocation = "";
        if (!this.IsCustomStructure()) {
            assetLocation = this.chosenOption.getAssetLocation();
        }
        if ((structure = (StructureBasic)StructureBasic.CreateInstance(assetLocation, StructureBasic.class)).BuildStructure(this, (World)world, hitBlockPos, EnumFacing.NORTH, player)) {
            ItemStack stack = ItemBasicStructure.getBasicStructureItemInHand(player);
            if (stack.func_190916_E() == 1) {
                player.field_71071_by.func_184437_d(stack);
            } else {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            player.field_71069_bz.func_75142_b();
        }
    }

    public static enum EnumBasicStructureName {
        Custom("custom", null, null, null, 0),
        AquaBase("aquabase", "item.prefab:item_aqua_base.name", "item_aqua_base", AquaBaseOptions.Default, 26),
        Barn("barn", "item.prefab:item_barn.name", "item_barn", BarnOptions.Default, 5),
        BarnAdvanced("barnadvanced", "item.prefab:item_barn_advanced.name", "item_barn_advanced", BarnAdvancedOptions.Default, 10),
        DefenseBunker("defensebunker", "item.prefab:item_defense_bunker.name", "item_defense_bunker", DefenseBunkerOptions.Default, 7),
        GreenHouse("greenhouse", "item.prefab:item_green_house.name", "item_green_house", GreenHouseOptions.Default, 4),
        HorseStable("horsestable", "item.prefab:item_horse_stable.name", "item_horse_stable", HorseStableOptions.Default, 2),
        HorseStableAdvanced("horsestableadvanced", "item.prefab:item_horse_stable_advanced.name", "item_horse_stable_advanced", HorseStableAdvancedOptions.Default, 5),
        HouseAdvancedEstate("houseadvancedestate", "item.prefab:item_house_advanced_estate.name", "item_house_advanced_estate", HouseAdvancedEstateOptions.Default, 64),
        HouseBasic("housebasic", "item.prefab:item_house_basic.name", "item_house_basic", HouseBasicOptions.Default, 2),
        HouseCabin("housecabin", "item.prefab:item_house_cabin.name", "item_house_cabin", HouseCabinOptions.Default, 4),
        HouseCampsite("housecampsite", "item.prefab:item_house_campsite.name", "item_house_campsite", HouseCampsiteOptions.Default, 2),
        HouseCottage("housecottage", "item.prefab:item_house_cottage.name", "item_house_cottage", HouseCottageOptions.Default, 17),
        HouseCrimson("housecrimson", "item.prefab:item_house_crimson.name", "item_house_crimson", HouseCrimsonOptions.Default, 7),
        HouseEarthen("houseearthen", "item.prefab:item_house_earthen.name", "item_house_earthen", HouseEarthenOptions.Default, 4),
        HouseHobbit("househobbit", "item.prefab:item_house_hobbit.name", "item_house_hobbit", HouseHobbitOptions.Default, 13),
        HouseIzba("houseizba", "item.prefab:item_house_izba.name", "item_house_izba", HouseIzbaOptions.Default, 3),
        HouseJungle("housejungle", "item.prefab:item_house_jungle.name", "item_house_jungle", HouseJungleOptions.Default, 6),
        HouseMountain("housemountain", "item.prefab:item_house_mountain.name", "item_house_mountain", HouseMountainOptions.Default, 5),
        HouseMushroom("housemushroom", "item.prefab:item_house_mushroom.name", "item_house_mushroom", HouseMushroomOptions.Default, 3),
        HouseNether("housenether", "item.prefab:item_house_nether.name", "item_house_nether", HouseNetherOptions.Default, 4),
        HouseRanch("houseranch", "item.prefab:item_house_ranch.name", "item_house_ranch", HouseRanchOptions.Default, 3),
        HouseSnow("housesnow", "item.prefab:item_house_snow.name", "item_house_snow", HouseSnowOptions.Default, 2),
        HouseSpruce("housespruce", "item.prefab:item_house_spruce.name", "item_house_spruce", HouseSpruceOptions.Default, 11),
        HouseSubAqua("housesubaqua", "item.prefab:item_house_sub_aqua.name", "item_house_sub_aqua", HouseSubAquaOptions.Default, 3),
        HouseTower("housetower", "item.prefab:item_house_tower.name", "item_house_tower", HouseTowerOptions.Default, 23),
        HouseTree("housetree", "item.prefab:item_house_tree.name", "item_house_tree", HouseTreeOptions.Default, 7),
        Jail("jail", "item.prefab:item_jail.name", "item_jail", JailOptions.Default, 11),
        MachineryTower("machinerytower", "item.prefab:item_machinery_tower.name", "item_machinery_tower", MachineryTowerOptions.Default, 3),
        MagicTemple("magictemple", "item.prefab:item_magic_temple.name", "item_magic_temple", MagicTempleOptions.Default, 2),
        ModernApartment("modernapartment", "item.prefab:item_modern_apartment.name", "item_modern_apartment", ModernApartmentOptions.Default, 4),
        ModernBank("modernbank", "item.prefab:item_modern_bank.name", "item_modern_bank", ModernBankOptions.Default, 3),
        ModernCinema("moderncinema", "item.prefab:item_modern_cinema.name", "item_modern_cinema", ModernCinemaOptions.Default, 9),
        ModernCottage("moderncottage", "item.prefab:item_modern_cottage.name", "item_house_modern_cottage", ModernCottageOptions.Default, 4),
        ModernGasStation("moderngasstation", "item.prefab:item_modern_gas_station.name", "item_modern_gas_station", ModernGasStationOptions.Default, 10),
        ModernHipsterFruitStand("modernhipsterfruitstand", "item.prefab:item_modern_hipster_fruit_stand.name", "item_modern_hipster_fruit_stand", ModernHipsterFruitStandOptions.Default, 8),
        ModernHouse("modernhouse", "item.prefab:item_house_luxury.name", "item_house_luxury", ModernHouseOptions.Default, 5),
        ModernJuiceShop("modernjuiceshop", "item.prefab:item_modern_juice_shop.name", "item_modern_juice_shop", ModernJuiceShopOptions.Default, 8),
        ModernLibrary("modernlibrary", "item.prefab:item_modern_library.name", "item_modern_library", ModernLibraryOptions.Default, 11),
        ModernMallStore("modernmallstore", "item.prefab:item_modern_mall_store.name", "item_modern_mall_store", ModernMallStoreOptions.Default, 11),
        ModernMiniHotel("modernminihotel", "item.prefab:item_modern_mini_hotel.name", "item_modern_mini_hotel", ModernMiniHotelOptions.Default, 8),
        ModernRestaurant("modernrestaurant", "item.prefab:item_modern_restaurant.name", "item_modern_restaurant", ModernRestaurantOptions.Default, 8),
        ModernWaterPark("modernwaterpark", "item.prefab:item_modern_water_park.name", "item_modern_water_park", ModernWaterParkOptions.Default, 10),
        Saloon("saloon", "item.prefab:item_saloon.name", "item_saloon", SaloonOptions.Default, 3),
        SkiLodge("skilodge", "item.prefab:item_ski_lodge.name", "item_ski_lodge", SkiLodgeOptions.Default, 18),
        TownHall("townhall", "item.prefab:item_town_hall.name", "item_town_hall", TownHallOptions.Default, 5),
        VillagerHouseAngled("villagerhouseangled", "item.prefab:item_villager_house_angled.name", "item_villager_house_angled", VillagerHouseAngledOptions.Default, 1),
        VillagerHouseBlacksmith("villagerhouseblacksmith", "item.prefab:item_villager_house_blacksmith.name", "item_villager_house_blacksmith", VillagerHouseBlacksmithOptions.Default, 1),
        VillagerHouseFenced("villagerhousefenced", "item.prefab:item_villager_house_fenced.name", "item_villager_house_fenced", VillagerHouseFencedOptions.Default, 1),
        VillagerHouseFlat("villagerhouseflat", "item.prefab:item_villager_house_flat.name", "item_villager_house_flat", VillagerHouseFlatOptions.Default, 1),
        VillagerHouseLong("villagerhouselong", "item.prefab:item_villager_house_long.name", "item_villager_house_long", VillagerHouseLongOptions.Default, 1),
        Warehouse("warehouse", "item.prefab:item_warehouse.name", "item_warehouse", WarehouseOptions.Default, 6),
        WatchTower("watchtower", "item.prefab:item_watch_tower.name", "item_watch_tower", WatchTowerOptions.Default, 2),
        WatchTowerDark("watchtowerdark", "item.prefab:item_watch_tower_dark.name", "item_watch_tower_dark", WatchTowerDarkOptions.Default, 2),
        WelcomeCenter("welcomecenter", "item.prefab:item_welcome_center.name", "item_welcome_center", WelcomeCenterOptions.Default, 23),
        WindMill("windmill", "item.prefab:item_wind_mill.name", "item_wind_mill", WindMillOptions.Default, 4);

        private final String name;
        private final String itemTranslationString;
        private final BaseOption baseOption;
        private ResourceLocation itemTextureLocation;
        private int costToBuy;

        private EnumBasicStructureName(String name, String itemTranslationString, String itemTextureLocation, BaseOption baseOption, int costToBuy) {
            this.name = name;
            this.itemTranslationString = itemTranslationString;
            if (itemTextureLocation != null) {
                this.itemTextureLocation = new ResourceLocation("prefab", itemTextureLocation);
            }
            this.baseOption = baseOption;
            this.costToBuy = costToBuy;
        }

        public String getName() {
            return this.name;
        }

        public String getItemTranslationString() {
            return this.itemTranslationString;
        }

        public ResourceLocation getItemTextureLocation() {
            return this.itemTextureLocation;
        }

        public BaseOption getBaseOption() {
            return this.baseOption;
        }

        public int getCostToBuy() {
            return this.costToBuy;
        }
    }
}

