/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.structures.base;

import com.wuest.prefab.Triple;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBed;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BuildingMethods {
    public static void ClearSpace(World world, BlockPos startingPosition, int width, int height, int depth, EnumFacing houseFacing) {
        BlockPos northSide = startingPosition.func_177967_a(houseFacing, 5).func_177967_a(houseFacing.func_176746_e(), 5);
        int clearedWidth = width + 12;
        int wallLength = depth + 12;
        for (int i = 0; i < clearedWidth; ++i) {
            BuildingMethods.CreateWall(world, height, wallLength, houseFacing.func_176734_d(), northSide, Blocks.field_150350_a, null);
            northSide = northSide.func_177972_a(houseFacing.func_176735_f());
        }
    }

    public static void ClearSpaceExact(World world, BlockPos startingPosition, int width, int height, int depth, EnumFacing houseFacing) {
        BlockPos otherCorner = startingPosition.func_177967_a(houseFacing.func_176734_d(), depth).func_177967_a(houseFacing.func_176735_f(), width);
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)startingPosition, (BlockPos)otherCorner)) {
            if (world.func_175623_d(pos)) continue;
            BuildingMethods.ReplaceBlock(world, pos, Blocks.field_150350_a);
        }
    }

    public static ArrayList<ItemStack> ConsolidateDrops(Block block, World world, BlockPos pos, IBlockState state, ArrayList<ItemStack> originalStacks, ArrayList<Item> itemsToNotAdd) {
        for (ItemStack stack : block.getDrops((IBlockAccess)world, pos, state, 1)) {
            if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.func_77973_b())) continue;
            Boolean foundStack = false;
            for (ItemStack existingStack : originalStacks) {
                if (!ItemStack.func_179545_c((ItemStack)existingStack, (ItemStack)stack) || existingStack.func_190916_E() + stack.func_190916_E() > stack.func_77976_d()) continue;
                existingStack.func_190920_e(existingStack.func_190916_E() + stack.func_190916_E());
                foundStack = true;
                break;
            }
            if (foundStack.booleanValue()) continue;
            originalStacks.add(stack);
        }
        return originalStacks;
    }

    public static ArrayList<ItemStack> CreateWall(World world, int height, int length, EnumFacing direction, BlockPos startingPosition, Block replacementBlock, ArrayList<Item> itemsToNotAdd) {
        ArrayList<ItemStack> itemsDropped = new ArrayList<ItemStack>();
        BlockPos wallPos = null;
        for (int i = 0; i < height; ++i) {
            wallPos = startingPosition.func_177981_b(i);
            for (int j = 0; j < length; ++j) {
                for (ItemStack stack : world.func_180495_p(wallPos).func_177230_c().getDrops((IBlockAccess)world, wallPos, world.func_180495_p(wallPos), 1)) {
                    if (itemsToNotAdd != null && itemsToNotAdd.contains(stack.func_77973_b())) continue;
                    itemsDropped.add(stack);
                }
                BuildingMethods.ReplaceBlock(world, wallPos, replacementBlock);
                wallPos = wallPos.func_177972_a(direction);
            }
        }
        return itemsDropped;
    }

    public static ArrayList<ItemStack> CreateWall(World world, int height, int length, EnumFacing direction, BlockPos startingPosition, IBlockState replacementBlock) {
        ArrayList<ItemStack> itemsDropped = new ArrayList<ItemStack>();
        BlockPos wallPos = null;
        for (int i = 0; i < height; ++i) {
            wallPos = startingPosition.func_177981_b(i);
            for (int j = 0; j < length; ++j) {
                for (ItemStack stack : world.func_180495_p(wallPos).func_177230_c().getDrops((IBlockAccess)world, wallPos, world.func_180495_p(wallPos), 1)) {
                    itemsDropped.add(stack);
                }
                BuildingMethods.ReplaceBlock(world, wallPos, replacementBlock);
                wallPos = wallPos.func_177972_a(direction);
            }
        }
        return itemsDropped;
    }

    public static ArrayList<ItemStack> SetFloor(World world, BlockPos pos, Block block, int width, int depth, ArrayList<ItemStack> originalStack, EnumFacing facing, ArrayList<Item> itemsToNotAdd) {
        for (int i = 0; i < width; ++i) {
            originalStack.addAll(BuildingMethods.CreateWall(world, 1, depth, facing, pos, block, itemsToNotAdd));
            pos = pos.func_177972_a(facing.func_176746_e());
        }
        return originalStack;
    }

    public static void ReplaceBlock(World world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlock.func_176223_P(), 3);
    }

    public static void ReplaceBlockNoAir(World world, BlockPos pos, Block replacementBlock) {
        BuildingMethods.ReplaceBlockNoAir(world, pos, replacementBlock.func_176223_P(), 3);
    }

    public static void ReplaceBlock(World world, BlockPos pos, IBlockState replacementBlockState) {
        BuildingMethods.ReplaceBlock(world, pos, replacementBlockState, 3);
    }

    public static void ReplaceBlockNoAir(World world, BlockPos pos, IBlockState replacementBlockState) {
        BuildingMethods.ReplaceBlockNoAir(world, pos, replacementBlockState, 3);
    }

    public static void ReplaceBlock(World world, BlockPos pos, IBlockState replacementBlockState, int flags) {
        world.func_175698_g(pos);
        world.func_180501_a(pos, replacementBlockState, flags);
    }

    public static void ReplaceBlockNoAir(World world, BlockPos pos, IBlockState replacementBlockState, int flags) {
        world.func_180501_a(pos, replacementBlockState, flags);
    }

    public static int GetTorchFacing(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 4;
            }
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 3;
            }
            case WEST: {
                return 2;
            }
        }
        return 5;
    }

    public static Triple<Boolean, IBlockState, BlockPos> CheckBuildSpaceForAllowedBlockReplacement(World world, BlockPos startBlockPos, BlockPos endBlockPos, EntityPlayer player) {
        for (BlockPos currentPos : BlockPos.func_177980_a((BlockPos)startBlockPos, (BlockPos)endBlockPos)) {
            IBlockState blockState = world.func_180495_p(currentPos);
            if (world.func_73046_m().func_175579_a(world, currentPos, player)) {
                System.out.println("TORGO1: " + blockState.func_177230_c().getRegistryName() + " " + currentPos.toString());
                return new Triple<Boolean, IBlockState, BlockPos>(false, blockState, currentPos);
            }
            if (!blockState.func_177230_c().func_176200_f((IBlockAccess)world, currentPos)) {
                System.out.println("TORGO2: " + blockState.func_177230_c().getRegistryName() + " " + currentPos.toString());
                return new Triple<Boolean, IBlockState, BlockPos>(false, blockState, currentPos);
            }
            if (!(blockState.func_185887_b(world, currentPos) < 0.0f)) continue;
            System.out.println("TORGO3: " + blockState.func_177230_c().getRegistryName() + " " + currentPos.toString());
            return new Triple<Boolean, IBlockState, BlockPos>(false, blockState, currentPos);
        }
        return new Triple<Boolean, Object, Object>(true, null, null);
    }

    public static void PlaceColoredBed(World world, BlockPos bedHeadPos, BlockPos bedFootPos, EnumDyeColor bedColor) {
        IBlockState bedHead = null;
        IBlockState bedFoot = null;
        bedHead = Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD);
        bedFoot = Blocks.field_150324_C.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT);
        EnumFacing direction = EnumFacing.NORTH;
        BlockPos tempPos = bedHeadPos.func_177972_a(EnumFacing.NORTH);
        while (tempPos.func_177958_n() != bedFootPos.func_177958_n() || tempPos.func_177952_p() != bedFootPos.func_177952_p()) {
            direction = direction.func_176746_e();
            tempPos = bedHeadPos.func_177972_a(direction);
        }
        bedHead = bedHead.func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)direction.func_176734_d());
        bedFoot = bedFoot.func_177226_a((IProperty)BlockBed.field_185512_D, (Comparable)direction.func_176734_d());
        BuildingMethods.ReplaceBlock(world, bedHeadPos, bedHead);
        BuildingMethods.ReplaceBlock(world, bedFootPos, bedFoot);
        TileEntity bedHeadTileEntity = world.func_175625_s(bedHeadPos);
        TileEntity bedFootTileEntity = world.func_175625_s(bedFootPos);
        if (bedHeadTileEntity != null && bedHeadTileEntity instanceof TileEntityBed) {
            TileEntityBed entityHeadBed = (TileEntityBed)bedHeadTileEntity;
            entityHeadBed.func_193052_a(bedColor);
        }
        if (bedFootTileEntity != null && bedFootTileEntity instanceof TileEntityBed) {
            TileEntityBed entityFootBed = (TileEntityBed)bedFootTileEntity;
            entityFootBed.func_193052_a(bedColor);
        }
    }
}

