/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GuiUtils {
    public static void bindTexture(ResourceLocation resourceLocation) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocation);
    }

    public static void drawContinuousTexturedBox(ResourceLocation res, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        GuiUtils.bindTexture(res);
        GuiUtils.drawContinuousTexturedBox(x, y, u, v, width, height, textureWidth, textureHeight, topBorder, bottomBorder, leftBorder, rightBorder, zLevel);
    }

    public static void drawContinuousTexturedBox(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        GuiUtils.drawTexturedModalRect(x, y, u, v, leftBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                GuiUtils.drawTexturedModalRect(x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            GuiUtils.drawTexturedModalRect(x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            GuiUtils.drawTexturedModalRect(x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        wr.func_181662_b((double)x, (double)(y + height), (double)zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        wr.func_181662_b((double)(x + width), (double)(y + height), (double)zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)(v + height) * 0.00390625f)).func_181675_d();
        wr.func_181662_b((double)(x + width), (double)y, (double)zLevel).func_187315_a((double)((float)(u + width) * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
        wr.func_181662_b((double)x, (double)y, (double)zLevel).func_187315_a((double)((float)u * 0.00390625f), (double)((float)v * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawModalRectWithCustomSizedTexture(int x, int y, int z, int width, int height, float textureWidth, float textureHeight) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        float u = 0.0f;
        float v = 0.0f;
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a((double)(u * f), (double)((v + (float)height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a((double)((u + (float)width) * f), (double)((v + (float)height) * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a((double)((u + (float)width) * f), (double)(v * f1)).func_181675_d();
        vertexbuffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void bindAndDrawModalRectWithCustomSizedTexture(ResourceLocation resourceLocation, int x, int y, int z, int width, int height, float textureWidth, float textureHeight) {
        GuiUtils.bindTexture(resourceLocation);
        GuiUtils.drawModalRectWithCustomSizedTexture(x, y, z, width, height, textureWidth, textureHeight);
    }

    public static void setButtonText(GuiButton button, String message) {
        button.field_146126_j = message;
    }

    public static void drawCenteredString(FontRenderer fontRendererIn, String text, int x, int y, int color, boolean withShadow) {
        fontRendererIn.func_175065_a(text, (float)(x - fontRendererIn.func_78256_a(text) / 2), (float)y, color, withShadow);
    }
}

