/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.events;

import com.wuest.prefab.ModRegistry;
import com.wuest.prefab.Prefab;
import com.wuest.prefab.blocks.IMetaBlock;
import com.wuest.prefab.config.EntityPlayerConfiguration;
import com.wuest.prefab.items.ItemBogus;
import com.wuest.prefab.proxy.ClientProxy;
import com.wuest.prefab.structures.render.StructureRenderHandler;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientEventHandler {
    public static int ticksInGame;
    public static EntityPlayerConfiguration playerConfig;

    @SubscribeEvent
    public static void onWorldRenderLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.field_71476_x != null && mc.field_71476_x.func_178782_a() != null && !mc.field_71439_g.func_70093_af()) {
            StructureRenderHandler.renderPlayerLook((EntityPlayer)mc.field_71439_g, mc.field_71476_x, event);
        }
        if (ItemBogus.renderTest) {
            ClientEventHandler.RenderTest((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
        }
    }

    @SubscribeEvent
    public static void OnClientDisconnectEvent(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ((ClientProxy)Prefab.proxy).serverConfiguration = null;
        playerConfig.clearNonPersistedObjects();
    }

    @SubscribeEvent
    public static void ClientTickEnd(TickEvent.ClientTickEvent event) {
        GuiScreen gui;
        if (!(event.phase != TickEvent.Phase.END || (gui = Minecraft.func_71410_x().field_71462_r) != null && gui.func_73868_f())) {
            if (2147483547 == ticksInGame) {
                ticksInGame = 1;
            }
            ++ticksInGame;
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        for (Block block : ModRegistry.ModBlocks) {
            ClientEventHandler.regBlock(block);
        }
        for (Item item : ModRegistry.ModItems) {
            ClientEventHandler.regItem(item);
        }
    }

    public static void regItem(Item item) {
        ClientEventHandler.regItem(item, 0, item.func_77658_a().substring(5));
    }

    public static void regItem(Item item, int metaData, String blockName) {
        ModelResourceLocation location = new ModelResourceLocation(blockName, "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metaData, (ModelResourceLocation)location);
    }

    public static void regBlock(Block block) {
        NonNullList stacks = NonNullList.func_191196_a();
        Item itemBlock = Item.func_150898_a((Block)block);
        block.func_149666_a(null, stacks);
        if (itemBlock != null) {
            if (stacks.size() > 0) {
                for (ItemStack stack : stacks) {
                    Block subBlock = block.func_176203_a(stack.func_77960_j()).func_177230_c();
                    String name = "";
                    name = block instanceof IMetaBlock ? "prefab:" + ((IMetaBlock)block).getMetaDataUnLocalizedName(stack.func_77960_j()) : subBlock.getRegistryName().toString();
                    ClientEventHandler.regItem(stack.func_77973_b(), stack.func_77960_j(), name);
                }
            } else {
                ClientEventHandler.regItem(itemBlock);
            }
        }
    }

    private static void RenderTest(World worldIn, EntityPlayer playerIn) {
        float partialTicks = Minecraft.func_71410_x().func_184121_ak();
        EntityPlayer entityplayer = playerIn;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        BlockPos playerPosition = new BlockPos(entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v);
        BlockPos blockPos = playerPosition.func_177972_a(entityplayer.func_174811_aO().func_176734_d());
        double playerVertical = entityplayer.field_70137_T + (entityplayer.field_70163_u - entityplayer.field_70137_T) * (double)partialTicks;
        double playerLevelYCoordinate = (double)(blockPos.func_177956_o() - Math.abs(playerPosition.func_177956_o())) + ((double)playerPosition.func_177956_o() - entityplayer.field_70163_u);
        double playerLevelUpOneYCoordinate = (double)(blockPos.func_177956_o() - Math.abs(playerPosition.func_177956_o()) + 1) + ((double)playerPosition.func_177956_o() - entityplayer.field_70163_u);
        double blockXOffset = (double)(playerPosition.func_177958_n() - blockPos.func_177958_n()) + ((double)playerPosition.func_177958_n() - entityplayer.field_70165_t);
        double blocZOffset = (double)(playerPosition.func_177952_p() - blockPos.func_177952_p()) + ((double)playerPosition.func_177952_p() - entityplayer.field_70161_v);
        GlStateManager.func_179090_x();
        GlStateManager.func_179084_k();
        GlStateManager.func_187441_d((float)3.0f);
        vertexbuffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (int k = 1; k < 2; ++k) {
            vertexbuffer.func_181662_b(blockXOffset, playerLevelYCoordinate, blocZOffset).func_181666_a(0.6f, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset, playerLevelUpOneYCoordinate, blocZOffset).func_181666_a(0.6f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset + (double)k, playerLevelYCoordinate, blocZOffset).func_181666_a(1.0f, 0.6f, 0.0f, 0.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset + (double)k, playerLevelUpOneYCoordinate, blocZOffset).func_181666_a(1.0f, 0.6f, 0.0f, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset, playerLevelYCoordinate, blocZOffset + (double)k).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset, playerLevelUpOneYCoordinate, blocZOffset + (double)k).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset + 1.0, playerLevelYCoordinate, blocZOffset + (double)k).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset + 1.0, playerLevelUpOneYCoordinate, blocZOffset + (double)k).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        }
        for (int i1 = playerPosition.func_177956_o(); i1 <= playerPosition.func_177956_o() + 1; ++i1) {
            double d7 = (double)i1 - playerVertical;
            vertexbuffer.func_181662_b(blockXOffset, d7, blocZOffset).func_181666_a(1.0f, 1.0f, 0.0f, 0.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset, d7, blocZOffset + 1.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset + 1.0, d7, blocZOffset + 1.0).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset + 1.0, d7, blocZOffset).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            vertexbuffer.func_181662_b(blockXOffset, d7, blocZOffset).func_181666_a(1.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
    }

    private static void drawLineWithGL(Vec3d blockA, Vec3d blockB) {
        GL11.glColor4f((float)1.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)blockA.field_72450_a, (double)blockA.field_72448_b, (double)blockA.field_72449_c);
        GL11.glVertex3d((double)blockB.field_72450_a, (double)blockB.field_72448_b, (double)blockB.field_72449_c);
        GL11.glEnd();
    }

    static {
        playerConfig = new EntityPlayerConfiguration();
    }
}

