/*
 * Decompiled with CFR 0.152.
 */
package com.wuest.prefab.base;

import com.wuest.prefab.capabilities.ITransferable;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class ItemBlockCapability
extends ItemBlock {
    protected ArrayList<Capability> allowedCapabilities;

    public ItemBlockCapability(Block block, ArrayList<Capability> allowedCapabilities) {
        super(block);
        this.allowedCapabilities = allowedCapabilities;
    }

    public ArrayList<Capability> getAllowedCapabilities() {
        if (this.allowedCapabilities == null) {
            this.allowedCapabilities = new ArrayList();
            this.addAllowedCapabilities();
        }
        return this.allowedCapabilities;
    }

    public ItemBlockCapability setAllowedCapabilities(ArrayList<Capability> value) {
        this.allowedCapabilities = value;
        return this;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.field_150939_a) {
            ItemBlockCapability.func_179224_a((World)world, (EntityPlayer)player, (BlockPos)pos, (ItemStack)stack);
            this.field_150939_a.func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
        }
        return true;
    }

    protected void setTileEntityCapabilities(World world, EntityPlayer player, BlockPos pos, ItemStack stack, EnumFacing side) {
        TileEntity tileEntity;
        if (world.field_72995_K && (tileEntity = world.func_175625_s(pos)) != null) {
            for (Capability capability : this.allowedCapabilities) {
                Object stackCapability = stack.getCapability(capability, side);
                Object tileEntityCapability = tileEntity.getCapability(capability, side);
                if (stackCapability == null || tileEntityCapability == null || !(stackCapability instanceof ITransferable) || !(tileEntityCapability instanceof ITransferable)) continue;
                ((ITransferable)tileEntityCapability).Transfer((ITransferable)stackCapability);
            }
        }
    }

    protected void addAllowedCapabilities() {
    }
}

