/*
 * Decompiled with CFR 0.152.
 */
package fluke.worleycaves.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="worleycaves", category="")
@Mod.EventBusSubscriber(modid="worleycaves")
public class Configs {
    public static ConfigCaveGen cavegen = new ConfigCaveGen();

    @SubscribeEvent
    public static void onConfigReload(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("worleycaves".equals(event.getModID())) {
            ConfigManager.sync((String)"worleycaves", (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class ConfigCaveGen {
        @Config.Comment(value={"Controls size of caves. Smaller values = larger caves. Between -1.0 and 1.0", "Default: -0.18"})
        @Config.RequiresWorldRestart
        public double noiseCutoffValue = -0.18;
        @Config.Comment(value={"Controls size of caves at the surface. Smaller values = more caves break through the surface. Between -1.0 and 1.0", "Default: -0.081 (45% of noiseCutoffValue)"})
        @Config.RequiresWorldRestart
        public double surfaceCutoffValue = -0.081;
        @Config.Comment(value={"Controls how much to warp caves. Lower values = straighter caves", "Default: 8.0"})
        @Config.RequiresWorldRestart
        public double warpAmplifier = 8.0;
        @Config.Comment(value={"Reduces number of caves at surface level, becoming more common until caves generate normally X number of blocks below the surface", "Default: 15"})
        @Config.RequiresWorldRestart
        public int easeInDepth = 15;
        @Config.Comment(value={"Squishes caves on the Y axis. Lower values = taller caves and more steep drops", "Default: 2.0"})
        @Config.RequiresWorldRestart
        public double verticalCompressionMultiplier = 2.0;
        @Config.Comment(value={"Streches (when < 1.0) or compresses (when > 1.0) cave generation along X and Z axis", "Default: 1.0"})
        @Config.RequiresWorldRestart
        public double horizonalCompressionMultiplier = 1.0;
        @Config.Comment(value={"Dimension IDs that will use Vanilla cave generation rather than Worley's Caves", "Default:"})
        @Config.RequiresWorldRestart
        public int[] blackListedDims = new int[0];
        @Config.Comment(value={"Caves will not attempt to generate above this y level. Range 1-256", "Default: 128"})
        @Config.RequiresWorldRestart
        public int maxCaveHeight = 128;
        @Config.Comment(value={"Caves will not attempt to generate below this y level. Range 1-256", "Default: 1"})
        @Config.RequiresWorldRestart
        public int minCaveHeight = 1;
        @Config.Comment(value={"Block to use when generating large lava lakes below lavaDepth (usually y=10)", "Default: minecraft:lava"})
        @Config.RequiresWorldRestart
        public String lavaBlock = "minecraft:lava";
        @Config.Comment(value={"Air blocks at or below this y level will generate as lavaBlock", "Default: 10"})
        @Config.RequiresWorldRestart
        public int lavaDepth = 10;
        @Config.Comment(value={"Allow replacing more blocks with caves (useful for mods which completely overwrite world gen)"})
        @Config.RequiresWorldRestart
        public boolean allowReplaceMoreBlocks = true;
    }
}

