/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.wireless;

import java.util.UUID;
import javax.annotation.Nullable;
import lain.mods.wireless.ConfigOptions;
import lain.mods.wireless.TileEntityWirelessCharger;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockWirelessCharger
extends Block
implements ITileEntityProvider {
    public BlockWirelessCharger() {
        super(Material.field_151576_e);
        this.func_149663_c("wirelesscharger.wirelesscharger");
        this.setRegistryName("wirelesscharger");
        this.func_149711_c(2.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78028_d);
        GameRegistry.registerTileEntity(TileEntityWirelessCharger.class, (String)"wirelesscharger_wirelesscharger");
    }

    public TileEntity func_149915_a(World arg0, int arg1) {
        return new TileEntityWirelessCharger();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityWirelessCharger t;
        super.getDrops(drops, world, pos, state, fortune);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityWirelessCharger && (t = (TileEntityWirelessCharger)tile).hasUpgradeItem()) {
            drops.add((Object)t.getUpgradeItem().func_77946_l());
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.updateRedstoneState(worldIn, pos);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityWirelessCharger) {
            ItemStack s;
            TileEntityWirelessCharger t = (TileEntityWirelessCharger)tile;
            if (!t.isUpgraded() && !(s = playerIn.func_184586_b(hand)).func_190926_b() && ConfigOptions.UpgradeItem.equals((Object)s.func_77973_b().getRegistryName()) && s.func_190916_E() > 0) {
                ItemStack put = s.func_77946_l();
                put.func_190920_e(1);
                t.setUpgradeItem(put);
                t.setTargetUser(playerIn.func_110124_au());
                t.setUpgraded(true);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    s.func_190918_g(1);
                }
                return true;
            }
            TileEntityWirelessCharger.EnergyStorage energy = t.getEnergyStorage();
            StringBuilder s2 = new StringBuilder();
            s2.append(String.format("%d/%d", energy.getEnergyStored(), energy.getMaxEnergyStored()));
            if (t.isUpgraded()) {
                s2.append(" ");
                String name = UsernameCache.getLastKnownUsername((UUID)t.getTargetUser());
                if (name == null) {
                    name = t.getTargetUser().toString();
                }
                s2.append(name);
            }
            playerIn.func_146105_b((ITextComponent)new TextComponentString(s2.toString()), true);
        }
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.updateRedstoneState(worldIn, pos);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    private void updateRedstoneState(World worldIn, BlockPos pos) {
        TileEntity tile;
        if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityWirelessCharger) {
            TileEntityWirelessCharger t = (TileEntityWirelessCharger)tile;
            t.setDisabled(worldIn.func_175640_z(pos));
        }
    }
}

