/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.engine.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.darkhax.wawla.lib.InfoAccess;
import net.darkhax.wawla.plugins.FeatureManager;
import net.darkhax.wawla.plugins.InfoProvider;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileProvider
implements IWailaDataProvider {
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        InfoAccess info = new InfoAccess(accessor.getMOP(), accessor.getWorld(), accessor.getPlayer(), accessor.getStack(), accessor.getBlockState(), accessor.getPosition(), accessor.getSide(), accessor.getNBTData());
        if (info.isValidBlock()) {
            for (InfoProvider provider : FeatureManager.tileProviders) {
                if (!provider.requireTileOverride(info)) continue;
                info = provider.overrideTile(info);
            }
        }
        return info.stack;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        InfoAccess info = this.getInfo(accessor);
        for (InfoProvider provider : FeatureManager.tileProviders) {
            provider.addTileInfo(currenttip, info);
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        for (InfoProvider provider : FeatureManager.tileProviders) {
            if (!provider.requireTileSync(world, te)) continue;
            provider.writeTileNBT(world, te, tag);
        }
        return tag;
    }

    public static void register(IWailaRegistrar register) {
        TileProvider provider = new TileProvider();
        register.registerBodyProvider((IWailaDataProvider)provider, Block.class);
        register.registerNBTProvider((IWailaDataProvider)provider, Block.class);
    }

    private InfoAccess getInfo(IWailaDataAccessor accessor) {
        NBTTagCompound tag = new NBTTagCompound();
        if (accessor.getTileEntity() != null) {
            for (InfoProvider provider : FeatureManager.tileProviders) {
                if (!provider.requireTileSync(accessor.getWorld(), accessor.getTileEntity())) continue;
                tag = accessor.getNBTData();
                break;
            }
        }
        return new InfoAccess(accessor.getMOP(), accessor.getWorld(), accessor.getPlayer(), accessor.getStack(), accessor.getBlockState(), accessor.getPosition(), accessor.getSide(), tag);
    }
}

