/*
 * Decompiled with CFR 0.152.
 */
package squeek.wailaharvestability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import squeek.wailaharvestability.Config;
import squeek.wailaharvestability.helpers.BlockHelper;
import squeek.wailaharvestability.helpers.ColorHelper;
import squeek.wailaharvestability.helpers.StringHelper;
import squeek.wailaharvestability.helpers.ToolHelper;
import squeek.wailaharvestability.proxy.ProxyCreativeBlocks;
import squeek.wailaharvestability.proxy.ProxyGregTech;

public class WailaHandler
implements IWailaDataProvider {
    public static HashMap<String, Boolean> configOptions = new HashMap();

    public static void callbackRegister(IWailaRegistrar registrar) {
        for (Map.Entry<String, Boolean> entry : configOptions.entrySet()) {
            registrar.addConfig("Harvestability", entry.getKey(), entry.getValue().booleanValue());
        }
        WailaHandler instance = new WailaHandler();
        registrar.registerBodyProvider((IWailaDataProvider)instance, Block.class);
    }

    @Nonnull
    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public List<String> getWailaBody(ItemStack itemStack, List<String> toolTip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        IBlockState blockState = accessor.getBlockState();
        if (ProxyCreativeBlocks.isCreativeBlock(block, accessor.getMetadata())) {
            return toolTip;
        }
        EntityPlayer player = accessor.getPlayer();
        if (!ProxyGregTech.isOreBlock(block) && itemStack.func_77973_b() instanceof ItemBlock) {
            block = Block.func_149634_a((Item)itemStack.func_77973_b());
            blockState = block.func_176203_a(itemStack.func_77952_i());
        }
        boolean minimalLayout = config.getConfig("harvestability.minimal", false);
        ArrayList<String> stringParts = new ArrayList<String>();
        this.getHarvestability(stringParts, player, block, blockState, accessor.getPosition(), config, minimalLayout);
        if (!stringParts.isEmpty()) {
            if (minimalLayout) {
                toolTip.add(StringHelper.concatenateStringList(stringParts, TextFormatting.RESET + Config.MINIMAL_SEPARATOR_STRING));
            } else {
                toolTip.addAll(stringParts);
            }
        }
        return toolTip;
    }

    private String harvestString(boolean success, String harvestString) {
        return ColorHelper.getBooleanColor(success) + (success ? Config.CURRENTLY_HARVESTABLE_STRING : Config.NOT_CURRENTLY_HARVESTABLE_STRING) + TextFormatting.RESET + " " + harvestString + " ";
    }

    private boolean silkTouchMatters(Block block, IBlockState blockState) {
        Item itemDropped = block.func_180660_a(blockState, new Random(), 0);
        return itemDropped instanceof ItemBlock && itemDropped != Item.func_150898_a((Block)block) || block.func_149745_a(new Random()) <= 0;
    }

    private boolean silkTouchRequired(Block block) {
        return block.func_149745_a(new Random()) <= 0;
    }

    public void getHarvestability(List<String> stringList, EntityPlayer player, Block block, IBlockState blockState, BlockPos position, IWailaConfigHandler config, boolean minimalLayout) {
        boolean harvestable;
        if (BlockHelper.isBlockUnbreakable(block, player.field_70170_p, position, blockState)) {
            stringList.add(this.harvestString(false, "Unbreakable"));
            return;
        }
        ArrayList<String> harvestLevels = new ArrayList<String>();
        harvestLevels.add(0, "Wood");
        harvestLevels.add(1, "Stone");
        harvestLevels.add(2, "Iron");
        harvestLevels.add(3, "Diamond");
        harvestLevels.add(4, "Draconic");
        boolean blockShearable = block instanceof IShearable;
        boolean silkTouchRequired = this.silkTouchRequired(block);
        boolean playerHasSilkTouch = false;
        String shearString = "";
        ItemStack itemHeld = player.func_184614_ca();
        Boolean silkTouchMatters = this.silkTouchMatters(block, blockState);
        String silkTouchString = "";
        boolean canHarvest = blockState.func_185904_a().func_76229_l();
        int toolHarvestLevel = 0;
        int blockHarvestLevel = block.getHarvestLevel(blockState);
        String effectiveTool = BlockHelper.getEffectiveToolOf(player.field_70170_p, position, block, blockState);
        String toolName = "N/A";
        if (blockHarvestLevel >= 0) {
            toolName = (String)harvestLevels.get(blockHarvestLevel);
        }
        if (effectiveTool != null && blockHarvestLevel < 0) {
            blockHarvestLevel = 0;
        }
        if (effectiveTool == null) {
            effectiveTool = "N/A";
        }
        if (!itemHeld.func_190926_b() && itemHeld.func_77973_b() instanceof ItemTool) {
            playerHasSilkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)itemHeld) > 0;
            canHarvest = ToolHelper.canToolHarvestBlock(itemHeld, blockState);
            toolHarvestLevel = ToolHelper.getToolHarvestLevel((ItemTool)itemHeld.func_77973_b(), itemHeld);
            if (blockHarvestLevel >= 0) {
                toolName = (String)harvestLevels.get(blockHarvestLevel);
            }
        }
        if (blockShearable) {
            boolean canShear = this.canShear(player, itemHeld, block, position);
            shearString = " " + ColorHelper.getBooleanColor(canShear) + Config.SHEARABILITY_STRING + TextFormatting.RESET;
            if (canShear) {
                stringList.add(this.harvestString(true, "Shearable" + shearString));
                return;
            }
        }
        if (silkTouchMatters.booleanValue()) {
            silkTouchString = " " + ColorHelper.getBooleanColor(playerHasSilkTouch) + Config.SILK_TOUCHABILITY_STRING + TextFormatting.RESET;
            if (silkTouchRequired && !playerHasSilkTouch) {
                stringList.add(this.harvestString(false, "Harvestable" + shearString + silkTouchString));
                return;
            }
        }
        if (canHarvest && toolHarvestLevel >= blockHarvestLevel || blockHarvestLevel == -1) {
            harvestable = true;
            this.printFooter(block, stringList, harvestable, shearString, silkTouchString, effectiveTool, toolName);
        } else {
            harvestable = false;
            this.printFooter(block, stringList, harvestable, shearString, silkTouchString, effectiveTool, toolName);
        }
    }

    public void printFooter(Block block, List<String> stringList, boolean harvestable, String shearString, String silkTouchString, String effectiveTool, String toolName) {
        stringList.add(this.harvestString(harvestable, "Harvestable" + shearString + silkTouchString));
        if (!effectiveTool.equals("N/A")) {
            stringList.add("Effective Tool: " + effectiveTool);
        }
        if (!block.func_149739_a().matches("tile.bigbin") && !toolName.equals("N/A")) {
            stringList.add("Min Tool Level: " + toolName);
        }
    }

    public boolean canShear(EntityPlayer player, ItemStack itemHeld, Block block, BlockPos position) {
        boolean isHoldingShears = !itemHeld.func_190926_b() && itemHeld.func_77973_b() instanceof ItemShears;
        boolean isShearable = ((IShearable)block).isShearable(itemHeld, (IBlockAccess)player.field_70170_p, position);
        return isShearable && isHoldingShears;
    }

    @Nonnull
    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }

    static {
        configOptions.put("harvestability.harvestlevel", true);
        configOptions.put("harvestability.harvestlevelnum", false);
        configOptions.put("harvestability.effectivetool", true);
        configOptions.put("harvestability.currentlyharvestable", true);
        configOptions.put("harvestability.harvestlevel.sneakingonly", false);
        configOptions.put("harvestability.harvestlevelnum.sneakingonly", false);
        configOptions.put("harvestability.effectivetool.sneakingonly", false);
        configOptions.put("harvestability.currentlyharvestable.sneakingonly", false);
        configOptions.put("harvestability.oresonly", false);
        configOptions.put("harvestability.minimal", false);
        configOptions.put("harvestability.unharvestableonly", false);
        configOptions.put("harvestability.toolrequiredonly", true);
        configOptions.put("harvestability.shearability", true);
        configOptions.put("harvestability.shearability.sneakingonly", false);
        configOptions.put("harvestability.silktouchability", true);
        configOptions.put("harvestability.silktouchability.sneakingonly", false);
    }
}

