/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import net.minecraft.util.ResourceLocation;

public class FileUtil {
    public static InputStream getInputStreamFromFile(File file) throws FileNotFoundException {
        return new FileInputStream(file);
    }

    public static InputStream getInputStreamFromResource(String resource) {
        return FileUtil.class.getResourceAsStream(resource);
    }

    public static InputStream getInputStreamFromResource(ResourceLocation resource) {
        return FileUtil.getInputStreamFromResource("/assets/" + resource.func_110624_b() + "/" + resource.func_110623_a());
    }

    public static File[] getFilesInDirectionary(File file) throws Exception {
        return file.listFiles();
    }

    public static String[] getFileNamesInDirectionary(File file, String toreplace, String replaced) throws Exception {
        File[] files;
        if (file.exists() && (files = FileUtil.getFilesInDirectionary(file)) != null) {
            String[] names = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                names[i] = files[i].getName().replaceAll(toreplace, replaced);
            }
            return names;
        }
        return new String[0];
    }

    public static File getMainDirectory() {
        return new File(System.getProperty("user.dir"));
    }
}

