/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.repack.com.jagrosh.discordipc;

import info.u_team.u_team_core.repack.com.jagrosh.discordipc.IPCListener;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.Callback;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.DiscordBuild;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.Packet;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.RichPresence;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.entities.User;
import info.u_team.u_team_core.repack.com.jagrosh.discordipc.exceptions.NoDiscordClientException;
import info.u_team.u_team_core.repack.org.json.JSONException;
import info.u_team.u_team_core.repack.org.json.JSONObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class IPCClient
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger((String)IPCClient.class.getSimpleName());
    private final int version = 1;
    private final long clientId;
    private final HashMap<String, Callback> callbacks = new HashMap();
    private Status status = Status.CREATED;
    private DiscordBuild build = null;
    private IPCListener listener = null;
    private RandomAccessFile pipe = null;
    private Thread readThread = null;
    private static final String[] paths = new String[]{"XDG_RUNTIME_DIR", "TMPDIR", "TMP", "TEMP"};

    public IPCClient(long clientId) {
        this.clientId = clientId;
    }

    public void setListener(IPCListener listener) {
        this.listener = listener;
    }

    public void connect(DiscordBuild ... preferredOrder) throws NoDiscordClientException {
        int i;
        this.checkConnected(false);
        this.status = Status.CONNECTING;
        if (preferredOrder == null || preferredOrder.length == 0) {
            preferredOrder = new DiscordBuild[]{DiscordBuild.ANY};
        }
        this.callbacks.clear();
        this.pipe = null;
        this.build = null;
        RandomAccessFile[] open = new RandomAccessFile[DiscordBuild.values().length];
        for (i = 0; i < 10; ++i) {
            try {
                String ipc = IPCClient.getIPC(i);
                LOGGER.debug(String.format("Searching for IPC: %s", ipc));
                this.pipe = new RandomAccessFile(ipc, "rw");
                this.send(Packet.OpCode.HANDSHAKE, new JSONObject().put("v", 1).put("client_id", Long.toString(this.clientId)), null);
                Packet p = this.read();
                this.build = DiscordBuild.from(p.getJson().getJSONObject("data").getJSONObject("config").getString("api_endpoint"));
                LOGGER.debug(String.format("Found a valid client (%s) with packet: %s", this.build.name(), p.toString()));
                if (this.build == preferredOrder[0] || DiscordBuild.ANY == preferredOrder[0]) {
                    LOGGER.info(String.format("Found preferred client: %s", this.build.name()));
                    break;
                }
                open[this.build.ordinal()] = this.pipe;
                open[DiscordBuild.ANY.ordinal()] = this.pipe;
                this.build = null;
                this.pipe = null;
                continue;
            }
            catch (JSONException | IOException ex) {
                this.pipe = null;
                this.build = null;
            }
        }
        if (this.pipe == null) {
            for (i = 1; i < preferredOrder.length; ++i) {
                DiscordBuild cb = preferredOrder[i];
                LOGGER.debug(String.format("Looking for client build: %s", cb.name()));
                if (open[cb.ordinal()] == null) continue;
                this.pipe = open[cb.ordinal()];
                open[cb.ordinal()] = null;
                if (cb == DiscordBuild.ANY) {
                    for (int k = 0; k < open.length; ++k) {
                        if (open[k] != this.pipe) continue;
                        this.build = DiscordBuild.values()[k];
                        open[k] = null;
                    }
                } else {
                    this.build = cb;
                }
                LOGGER.info(String.format("Found preferred client: %s", this.build.name()));
                break;
            }
            if (this.pipe == null) {
                this.status = Status.DISCONNECTED;
                throw new NoDiscordClientException();
            }
        }
        for (i = 0; i < open.length; ++i) {
            if (i == DiscordBuild.ANY.ordinal() || open[i] == null) continue;
            try {
                open[i].close();
                continue;
            }
            catch (IOException ex) {
                LOGGER.debug("Failed to close an open IPC Pipe!", (Throwable)ex);
            }
        }
        this.status = Status.CONNECTED;
        LOGGER.debug("Client is now connected and ready!");
        if (this.listener != null) {
            this.listener.onReady(this);
        }
        this.startReading();
    }

    public void sendRichPresence(RichPresence presence) {
        this.sendRichPresence(presence, null);
    }

    public void sendRichPresence(RichPresence presence, Callback callback) {
        this.checkConnected(true);
        LOGGER.debug("Sending RichPresence to discord: " + (presence == null ? null : presence.toJson().toString()));
        this.send(Packet.OpCode.FRAME, new JSONObject().put("cmd", "SET_ACTIVITY").put("args", new JSONObject().put("pid", IPCClient.getPID()).put("activity", presence == null ? null : presence.toJson())), callback);
    }

    public void subscribe(Event sub) {
        this.subscribe(sub, null);
    }

    public void subscribe(Event sub, Callback callback) {
        this.checkConnected(true);
        if (!sub.isSubscribable()) {
            throw new IllegalStateException("Cannot subscribe to " + (Object)((Object)sub) + " event!");
        }
        LOGGER.debug(String.format("Subscribing to Event: %s", sub.name()));
        this.send(Packet.OpCode.FRAME, new JSONObject().put("cmd", "SUBSCRIBE").put("evt", sub.name()), callback);
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public void close() {
        this.checkConnected(true);
        LOGGER.debug("Closing IPC Pipe...");
        this.send(Packet.OpCode.CLOSE, new JSONObject(), null);
        this.status = Status.CLOSED;
    }

    public DiscordBuild getDiscordBuild() {
        return this.build;
    }

    private void checkConnected(boolean connected) {
        if (connected && this.status != Status.CONNECTED) {
            throw new IllegalStateException(String.format("IPCClient (ID: %d) is not connected!", this.clientId));
        }
        if (!connected && this.status == Status.CONNECTED) {
            throw new IllegalStateException(String.format("IPCClient (ID: %d) is already connected!", this.clientId));
        }
    }

    private void startReading() {
        this.readThread = new Thread(this::lambda$startReading$0);
        LOGGER.debug("Starting IPCClient reading thread!");
        this.readThread.start();
    }

    private void send(Packet.OpCode op, JSONObject data, Callback callback) {
        try {
            String nonce = IPCClient.generateNonce();
            Packet p = new Packet(op, data.put("nonce", nonce));
            if (callback != null && !callback.isEmpty()) {
                this.callbacks.put(nonce, callback);
            }
            this.pipe.write(p.toBytes());
            LOGGER.debug(String.format("Sent packet: %s", p.toString()));
            if (this.listener != null) {
                this.listener.onPacketSent(this, p);
            }
        }
        catch (IOException ex) {
            LOGGER.debug("Encountered an IOException while sending a packet and disconnected!");
            this.status = Status.DISCONNECTED;
            throw new RuntimeException(ex);
        }
    }

    private Packet read() throws IOException, JSONException {
        while (this.pipe.length() == 0L && this.status == Status.CONNECTED) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == Status.DISCONNECTED) {
            throw new IOException("Disconnected!");
        }
        if (this.status == Status.CLOSED) {
            return new Packet(Packet.OpCode.CLOSE, null);
        }
        Packet.OpCode op = Packet.OpCode.values()[Integer.reverseBytes(this.pipe.readInt())];
        int len = Integer.reverseBytes(this.pipe.readInt());
        byte[] d = new byte[len];
        this.pipe.readFully(d);
        Packet p = new Packet(op, new JSONObject(new String(d)));
        LOGGER.debug(String.format("Received packet: %s", p.toString()));
        if (this.listener != null) {
            this.listener.onPacketReceived(this, p);
        }
        return p;
    }

    private static int getPID() {
        String pr = ManagementFactory.getRuntimeMXBean().getName();
        return Integer.parseInt(pr.substring(0, pr.indexOf(64)));
    }

    private static String getIPC(int i) {
        String str;
        if (System.getProperty("os.name").contains("Win")) {
            return "\\\\?\\pipe\\discord-ipc-" + i;
        }
        String tmppath = null;
        String[] stringArray = paths;
        int n = stringArray.length;
        for (int j = 0; j < n && (tmppath = System.getenv(str = stringArray[j])) == null; ++j) {
        }
        if (tmppath == null) {
            tmppath = "/tmp";
        }
        return tmppath + "/discord-ipc-" + i;
    }

    private static String generateNonce() {
        return UUID.randomUUID().toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private /* synthetic */ void lambda$startReading$0() {
        try {
            while (true) lbl-1000:
            // 4 sources

            {
                if ((p = this.read()).getOp() == Packet.OpCode.CLOSE) {
                    this.status = Status.CLOSED;
                    if (this.listener == null) return;
                    this.listener.onClose(this, p.getJson());
                    return;
                }
                json = p.getJson();
                event = Event.of(json.optString("evt", null));
                nonce = json.optString("nonce", null);
                switch (1.$SwitchMap$info$u_team$u_team_core$repack$com$jagrosh$discordipc$IPCClient$Event[event.ordinal()]) {
                    case 1: {
                        if (nonce == null || !this.callbacks.containsKey(nonce)) break;
                        this.callbacks.remove(nonce).succeed();
                        break;
                    }
                    case 2: {
                        if (nonce == null || !this.callbacks.containsKey(nonce)) break;
                        this.callbacks.remove(nonce).fail(json.getJSONObject("data").optString("message", null));
                        break;
                    }
                    case 3: {
                        IPCClient.LOGGER.debug("Reading thread received a 'join' event.");
                        break;
                    }
                    case 4: {
                        IPCClient.LOGGER.debug("Reading thread received a 'spectate' event.");
                        break;
                    }
                    case 5: {
                        IPCClient.LOGGER.debug("Reading thread received a 'join request' event.");
                        break;
                    }
                    case 6: {
                        IPCClient.LOGGER.debug("Reading thread encountered an event with an unknown type: " + json.getString("evt"));
                        break;
                    }
                }
                if (this.listener == null || !json.has("cmd") || !json.getString("cmd").equals("DISPATCH")) continue;
                try {
                    data = json.getJSONObject("data");
                    switch (1.$SwitchMap$info$u_team$u_team_core$repack$com$jagrosh$discordipc$IPCClient$Event[Event.of(json.getString("evt")).ordinal()]) {
                        case 3: {
                            this.listener.onActivityJoin(this, data.getString("secret"));
                            break;
                        }
                        case 4: {
                            this.listener.onActivitySpectate(this, data.getString("secret"));
                            break;
                        }
                        case 5: {
                            u = data.getJSONObject("user");
                            user = new User(u.getString("username"), u.getString("discriminator"), Long.parseLong(u.getString("id")), u.optString("avatar", null));
                            this.listener.onActivityJoinRequest(this, data.optString("secret", null), user);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    IPCClient.LOGGER.error("Exception when handling event: ", (Throwable)e);
                    continue;
                }
                break;
            }
        }
        catch (JSONException | IOException ex) {
            if (ex instanceof IOException) {
                IPCClient.LOGGER.error("Reading thread encountered an IOException", (Throwable)ex);
            } else {
                IPCClient.LOGGER.error("Reading thread encountered an JSONException", (Throwable)ex);
            }
            this.status = Status.DISCONNECTED;
            if (this.listener == null) return;
            this.listener.onDisconnect(this, ex);
        }
        ** GOTO lbl-1000
    }

    public static enum Event {
        NULL(false),
        READY(false),
        ERROR(false),
        ACTIVITY_JOIN(true),
        ACTIVITY_SPECTATE(true),
        ACTIVITY_JOIN_REQUEST(true),
        UNKNOWN(false);

        private final boolean subscribable;

        private Event(boolean subscribable) {
            this.subscribable = subscribable;
        }

        public boolean isSubscribable() {
            return this.subscribable;
        }

        static Event of(String str) {
            if (str == null) {
                return NULL;
            }
            for (Event s : Event.values()) {
                if (s == UNKNOWN || !s.name().equalsIgnoreCase(str)) continue;
                return s;
            }
            return UNKNOWN;
        }
    }

    public static enum Status {
        CREATED,
        CONNECTING,
        CONNECTED,
        CLOSED,
        DISCONNECTED;

    }
}

