/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.config.data;

import com.bloodnbonesgaming.lib.util.data.ItemBlockData;
import com.bloodnbonesgaming.triumph.advancements.rewards.ExtendedAdvancementRewards;
import com.bloodnbonesgaming.triumph.advancements.rewards.SkillableReward;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.command.FunctionObject;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AdvancementRewardsData {
    private int experience;
    private List<String> functions = new ArrayList<String>();
    private List<ItemStack> itemRewards = new ArrayList<ItemStack>();
    private List<String> recipes = new ArrayList<String>();
    private List<SkillableReward> skillable = new ArrayList<SkillableReward>();
    private List<ResourceLocation> lootTables = new ArrayList<ResourceLocation>();

    public AdvancementRewards buildAdvancementRewards() throws Exception {
        ArrayList<FunctionObject.CacheableFunction> functionObjs = new ArrayList<FunctionObject.CacheableFunction>();
        for (String function : this.functions) {
            functionObjs.add(new FunctionObject.CacheableFunction(new ResourceLocation(function)));
        }
        return new ExtendedAdvancementRewards(this.experience, this.lootTables.toArray(new ResourceLocation[0]), this.buildRecipeRewards(), functionObjs, this.itemRewards, this.skillable);
    }

    public ResourceLocation[] buildRecipeRewards() {
        ResourceLocation[] array = new ResourceLocation[this.recipes.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = new ResourceLocation(this.recipes.get(i));
        }
        return array;
    }

    public void addLootTable(ResourceLocation table) {
        this.lootTables.add(table);
    }

    public void addSkillable(String skill, int levels) {
        this.skillable.add(new SkillableReward(skill, levels));
    }

    public void addRecipe(String recipe) throws Exception {
        if (!ForgeRegistries.RECIPES.containsKey(new ResourceLocation(recipe))) {
            throw new Exception("No recipe exists with the id " + recipe);
        }
        this.recipes.add(recipe);
    }

    public void setItem(ItemBlockData item) throws Exception {
        this.addItem(item);
    }

    public void setItem(String itemName) throws Exception {
        this.setItem(itemName, 0);
    }

    public void setItem(String itemName, int meta) throws Exception {
        this.setItem(itemName, meta, 1);
    }

    public void setItem(String itemName, int meta, int amount) throws Exception {
        ItemBlockData data = new ItemBlockData();
        data.setLocation(itemName);
        data.setMeta(new MinMaxBounds(Float.valueOf(meta), Float.valueOf(meta)));
        data.setCount(new MinMaxBounds(Float.valueOf(amount), Float.valueOf(amount)));
        this.itemRewards.add(data.buildItemStack());
    }

    public void setItem(String itemName, int meta, int amount, String nbtString) throws Exception {
        ItemBlockData data = new ItemBlockData();
        data.setLocation(itemName);
        data.setMeta(new MinMaxBounds(Float.valueOf(meta), Float.valueOf(meta)));
        data.setCount(new MinMaxBounds(Float.valueOf(amount), Float.valueOf(amount)));
        data.setNBT(nbtString);
        this.itemRewards.add(data.buildItemStack());
    }

    public void addItem(ItemBlockData data) throws Exception {
        this.itemRewards.add(data.buildItemStack());
    }

    public void addFunction(String function) {
        this.functions.add(function);
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }
}

