/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.triumph.advancements.criterion.data.botaniatweaks;

import com.bloodnbonesgaming.lib.util.script.ScriptClassDocumentation;
import com.bloodnbonesgaming.lib.util.script.ScriptMethodDocumentation;
import com.bloodnbonesgaming.triumph.advancements.criterion.data.CriterionTriggerData;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.ICriterionInstance;
import quaternary.botaniatweaks.modules.botania.advancement.FlowerGeneratedManaCriterionTrigger;

@ScriptClassDocumentation(documentationFile="./config/triumph/documentation/criteria/triggers/botania_tweaks/flower_generated_mana", classExplaination="These are the functions which can be called on a botania_tweaks:flower_generated_mana criteria trigger. This criteria is triggered by a player generating a certain amount of mana with a certain flower.")
public class FlowerGeneratedManaTriggerData
extends CriterionTriggerData {
    private String flower;
    private long neededMana = 0L;

    public FlowerGeneratedManaTriggerData(String criterionName, String advancementName) {
        super(criterionName, advancementName);
    }

    @Override
    public Criterion buildCriterion() throws Exception {
        return new Criterion((ICriterionInstance)new FlowerGeneratedManaCriterionTrigger.Instance(this.flower, this.neededMana));
    }

    @ScriptMethodDocumentation(args="String", usage="flower name", notes="Sets the required flower.")
    public void setFlower(String flower) {
        this.flower = flower;
    }

    @ScriptMethodDocumentation(args="long", usage="required mana", notes="Sets the required mana for the flower to have generated.")
    public void setRequiredMana(long mana) {
        this.neededMana = mana;
    }
}

