/*
 * Decompiled with CFR 0.152.
 */
package org.torgy.torgo.network;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.io.FileUtils;

public class Slack
implements Runnable {
    static String slack_url = "";
    private static String tempVersionFileName = "slackPostUrl.txt";
    private static File minecraftDir = null;

    public static void postCall(JsonObject json) {
        try {
            minecraftDir = FMLCommonHandler.instance().getMinecraftServerInstance().func_71238_n();
        }
        catch (NoClassDefFoundError e) {
            minecraftDir = new File("/home/dtorgo/kozem_server/");
        }
        if (!new File(minecraftDir, tempVersionFileName).exists()) {
            System.out.println("slackPostUrl.txt file not found at: " + minecraftDir + ", not sending slack message");
            return;
        }
        File tempVersionFile = new File(minecraftDir, tempVersionFileName);
        try {
            slack_url = (String)FileUtils.readLines((File)tempVersionFile).get(0);
        }
        catch (IOException e) {
            System.out.println("unable to read slackPostUrl.txt file");
            return;
        }
        try {
            HttpURLConnection connection = Slack.getConnection(slack_url);
            try (OutputStreamWriter osw = new OutputStreamWriter(connection.getOutputStream());){
                osw.write(json.toString());
                osw.flush();
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                System.out.println("Sentinel errored out with response code " + responseCode + " and response message " + connection.getResponseMessage() + " on JSON " + json.toString());
                return;
            }
            try (InputStreamReader isr = new InputStreamReader(connection.getInputStream());){
                String response = Slack.getString(isr);
                JsonElement rootResponse = new JsonParser().parse(response);
                return;
            }
        }
        catch (IOException e) {
            return;
        }
    }

    private static HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(10000);
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/json");
        return conn;
    }

    private static String getString(InputStreamReader isr) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(isr);
        StringBuilder sb = new StringBuilder();
        while ((line = br.readLine()) != null) {
            sb.append(line + "\n");
        }
        br.close();
        return sb.toString();
    }

    public static void sendSlackMessage(String message) {
        final JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("text", message);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Slack.postCall(jsonObject);
            }
        });
        thread.start();
    }

    @Override
    public void run() {
    }
}

