/*
 * Decompiled with CFR 0.152.
 */
package org.torgy.torgo.init;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.torgy.torgo.init.TorgoBlocks;
import org.torgy.torgo.init.TorgoItems;

@Mod.EventBusSubscriber(modid="torgo")
public class TorgoModels {
    private static final String[] NORMAL = new String[]{"normal"};

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        if (FMLCommonHandler.instance().getSide() != Side.CLIENT) {
            return;
        }
        OBJLoader.INSTANCE.addDomain("torgo");
        TorgoModels.registerModel(TorgoItems.GLOWSTONE_GLASS);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_FRAME);
        TorgoModels.registerModel(TorgoItems.OBSIDIAN_LEAD);
        TorgoModels.registerModel(TorgoItems.BLOCK9);
        TorgoModels.registerModel(TorgoItems.BLOCK9X9);
        TorgoModels.registerModel(TorgoItems.BLOCK9PLUS);
        TorgoModels.registerModel(TorgoItems.BLOCK81);
        TorgoModels.registerModel(TorgoItems.BLOCK729);
        TorgoModels.registerModel(TorgoItems.BLOCK6561);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_HUNTING_DIMENSION);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_END);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_MARS);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_MINING_DIMENSION);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_MOON);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_NETHER);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_TWILIGHT_FOREST);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_VENUS);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_AETHER);
        TorgoModels.registerModel(TorgoItems.TELEPORTER_BLOCK_COMPOUND);
        TorgoModels.registerModel(TorgoItems.BLOCK59049);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void patchBakedModels(ModelBakeEvent event) {
        IRegistry registry = event.getModelRegistry();
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.GLOWSTONE_GLASS);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_FRAME);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.OBSIDIAN_LEAD);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.BLOCK9);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.BLOCK9X9);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.BLOCK9PLUS);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.BLOCK81);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.BLOCK729);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.BLOCK6561);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_HUNTING_DIMENSION);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_END);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_MARS);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_MINING_DIMENSION);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_MOON);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_NETHER);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_TWILIGHT_FOREST);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_VENUS);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_AETHER);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoItems.TELEPORTER_BLOCK_COMPOUND);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.GLOWSTONE_GLASS, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_FRAME, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.OBSIDIAN_LEAD, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.BLOCK9, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.BLOCK9X9, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.BLOCK9PLUS, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.BLOCK81, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.BLOCK729, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.BLOCK6561, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_HUNTING_DIMENSION, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_END, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_MARS, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_MINING_DIMENSION, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_MOON, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_NETHER, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_TWILIGHT_FOREST, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_VENUS, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_AETHER, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.TELEPORTER_BLOCK_COMPOUND, new String[0]);
        TorgoModels.patchModel((IRegistry<ModelResourceLocation, IBakedModel>)registry, TorgoBlocks.BLOCK59049, new String[0]);
    }

    private static void registerModel(Item item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    private static void patchModel(IRegistry<ModelResourceLocation, IBakedModel> registry, Item item) {
        ModelResourceLocation location = new ModelResourceLocation(item.getRegistryName(), "inventory");
        IBakedModel model = (IBakedModel)registry.func_82594_a((Object)location);
    }

    private static void patchModel(IRegistry<ModelResourceLocation, IBakedModel> registry, Block block, String ... variants) {
        if (variants.length == 0) {
            variants = NORMAL;
        }
        for (String variant : variants) {
            ModelResourceLocation location = new ModelResourceLocation(block.getRegistryName(), variant);
            IBakedModel model = (IBakedModel)registry.func_82594_a((Object)location);
            if (model != null) continue;
            System.out.println("Couldn't get block model for: " + location);
        }
    }
}

