/*
 * Decompiled with CFR 0.152.
 */
package org.torgy.torgo.genoil;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.torgy.torgo.genoil.Box;
import org.torgy.torgo.genoil.OilGenStructure;
import org.torgy.torgo.genoil.RandUtil;
import org.torgy.torgo.genoil.VecUtil;

public class OilGenerator {
    private static final long MAGIC_GEN_NUMBER = -3438862373895731249L;
    private static final int MAX_CHUNK_RADIUS = 5;

    @SubscribeEvent
    public static void onPopulatePre(PopulateChunkEvent.Pre event) {
        World world = event.getWorld();
        int chunkX = event.getChunkX();
        int chunkZ = event.getChunkZ();
        if (world.func_175624_G() == WorldType.field_77138_c) {
            return;
        }
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        int x = chunkX * 16 + 8;
        int z = chunkZ * 16 + 8;
        BlockPos min = new BlockPos(x, 0, z);
        Box box = new Box(min, min.func_177982_a(15, world.func_72800_K(), 15));
        for (int cdx = -5; cdx <= 5; ++cdx) {
            for (int cdz = -5; cdz <= 5; ++cdz) {
                int cx = chunkX + cdx;
                int cz = chunkZ + cdz;
                List<OilGenStructure> structures = OilGenerator.getStructures(world, cx, cz, cdx == 0 && cdz == 0);
                for (OilGenStructure struct : structures) {
                    struct.generate(world, box);
                }
            }
        }
    }

    private static List<OilGenStructure> getStructures(World world, int cx, int cz, boolean log) {
        GenType type;
        Double tmpRand;
        Random rand = RandUtil.createRandomForChunk(world, cx, cz, -3438862373895731249L);
        int x = cx * 16 + 8 + rand.nextInt(16);
        int z = cz * 16 + 8 + rand.nextInt(16);
        Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
        if (world.field_73011_w.getDimension() != 0 || biome.func_76738_d()) {
            return ImmutableList.of();
        }
        double bonus = 0.5;
        if (biome.getRegistryName().toString().equalsIgnoreCase("biomesoplenty:wasteland")) {
            bonus = 2.0;
        }
        if ((tmpRand = Double.valueOf(rand.nextDouble())) <= 0.01 * bonus) {
            type = GenType.LARGE;
        } else if (tmpRand <= 0.04 * bonus) {
            type = GenType.MEDIUM;
        } else if (tmpRand <= 0.1 * bonus) {
            type = GenType.SMALL;
        } else {
            return ImmutableList.of();
        }
        ArrayList<OilGenStructure> structures = new ArrayList<OilGenStructure>();
        int wellY = 40;
        int radius = 3;
        switch (type) {
            case LARGE: {
                radius = 15;
                break;
            }
            case MEDIUM: {
                radius = 9;
                break;
            }
            case SMALL: {
                radius = 5;
            }
        }
        structures.add(OilGenerator.createSphere(new BlockPos(x, wellY, z), radius));
        int height = 2;
        switch (type) {
            case LARGE: {
                height = 15;
                break;
            }
            case MEDIUM: {
                height = 7;
                break;
            }
            case SMALL: {
                height = 4;
            }
        }
        structures.add(OilGenerator.createSpout(new BlockPos(x, wellY, z), height, 0));
        return structures;
    }

    private static OilGenStructure createSpout(BlockPos start, int height, int radius) {
        return new OilGenStructure.Spout(start, OilGenStructure.ReplaceType.ALWAYS, radius, height);
    }

    public static OilGenStructure createTube(BlockPos center, int length, int radius, EnumFacing.Axis axis) {
        int valForAxis = VecUtil.getValue((Vec3i)center, axis);
        BlockPos min = VecUtil.replaceValue((Vec3i)center.func_177982_a(-radius, -radius, -radius), axis, valForAxis);
        BlockPos max = VecUtil.replaceValue((Vec3i)center.func_177982_a(radius, radius, radius), axis, valForAxis + length);
        double radiusSq = radius * radius;
        int toReplace = valForAxis;
        Predicate<BlockPos> tester = p -> VecUtil.replaceValue((Vec3i)p, axis, toReplace).func_177951_i((Vec3i)center) <= radiusSq;
        return new OilGenStructure.GenByPredicate(new Box(min, max), OilGenStructure.ReplaceType.ALWAYS, tester);
    }

    public static OilGenStructure createSphere(BlockPos center, int radius) {
        Box box = new Box(center.func_177982_a(-radius, -radius, -radius), center.func_177982_a(radius, radius, radius));
        double radiusSq = (double)(radius * radius) + 0.01;
        Predicate<BlockPos> tester = p -> p.func_177951_i((Vec3i)center) <= radiusSq;
        return new OilGenStructure.GenByPredicate(box, OilGenStructure.ReplaceType.ALWAYS, tester);
    }

    private static enum GenType {
        LARGE,
        MEDIUM,
        SMALL;

    }
}

