/*
 * Decompiled with CFR 0.152.
 */
package org.torgy.torgo.color;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.torgy.torgo.color.Color;

public class ColorMap<T> {
    private final Object[] map = new Object[16];

    public ColorMap(Function<Color, T> filler) {
        for (int i = 0; i < 16; ++i) {
            this.map[i] = filler.apply(Color.fromOrdinal(i));
        }
    }

    public T get(Color color) {
        return (T)this.map[color.ordinal()];
    }

    public void set(Color color, T value) {
        this.map[color.ordinal()] = value;
    }

    public void forEach(BiConsumer<Color, T> consumer) {
        for (int i = 0; i < 16; ++i) {
            Color color = Color.fromOrdinal(i);
            consumer.accept(color, (Color)((Object)this.map[i]));
        }
    }

    public <R> ColorMap<R> map(Function<T, R> mapper) {
        return new ColorMap<Object>(color -> mapper.apply(this.get((Color)((Object)color))));
    }
}

