/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.customslots.example;

import com.google.common.collect.ImmutableList;
import gigaherz.toolbelt.customslots.ExtensionSlotItemHandler;
import gigaherz.toolbelt.customslots.IExtensionContainer;
import gigaherz.toolbelt.customslots.IExtensionSlot;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class RpgEquipment
implements IExtensionContainer,
INBTSerializable<NBTTagCompound> {
    private static final ResourceLocation CAPABILITY_ID = new ResourceLocation("examplemod", "rpg_inventory");
    @CapabilityInject(value=RpgEquipment.class)
    public static Capability<RpgEquipment> CAPABILITY = null;
    public static final ResourceLocation RING = new ResourceLocation("examplemod", "ring");
    public static final ResourceLocation TRINKET = new ResourceLocation("examplemod", "trinket");
    public static final ResourceLocation NECK = new ResourceLocation("examplemod", "neck");
    public static final ResourceLocation BELT = new ResourceLocation("examplemod", "belt");
    public static final ResourceLocation WRISTS = new ResourceLocation("examplemod", "wrists");
    public static final ResourceLocation ANKLES = new ResourceLocation("examplemod", "ankles");
    private final EntityLivingBase owner;
    private final ItemStackHandler inventory = new ItemStackHandler(8);
    private final ExtensionSlotItemHandler ring1 = new ExtensionSlotItemHandler(this, RING, (IItemHandlerModifiable)this.inventory, 0);
    private final ExtensionSlotItemHandler ring2 = new ExtensionSlotItemHandler(this, RING, (IItemHandlerModifiable)this.inventory, 1);
    private final ExtensionSlotItemHandler trinket1 = new ExtensionSlotItemHandler(this, TRINKET, (IItemHandlerModifiable)this.inventory, 2);
    private final ExtensionSlotItemHandler trinket2 = new ExtensionSlotItemHandler(this, TRINKET, (IItemHandlerModifiable)this.inventory, 3);
    private final ExtensionSlotItemHandler neck = new ExtensionSlotItemHandler(this, NECK, (IItemHandlerModifiable)this.inventory, 4);
    private final ExtensionSlotItemHandler belt = new ExtensionSlotItemHandler(this, BELT, (IItemHandlerModifiable)this.inventory, 5);
    private final ExtensionSlotItemHandler wrists = new ExtensionSlotItemHandler(this, WRISTS, (IItemHandlerModifiable)this.inventory, 6);
    private final ExtensionSlotItemHandler ankles = new ExtensionSlotItemHandler(this, ANKLES, (IItemHandlerModifiable)this.inventory, 7);
    private final ImmutableList<IExtensionSlot> slots = ImmutableList.of((Object)this.ring1, (Object)this.ring2, (Object)this.trinket1, (Object)this.trinket2, (Object)this.neck, (Object)this.belt, (Object)this.wrists, (Object)this.ankles);

    public static void register() {
        CapabilityManager.INSTANCE.register(RpgEquipment.class, (Capability.IStorage)new Capability.IStorage<RpgEquipment>(){

            @Nullable
            public NBTBase writeNBT(Capability<RpgEquipment> capability, RpgEquipment instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<RpgEquipment> capability, RpgEquipment instance, EnumFacing side, NBTBase nbt) {
            }
        }, () -> null);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
    }

    public static RpgEquipment get(EntityPlayer player) {
        return (RpgEquipment)player.getCapability(CAPABILITY, null);
    }

    private RpgEquipment(EntityLivingBase owner) {
        this.owner = owner;
    }

    @Override
    @Nonnull
    public EntityLivingBase getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public ImmutableList<IExtensionSlot> getSlots() {
        return this.slots;
    }

    @Override
    public void onContentsChanged(IExtensionSlot slot) {
    }

    @Nonnull
    public IExtensionSlot getRing1() {
        return this.ring1;
    }

    @Nonnull
    public IExtensionSlot getRing2() {
        return this.ring2;
    }

    @Nonnull
    public IExtensionSlot getTrinket1() {
        return this.trinket1;
    }

    @Nonnull
    public IExtensionSlot getTrinket2() {
        return this.trinket2;
    }

    @Nonnull
    public IExtensionSlot getNeck() {
        return this.neck;
    }

    @Nonnull
    public IExtensionSlot getBelt() {
        return this.belt;
    }

    @Nonnull
    public IExtensionSlot getWrists() {
        return this.wrists;
    }

    @Nonnull
    public IExtensionSlot getAnkles() {
        return this.ankles;
    }

    private void tickAllSlots() {
        for (IExtensionSlot slot : this.slots) {
            ((ExtensionSlotItemHandler)slot).onWornTick();
        }
    }

    public NBTTagCompound serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inventory.deserializeNBT(nbt);
    }

    static class EventHandlers {
        EventHandlers() {
        }

        @SubscribeEvent
        public void attachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof EntityPlayer) {
                event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                    final RpgEquipment extensionContainer;
                    {
                        this.extensionContainer = new RpgEquipment((EntityLivingBase)((EntityPlayer)event.getObject()));
                    }

                    public NBTTagCompound serializeNBT() {
                        return this.extensionContainer.serializeNBT();
                    }

                    public void deserializeNBT(NBTTagCompound nbt) {
                        this.extensionContainer.deserializeNBT(nbt);
                    }

                    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                        return capability == CAPABILITY;
                    }

                    @Nullable
                    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                        if (capability == CAPABILITY) {
                            return (T)this.extensionContainer;
                        }
                        return null;
                    }
                });
            }
        }

        @SubscribeEvent
        public void entityTick(TickEvent.PlayerTickEvent event) {
            RpgEquipment instance = RpgEquipment.get(event.player);
            if (instance == null) {
                return;
            }
            instance.tickAllSlots();
        }
    }
}

