/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.profiling;

import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketCustomPayload;
import org.minimallycorrect.tickprofiler.minecraft.profiling.Profile;
import org.minimallycorrect.tickprofiler.util.TableFormatter;

public class PacketProfiler
extends Profile {
    private static final AtomicBoolean running = new AtomicBoolean();
    private static final Map<String, AtomicInteger> size = new ConcurrentHashMap<String, AtomicInteger>();
    private static final Map<String, AtomicInteger> count = new ConcurrentHashMap<String, AtomicInteger>();

    private static <T> List<T> sortedKeys(Map<T, ? extends Comparable<?>> map, int elements) {
        ImmutableList list = Ordering.natural().reverse().onResultOf(Functions.forMap(map)).immutableSortedCopy(map.keySet());
        return list.size() > elements ? list.subList(0, elements) : list;
    }

    private static void writeStats(TableFormatter tf, int elements) {
        HashMap<String, Integer> count = new HashMap<String, Integer>();
        for (Map.Entry<String, AtomicInteger> entry : PacketProfiler.count.entrySet()) {
            count.put(entry.getKey(), entry.getValue().get());
        }
        HashMap<String, Integer> size = new HashMap<String, Integer>();
        for (Map.Entry<String, AtomicInteger> entry : PacketProfiler.size.entrySet()) {
            size.put(entry.getKey(), entry.getValue().get());
        }
        tf.heading("Packet").heading("Count").heading("Size");
        List<String> list = PacketProfiler.sortedKeys(count, elements);
        for (String id : list) {
            tf.row(PacketProfiler.humanReadableName(id)).row(count.get(id)).row(PacketProfiler.humanReadableByteCount((Integer)size.get(id)));
        }
        tf.finishTable();
        tf.sb.append('\n');
        tf.heading("Packet").heading("Count").heading("Size");
        List<String> list2 = PacketProfiler.sortedKeys(size, elements);
        for (String id : list2) {
            tf.row(PacketProfiler.humanReadableName(id)).row(count.get(id)).row(PacketProfiler.humanReadableByteCount((Integer)size.get(id)));
        }
        tf.finishTable();
    }

    private static String humanReadableName(String name) {
        if (name.startsWith("net.minecraft.network.")) {
            return name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    public static void record(Packet<?> packet, PacketBuffer buffer) {
        String id;
        if (!running.get()) {
            return;
        }
        if (packet instanceof SPacketCustomPayload) {
            id = ((SPacketCustomPayload)packet).func_149169_c();
        } else {
            id = packet.getClass().getName();
            id = id.substring(id.lastIndexOf(46) + 1);
        }
        int size = buffer.readableBytes();
        PacketProfiler.getAtomicInteger(id, count).getAndIncrement();
        PacketProfiler.getAtomicInteger(id, PacketProfiler.size).addAndGet(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AtomicInteger getAtomicInteger(String key, Map<String, AtomicInteger> map) {
        AtomicInteger t = map.get(key);
        if (t == null) {
            Map<String, AtomicInteger> map2 = map;
            synchronized (map2) {
                t = map.computeIfAbsent(key, k -> new AtomicInteger());
            }
        }
        return t;
    }

    private static String humanReadableByteCount(int bytes) {
        int unit = 1024;
        if (bytes < unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f%cB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    @Override
    protected AtomicBoolean getRunning() {
        return running;
    }

    @Override
    public void start() {
        int elements = this.parameters.getInt("elements");
        if (elements <= 0) {
            throw new IllegalArgumentException("elements must be > 0");
        }
        this.start(() -> {}, () -> this.targets.forEach(it -> {
            TableFormatter tf = it.getTableFormatter();
            PacketProfiler.writeStats(tf, elements);
            it.sendTables(tf);
        }), () -> {
            size.clear();
            count.clear();
        });
    }
}

