/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.profiling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import org.minimallycorrect.tickprofiler.minecraft.profiling.Profile;
import org.minimallycorrect.tickprofiler.util.CollectionsUtil;
import org.minimallycorrect.tickprofiler.util.TableFormatter;

public class EntityCountingProfiler
extends Profile {
    private static <T> void increment(HashMap<T, Integer> counts, T t) {
        Integer current = counts.get(t);
        counts.put(t, current == null ? 1 : current + 1);
    }

    @Override
    public void start() {
        int elements = this.parameters.getInt("elements");
        if (elements <= 0) {
            throw new IllegalArgumentException("elements must be > 0");
        }
        HashMap entityCounts = new HashMap();
        HashMap tileEntityCounts = new HashMap();
        String worlds = this.parameters.getString("worlds").toLowerCase();
        ArrayList<WorldServer> worldList = new ArrayList<WorldServer>();
        if (worlds.equals("all")) {
            Collections.addAll(worldList, DimensionManager.getWorlds());
            worldList.removeIf(Objects::isNull);
        } else {
            worldList.add(DimensionManager.getWorld((int)Integer.parseInt(worlds)));
        }
        for (WorldServer world : worldList) {
            for (Entity entity : world.field_72996_f) {
                EntityCountingProfiler.increment(entityCounts, entity.getClass());
            }
            for (Entity entity : world.field_147482_g) {
                EntityCountingProfiler.increment(tileEntityCounts, entity.getClass());
            }
        }
        this.targets.forEach(it -> {
            TableFormatter tf = it.getTableFormatter();
            tf.heading("Class").heading("Count");
            for (Class key : CollectionsUtil.sortedKeys(entityCounts, elements)) {
                tf.row(key.getSimpleName()).row(entityCounts.get(key));
            }
            tf.finishTable();
            tf.sb.append('\n');
            tf.heading("Class").heading("Count");
            for (Class key : CollectionsUtil.sortedKeys(tileEntityCounts, elements)) {
                tf.row(key.getSimpleName()).row(tileEntityCounts.get(key));
            }
            tf.finishTable();
            it.sendTables(tf);
        });
    }
}

