/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.commands;

import com.google.common.base.Strings;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;
import org.minimallycorrect.tickprofiler.Log;
import org.minimallycorrect.tickprofiler.minecraft.TickProfiler;
import org.minimallycorrect.tickprofiler.minecraft.commands.Command;
import org.minimallycorrect.tickprofiler.util.ChatFormat;
import org.minimallycorrect.tickprofiler.util.TableFormatter;

public class TPSCommand
extends Command {
    private static final int tpsWidth = 40;
    public static String name = "tps";

    private static String getTPSString(boolean withColour) {
        double targetTPS = 20.0;
        double tps = (double)TimeUnit.SECONDS.toNanos(1L) / (double)TickProfiler.tickTime;
        if (tps > 20.0) {
            tps = 20.0;
        }
        double difference = Math.abs(targetTPS - tps);
        int charsFirst = (int)Math.round(tps / targetTPS * 40.0);
        int charsAfter = 40 - charsFirst;
        return " " + TableFormatter.formatDoubleWithPrecision(tps, 2) + " TPS [ " + (withColour ? TPSCommand.getColourForDifference(difference, targetTPS) : "") + Strings.repeat((String)"#", (int)charsFirst) + Strings.repeat((String)"~", (int)charsAfter) + (withColour ? ChatFormat.RESET : "") + " ] ";
    }

    private static String getColourForDifference(double difference, double targetTPS) {
        switch ((int)(difference / (targetTPS / 4.0))) {
            case 0: {
                return ChatFormat.GREEN.toString();
            }
            case 1: {
                return ChatFormat.YELLOW.toString();
            }
            case 2: {
                return ChatFormat.RED.toString();
            }
            case 3: {
                return ChatFormat.RED.toString() + (Object)((Object)ChatFormat.BOLD);
            }
        }
        return ChatFormat.MAGIC.toString();
    }

    public String func_71517_b() {
        return name;
    }

    @Override
    public boolean requireOp() {
        return TickProfiler.instance.requireOpForTPSCommand;
    }

    public String func_71518_a(ICommandSender commandSender) {
        return "Usage: /tps";
    }

    @Override
    public void processCommand(ICommandSender commandSender, List<String> arguments) {
        MinecraftServer server = commandSender.func_184102_h();
        if (server == null) {
            throw new RuntimeException("Could not get server instance from commandSender " + commandSender);
        }
        TableFormatter tf = new TableFormatter(commandSender);
        int entities = 0;
        int tileEntities = 0;
        int chunks = 0;
        tf.heading("").heading("E").heading("TE").heading("C").heading("");
        for (WorldServer world : server.field_71305_c) {
            int worldEntities = world.field_72996_f.size();
            int worldTileEntities = world.field_147482_g.size();
            ChunkProviderServer provider = world.func_72863_F();
            int worldChunks = provider.func_73152_e();
            entities += worldEntities;
            tileEntities += worldTileEntities;
            chunks += worldChunks;
            tf.row(Log.name((World)world)).row(worldEntities).row(worldTileEntities).row(worldChunks).row("");
        }
        tf.row(server.func_184103_al().func_72394_k() + " Players").row(entities).row(tileEntities).row(chunks).row(TableFormatter.formatDoubleWithPrecision((double)TickProfiler.tickTime * 100.0 / 5.0E7, 2) + '%');
        tf.finishTable();
        tf.sb.append('\n').append(TPSCommand.getTPSString(commandSender instanceof EntityPlayer));
        TPSCommand.sendChat(commandSender, tf.toString());
    }
}

