/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.command.ICommandSender;
import org.minimallycorrect.tickprofiler.minecraft.TickProfiler;
import org.minimallycorrect.tickprofiler.minecraft.commands.Command;
import org.minimallycorrect.tickprofiler.minecraft.commands.Parameters;
import org.minimallycorrect.tickprofiler.minecraft.commands.UsageException;
import org.minimallycorrect.tickprofiler.minecraft.profiling.Profile;

public class ProfileCommand
extends Command {
    public static String name = "profile";

    public String func_71517_b() {
        return name;
    }

    @Override
    public boolean requireOp() {
        return TickProfiler.instance.requireOpForProfileCommand;
    }

    @Override
    public void processCommand(ICommandSender commandSender, List<String> arguments) {
        this.process(commandSender, arguments);
    }

    private void addPreParameters(Parameters p) {
        p.order(Collections.singletonList("type"));
    }

    private void addPostParameters(Parameters p) {
        p.orderWithDefault(Arrays.asList("output", "commandsender"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(ICommandSender commandSender, List<String> arguments) {
        Parameters p = new Parameters(arguments);
        this.addPreParameters(p);
        p.checkUsage(true);
        String typeName = p.getString("type");
        Profile.Types type = Profile.Types.byName(typeName);
        if (type == null) {
            throw new UsageException("Unknown profiling type " + typeName);
        }
        type.addParameters(p);
        this.addPostParameters(p);
        p.checkUsage(false);
        String output = p.getString("output");
        ArrayList<Profile.ProfileTarget> targets = new ArrayList<Profile.ProfileTarget>();
        block11: for (String s : output.split(",")) {
            switch (s.toLowerCase()) {
                case "commandsender": {
                    targets.add(Profile.ProfileTarget.commandSender(commandSender));
                    continue block11;
                }
                case "console": {
                    targets.add(Profile.ProfileTarget.console());
                    continue block11;
                }
                default: {
                    throw new UsageException("Unknown output: " + output);
                }
            }
        }
        Profile profile = type.create();
        try {
            profile.start(commandSender, targets, p);
        }
        finally {
            profile.closeIfNeeded();
        }
    }

    public String func_71518_a(ICommandSender icommandsender) {
        StringBuilder sb = new StringBuilder("Usage:\n");
        for (Profile.Types type : Profile.Types.values()) {
            Parameters p = new Parameters(Collections.singletonList(type.shortName));
            type.addParameters(p);
            this.addPostParameters(p);
            sb.append(type.name()).append(": ").append("/profile ").append(type.shortName);
            p.writeExpectedParameters(sb);
            sb.append('\n');
        }
        return sb.toString();
    }
}

