/*
 * Decompiled with CFR 0.152.
 */
package org.minimallycorrect.tickprofiler.minecraft.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.minimallycorrect.tickprofiler.minecraft.commands.UsageException;

public class Parameters {
    private final ArrayList<String> unmatched = new ArrayList();
    private final HashMap<String, String> map = new HashMap();
    private final LinkedHashSet<String> expected = new LinkedHashSet();

    public Parameters(Iterable<String> args) {
        for (String arg : args) {
            int equals = arg.indexOf(61);
            if (equals == -1) {
                this.unmatched.add(arg);
                continue;
            }
            this.map.put(arg.substring(0, equals), arg.substring(equals + 1));
        }
    }

    public void order(List<String> keys) {
        int i = 0;
        int size = this.unmatched.size();
        for (String key : keys) {
            if (i < size) {
                this.map.put(key, this.unmatched.get(i++));
            }
            this.expected.add(key);
        }
        if (i != 0) {
            this.unmatched.subList(0, i).clear();
        }
    }

    public void orderWithDefault(List<String> keys) {
        int i = 0;
        int size = this.unmatched.size();
        for (int j = 0; j < keys.size(); j += 2) {
            String key = keys.get(j);
            if (!this.map.containsKey(key)) {
                this.map.put(key, i < size ? this.unmatched.get(i++) : keys.get(j + 1));
            }
            this.expected.add(key);
        }
        if (i != 0) {
            this.unmatched.subList(0, i).clear();
        }
    }

    public void checkUsage(boolean allowExtra) {
        for (String s : this.expected) {
            if (this.map.containsKey(s)) continue;
            throw new UsageException("Missing required parameter " + s);
        }
        if (!allowExtra) {
            if (!this.unmatched.isEmpty()) {
                throw new UsageException("Unmatched parameters " + this.unmatched);
            }
            for (String s : this.map.keySet()) {
                if (this.expected.contains(s)) continue;
                throw new UsageException("Unexpected parameter " + s);
            }
        }
    }

    public String getString(String type) {
        String result = this.map.get(type);
        if (result == null) {
            throw new UsageException("Missing parameter " + type);
        }
        return result;
    }

    public int getInt(String time) {
        return Integer.parseInt(this.getString(time));
    }

    void writeExpectedParameters(StringBuilder sb) {
        for (String s : this.expected) {
            sb.append(' ');
            sb.append(s);
            String current = this.map.get(s);
            if (current == null) continue;
            sb.append('=').append(current);
        }
    }

    public boolean has(String key) {
        return this.map.containsKey(key);
    }
}

