/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.render;

import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import org.thetorg.blocks.TorgoSignBlock;
import org.thetorg.blocks.TorgoSignTileEntity;

public class RenderTorgoSign
extends TileEntitySpecialRenderer<TorgoSignTileEntity> {
    private final FontRenderer fontRenderer;
    private static final float SCALE = 0.011f;
    private static final double LINE_HEIGHT = 0.1;
    private static final double START_Y = 0.25;

    public RenderTorgoSign() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    public void render(TorgoSignTileEntity tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tileEntity == null || tileEntity.func_145831_w() == null) {
            return;
        }
        EnumFacing facing = (EnumFacing)tileEntity.func_145831_w().func_180495_p(tileEntity.func_174877_v()).func_177229_b((IProperty)TorgoSignBlock.FACING);
        String[] lines = tileEntity.getTextLines();
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i] == null || lines[i].isEmpty()) continue;
            this.renderTextLine(x, y, z, facing, lines[i], i);
        }
    }

    private void renderTextLine(double x, double y, double z, EnumFacing facing, String text, int lineIndex) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179136_a((float)-10.0f, (float)-10.0f);
        GlStateManager.func_179088_q();
        double yOffset = 0.25 - (double)lineIndex * 0.1;
        double xOffset = 0.0;
        this.performTransformations(x, y, z, facing, yOffset, xOffset);
        GlStateManager.func_179152_a((float)0.011f, (float)-0.011f, (float)0.011f);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        int textPixelWidth = this.fontRenderer.func_78256_a(text);
        this.fontRenderer.func_78276_b(text, -textPixelWidth / 2, 0, 0xFFFFFF);
        GlStateManager.func_179145_e();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179113_r();
        GlStateManager.func_179121_F();
    }

    private void performTransformations(double x, double y, double z, EnumFacing facing, double yOffset, double xOffset) {
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        switch (facing) {
            case NORTH: {
                GlStateManager.func_179137_b((double)(-xOffset), (double)yOffset, (double)-0.501);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179137_b((double)xOffset, (double)yOffset, (double)0.501);
                break;
            }
            case WEST: {
                GlStateManager.func_179137_b((double)-0.501, (double)yOffset, (double)xOffset);
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179137_b((double)0.501, (double)yOffset, (double)(-xOffset));
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }
}

