/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.events;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.thetorg.items.SpawnerCompass;

public class SpawnerDetectionHandler {
    private static ChunkPos lastChunk = new ChunkPos(0, 0);
    private static final int CHECK_RADIUS = 10;

    @SubscribeEvent
    public void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        ChunkPos currentChunk;
        EntityPlayer player;
        ItemStack heldItem;
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntityLiving() instanceof EntityPlayer && (heldItem = (player = (EntityPlayer)event.getEntityLiving()).func_184614_ca()) != null && heldItem.func_77973_b() instanceof SpawnerCompass && !(currentChunk = new ChunkPos(player.func_180425_c())).equals((Object)lastChunk)) {
            lastChunk = currentChunk;
            int spawnerDistance = this.findClosestSpawnerHorizontalDistance(player.field_70170_p, currentChunk, player);
            this.updateCompassDistance(heldItem, spawnerDistance);
        }
    }

    public int findClosestSpawnerHorizontalDistance(World world, ChunkPos chunkPos, EntityPlayer player) {
        int distance = 16;
        int shortest = 16;
        for (int dx = -10; dx <= 10; ++dx) {
            for (int dz = -10; dz <= 10; ++dz) {
                ChunkPos checkChunkPos = new ChunkPos(chunkPos.field_77276_a + dx, chunkPos.field_77275_b + dz);
                TileEntity spawner = this.chunkContainsSpawner(world, checkChunkPos);
                if (spawner == null) continue;
                int x = Math.abs((int)player.field_70165_t - spawner.func_174877_v().func_177958_n());
                int z = Math.abs((int)player.field_70161_v - spawner.func_174877_v().func_177952_p());
                distance = 16 - (int)Math.sqrt(x * x + z * z) / 16;
                shortest = Math.min(distance, shortest);
            }
        }
        System.out.println("TORGO: " + shortest);
        return shortest;
    }

    private TileEntity chunkContainsSpawner(World world, ChunkPos chunkPos) {
        Chunk chunk = world.func_72964_e(chunkPos.field_77276_a, chunkPos.field_77275_b);
        if (!chunk.func_177410_o()) {
            return null;
        }
        for (TileEntity tileEntity : chunk.func_177434_r().values()) {
            if (!(tileEntity instanceof TileEntityMobSpawner)) continue;
            return tileEntity;
        }
        return null;
    }

    private void updateCompassDistance(ItemStack compass, int spawnerDistance) {
        compass.func_77964_b(spawnerDistance);
    }
}

