/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.blocks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.thetorg.TheTorg;
import org.thetorg.blocks.CustomBlock;
import org.thetorg.blocks.TorgoSignTileEntity;

public class TorgoSignBlock
extends CustomBlock
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected final String materialType;

    public TorgoSignBlock(String materialType) {
        super(Material.field_151573_f, "torgo_sign_" + materialType);
        this.materialType = materialType;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(3.0f);
        this.func_149752_b(15.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (this.isWrench(heldItem)) {
            if (!world.field_72995_K) {
                EnumFacing newFacing = this.getFacingFromSide(side);
                world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)newFacing), 3);
            }
            return true;
        }
        if (player.func_70093_af() && heldItem.func_190926_b()) {
            if (!world.field_72995_K) {
                player.openGui((Object)TheTorg.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    private boolean isWrench(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        String itemName = stack.func_77973_b().getRegistryName().toString();
        return itemName.contains("wrench") || itemName.contains("hammer") || itemName.equals("minecraft:iron_pickaxe") || itemName.equals("minecraft:diamond_pickaxe");
    }

    private EnumFacing getFacingFromSide(EnumFacing clickedSide) {
        switch (clickedSide) {
            case NORTH: {
                return EnumFacing.NORTH;
            }
            case SOUTH: {
                return EnumFacing.SOUTH;
            }
            case EAST: {
                return EnumFacing.EAST;
            }
            case WEST: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.NORTH;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TorgoSignTileEntity();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        EnumFacing newFacing;
        TileEntity tileEntity = world.func_175625_s(pos);
        NBTTagCompound nbt = null;
        if (tileEntity instanceof TorgoSignTileEntity) {
            nbt = new NBTTagCompound();
            tileEntity.func_189515_b(nbt);
        }
        IBlockState state = world.func_180495_p(pos);
        EnumFacing currentFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        switch (currentFacing) {
            case NORTH: {
                newFacing = EnumFacing.EAST;
                break;
            }
            case EAST: {
                newFacing = EnumFacing.SOUTH;
                break;
            }
            case SOUTH: {
                newFacing = EnumFacing.WEST;
                break;
            }
            case WEST: {
                newFacing = EnumFacing.NORTH;
                break;
            }
            default: {
                newFacing = EnumFacing.NORTH;
            }
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)newFacing), 3);
        if (nbt != null && (tileEntity = world.func_175625_s(pos)) instanceof TorgoSignTileEntity) {
            tileEntity.func_145839_a(nbt);
            tileEntity.func_70296_d();
        }
        return true;
    }
}

