/*
 * Decompiled with CFR 0.152.
 */
package org.thetorg.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.thetorg.blocks.BigBinItemBlock;
import org.thetorg.blocks.BigBinTileEntity;
import org.thetorg.blocks.CustomBlock;
import org.thetorg.utils.Tiers;

public class BigBinBlock
extends CustomBlock {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BigBinBlock() {
        super(Material.field_151573_f, "bigbin");
        this.itemBlock = new BigBinItemBlock(this);
        this.itemBlock.setRegistryName("bigbin");
        this.itemBlock.func_77655_b("bigbin");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(5.0f);
        GameRegistry.registerTileEntity(BigBinTileEntity.class, (ResourceLocation)new ResourceLocation("thetorg", "bigbin"));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BigBinTileEntity) {
            NBTTagCompound nbt = new NBTTagCompound();
            tileEntity.func_189515_b(nbt);
            boolean result = super.rotateBlock(world, pos, axis);
            IBlockState state = world.func_180495_p(pos);
            world.func_184138_a(pos, state, state, 3);
            tileEntity = world.func_175625_s(pos);
            tileEntity.func_145839_a(nbt);
            tileEntity.func_70296_d();
            return result;
        }
        return false;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BigBinTileEntity();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K) {
            EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (te instanceof BigBinTileEntity && facing == blockFacing) {
                int clickedRow = this.calculateRowFromHitY(hitY);
                if (playerIn.func_70093_af()) {
                    ((BigBinTileEntity)te).lockSlot(clickedRow);
                    return true;
                }
                ItemStack stack = playerIn.func_184586_b(hand);
                ItemStack origStack = stack.func_77946_l();
                BigBinTileEntity bin = (BigBinTileEntity)te;
                if (bin.isLastTouchedRecent(stack)) {
                    NonNullList inv = playerIn.field_71071_by.field_70462_a;
                    for (ItemStack item : inv) {
                        if (origStack.func_77969_a(item)) {
                            bin.insertItem(clickedRow, item, false);
                        }
                        if (!(playerIn instanceof EntityPlayerMP)) continue;
                        ((EntityPlayerMP)playerIn).func_71120_a(playerIn.field_71070_bA);
                    }
                } else {
                    bin.insertItem(clickedRow, stack, false);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private RayTraceResult rayTraceServer(EntityPlayer player, World world, double blockReachDistance, float partialTicks) {
        Vec3d vec3d = player.func_174824_e(partialTicks);
        Vec3d vec3d1 = player.func_70676_i(partialTicks);
        Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * blockReachDistance, vec3d1.field_72448_b * blockReachDistance, vec3d1.field_72449_c * blockReachDistance);
        return world.func_147447_a(vec3d, vec3d2, false, false, true);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        if (!worldIn.field_72995_K) {
            IBlockState state = worldIn.func_180495_p(pos);
            EnumFacing blockFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            RayTraceResult rayTrace = this.rayTraceServer(playerIn, worldIn, 200.0, 1.0f);
            if (playerIn.field_71075_bZ.field_75098_d && rayTrace.field_178784_b != blockFacing) {
                return;
            }
            if (rayTrace != null && rayTrace.field_178784_b == blockFacing) {
                double hitY = rayTrace.field_72307_f.field_72448_b - (double)pos.func_177956_o();
                int clickedRow = this.calculateRowFromHitY(hitY);
                TileEntity te = worldIn.func_175625_s(pos);
                if (te instanceof BigBinTileEntity) {
                    ItemStack removed = ItemStack.field_190927_a;
                    BigBinTileEntity bigBin = (BigBinTileEntity)te;
                    ItemStack stackInRow = bigBin.getStackInSlot(clickedRow);
                    if (stackInRow.func_190926_b()) {
                        return;
                    }
                    removed = playerIn.func_70093_af() ? bigBin.extractItem(clickedRow, 1, false) : bigBin.extractItem(clickedRow, stackInRow.func_77976_d(), false);
                    if (!removed.func_190926_b() && !playerIn.field_71071_by.func_70441_a(removed)) {
                        EntityItem entityItem = new EntityItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, removed);
                        worldIn.func_72838_d((Entity)entityItem);
                    }
                }
            }
        }
    }

    private int calculateRowFromHitY(double hitY) {
        int clickedRow;
        if (hitY > 1.0) {
            clickedRow = 0;
        } else if (hitY < 0.0) {
            clickedRow = 3;
        } else {
            clickedRow = (int)Math.floor((hitY -= 0.19) / 0.19);
            clickedRow = 3 - clickedRow;
        }
        if (clickedRow < 0) {
            clickedRow = 0;
        }
        if (clickedRow >= 4) {
            clickedRow = 3;
        }
        return clickedRow;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_176731_b((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public PropertyDirection getFacing() {
        return FACING;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_77942_o()) {
            BigBinTileEntity te = (BigBinTileEntity)worldIn.func_175625_s(pos);
            int i = 0;
            while (true) {
                if (i >= BigBinTileEntity.internalStorageSlotCount) break;
                te.itemsStored[i] = new ItemStack(stack.func_77978_p().func_74775_l("Items" + i));
                te.itemsLocked[i] = stack.func_77978_p().func_74767_n("itemsLocked" + i);
                te.itemsCount[i] = stack.func_77978_p().func_74762_e("itemsCount" + i);
                ++i;
            }
            te.tier = Tiers.valueOf(stack.func_77978_p().func_74779_i("Tier"));
            te.func_70296_d();
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof BigBinTileEntity && !world.field_72995_K) {
            BigBinTileEntity te = (BigBinTileEntity)tileEntity;
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            int i = 0;
            while (true) {
                if (i >= BigBinTileEntity.internalStorageSlotCount) break;
                if (!te.itemsStored[i].func_190926_b()) {
                    NBTTagCompound itemCompound = new NBTTagCompound();
                    te.itemsStored[i].func_77955_b(itemCompound);
                    stack.func_77978_p().func_74782_a("Items" + i, (NBTBase)itemCompound);
                }
                stack.func_77978_p().func_74757_a("itemsLocked" + i, te.itemsLocked[i]);
                stack.func_77978_p().func_74768_a("itemsCount" + i, te.itemsCount[i]);
                ++i;
            }
            stack.func_77978_p().func_74778_a("Tier", te.tier.name());
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            world.func_72838_d((Entity)entityItem);
            world.func_175713_t(pos);
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Tiers tier : Tiers.values()) {
            ItemStack stack = new ItemStack((Block)this, 1);
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74778_a("Tier", tier.name());
            stack.func_77982_d(tagCompound);
            items.add((Object)stack);
        }
    }
}

