/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.util.parsers;

import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.util.parsers.IContentParser;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public abstract class BaseParser
implements IContentParser {
    public static final String INPUT = "input";
    public static final String INPUT2 = "input2";
    public static final String OUTPUT = "output";
    public static final String OUTPUT2 = "output2";
    public static final String OUTPUT3 = "output3";
    public static final String OUTPUT4 = "output4";
    public static final String FLUID = "fluid";
    public static final String ENERGY = "energy";
    public static final String ENERGY_MOD = "energy_mod";
    public static final String CHANCE = "chance";
    public static final String TYPE = "type";
    public static final String COMMENT = "//";
    public static final String CONSTANT = "constant";
    public static final String ENTRY = "entry";
    public static final String ORE = "ore";
    public static final String NAME = "name";
    public static final String REMOVE = "remove";
    public static final String ITEM = "item";
    public static final String DATA = "data";
    public static final String WILDCARD = "wildcard";
    public static final String COUNT = "count";
    public static final String AMOUNT = "amount";
    public static final String NBT = "nbt";
    protected int parseCount = 0;
    protected int errorCount = 0;
    protected static final Map<String, ItemStack> CONSTANTS = new Object2ObjectOpenHashMap();
    protected static final Map<String, ItemStack> ORES = new Object2ObjectOpenHashMap();

    @Override
    public boolean parseContent(JsonElement content) {
        if (content.isJsonNull()) {
            return false;
        }
        if (content.isJsonArray()) {
            this.parseArray(content.getAsJsonArray());
            return true;
        }
        return false;
    }

    @Override
    public void postProcess() {
    }

    public abstract void parseArray(JsonArray var1);

    public static boolean hasOre(String oreName) {
        return ORES.containsKey(oreName);
    }

    public static ItemStack getOre(String oreName) {
        return ORES.get(oreName);
    }

    public static ItemStack parseItemStack(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return ItemStack.field_190927_a;
        }
        Item item = null;
        String ore = "";
        int data = 0;
        int count = 1;
        if (element.isJsonPrimitive()) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.getAsString()));
            return item == null ? ItemStack.field_190927_a : new ItemStack(item);
        }
        JsonObject itemObject = element.getAsJsonObject();
        if (itemObject.has(DATA)) {
            data = itemObject.get(DATA).getAsInt();
        } else if (itemObject.has(WILDCARD) && itemObject.get(WILDCARD).getAsBoolean()) {
            data = Short.MAX_VALUE;
        }
        if (itemObject.has(COUNT)) {
            count = itemObject.get(COUNT).getAsInt();
        }
        if (itemObject.has(CONSTANT)) {
            ore = itemObject.get(CONSTANT).getAsString();
            if (CONSTANTS.containsKey(ore)) {
                return ItemHelper.cloneStack((ItemStack)CONSTANTS.get(ore), (int)count);
            }
            ore = "";
        }
        if (itemObject.has(ORE)) {
            ore = itemObject.get(ORE).getAsString();
        }
        if (ItemHelper.oreNameExists((String)ore)) {
            if (ORES.containsKey(ore)) {
                return ItemHelper.cloneStack((ItemStack)ORES.get(ore), (int)count);
            }
            NonNullList ores = OreDictionary.getOres((String)ore, (boolean)false);
            if (!ores.isEmpty()) {
                return ItemHelper.cloneStack((ItemStack)((ItemStack)ores.get(0)), (int)count);
            }
        }
        if (itemObject.has(ITEM)) {
            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemObject.get(ITEM).getAsString()));
        }
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = new ItemStack(item, count, data);
        if (itemObject.has(NBT)) {
            try {
                stack.func_77982_d(JsonToNBT.func_180713_a((String)itemObject.get(NBT).getAsString()));
            }
            catch (NBTException t) {
                return ItemStack.field_190927_a;
            }
        }
        return stack;
    }

    public static FluidStack parseFluidStack(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        Fluid fluid = null;
        int amount = 1000;
        if (element.isJsonPrimitive()) {
            fluid = FluidRegistry.getFluid((String)element.getAsString());
            return fluid == null ? null : new FluidStack(fluid, amount);
        }
        JsonObject fluidObject = element.getAsJsonObject();
        if (fluidObject.has(AMOUNT)) {
            amount = fluidObject.get(AMOUNT).getAsInt();
        }
        if (fluidObject.has(FLUID)) {
            fluid = FluidRegistry.getFluid((String)fluidObject.get(FLUID).getAsString());
        }
        if (fluid == null) {
            return null;
        }
        FluidStack stack = new FluidStack(fluid, amount);
        if (fluidObject.has(NBT)) {
            try {
                stack.tag = JsonToNBT.func_180713_a((String)fluidObject.get(NBT).getAsString());
            }
            catch (NBTException t) {
                return null;
            }
        }
        return stack;
    }

    public static int getChance(JsonElement element) {
        JsonObject chanceObject = element.getAsJsonObject();
        if (chanceObject.has(CHANCE)) {
            return chanceObject.get(CHANCE).getAsInt();
        }
        return 100;
    }
}

