/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei.machine.transposer;

import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.gui.client.machine.GuiTransposer;
import cofh.thermalexpansion.plugins.jei.machine.transposer.TransposerRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.transposer.TransposerRecipeWrapper;
import cofh.thermalexpansion.plugins.jei.machine.transposer.TransposerRecipeWrapperContainer;
import cofh.thermalexpansion.util.managers.machine.TransposerManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TransposerRecipeCategoryFill
extends TransposerRecipeCategory {
    public static void initialize(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipes(TransposerRecipeCategoryFill.getRecipes(guiHelper, registry.getIngredientRegistry()), "thermalexpansion.transposer_fill");
        registry.addRecipeCatalyst((Object)BlockMachine.machineTransposer, new String[]{"thermalexpansion.transposer_fill"});
    }

    public static List<TransposerRecipeWrapper> getRecipes(IGuiHelper guiHelper, IIngredientRegistry ingredientRegistry) {
        ArrayList<TransposerRecipeWrapper> recipes = new ArrayList<TransposerRecipeWrapper>();
        for (TransposerManager.TransposerRecipe recipe : TransposerManager.getFillRecipeList()) {
            recipes.add(new TransposerRecipeWrapper(guiHelper, recipe, "thermalexpansion.transposer_fill"));
        }
        List ingredients = ingredientRegistry.getIngredients(ItemStack.class);
        for (ItemStack ingredient : ingredients) {
            if (!ingredient.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) || !ingredient.func_82833_r().contains("Cake Feeder") && !ingredient.func_82833_r().contains("Bucket") && !ingredient.func_82833_r().contains("Milk")) continue;
            TransposerRecipeWrapperContainer wrapper = new TransposerRecipeWrapperContainer(guiHelper, ingredient, "thermalexpansion.transposer_fill");
            if (((List)wrapper.inputs.get(0)).isEmpty() || ((List)wrapper.outputs.get(0)).isEmpty() || ((List)wrapper.inputFluids.get(0)).isEmpty()) continue;
            recipes.add(wrapper);
        }
        return recipes;
    }

    public TransposerRecipeCategoryFill(IGuiHelper guiHelper) {
        super(guiHelper);
        this.localizedName = this.localizedName + " - " + StringHelper.localize((String)"gui.thermalexpansion.jei.transposer.modeFill");
        this.icon = guiHelper.createDrawable(GuiTransposer.TEXTURE, 176, 48, 16, 16);
    }

    @Nonnull
    public String getUid() {
        return "thermalexpansion.transposer_fill";
    }

    public void setRecipe(IRecipeLayout recipeLayout, TransposerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(ItemStack.class);
        List outputs = ingredients.getOutputs(ItemStack.class);
        List fluids = ingredients.getInputs(FluidStack.class);
        IFocus focus = recipeLayout.getFocus();
        if (focus != null) {
            if (focus.getMode() == IFocus.Mode.OUTPUT && focus.getValue() instanceof ItemStack) {
                ArrayList<FluidStack> focusFluids = new ArrayList<FluidStack>();
                ItemStack output = (ItemStack)focus.getValue();
                FluidStack contained = FluidHelper.getFluidStackFromHandler((ItemStack)output);
                if (contained != null) {
                    for (FluidStack fluid : (List)fluids.get(0)) {
                        if (!FluidHelper.isFluidEqual((FluidStack)contained, (FluidStack)fluid)) continue;
                        focusFluids.add(fluid);
                    }
                    if (focusFluids.size() != ((List)fluids.get(0)).size()) {
                        fluids = Collections.singletonList(focusFluids);
                    }
                }
            } else if (focus.getMode() == IFocus.Mode.INPUT && focus.getValue() instanceof FluidStack) {
                ArrayList<ItemStack> focusOutputs = new ArrayList<ItemStack>();
                FluidStack fluid = (FluidStack)focus.getValue();
                for (ItemStack stack : (List)outputs.get(0)) {
                    FluidStack contained = FluidHelper.getFluidStackFromHandler((ItemStack)stack);
                    if (contained != null && !FluidHelper.isFluidEqual((FluidStack)fluid, (FluidStack)contained)) continue;
                    focusOutputs.add(stack);
                }
                if (focusOutputs.size() != ((List)inputs.get(0)).size()) {
                    outputs = Collections.singletonList(focusOutputs);
                }
            }
        }
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        Map fluidIngredients = guiFluidStacks.getGuiIngredients();
        recipeWrapper.setGuiFluids(fluidIngredients);
        guiItemStacks.init(0, true, 30, 10);
        guiItemStacks.init(1, false, 30, 41);
        guiFluidStacks.init(0, true, 103, 1, 16, 60, 1000, false, (IDrawable)this.tankOverlay);
        guiItemStacks.set(0, (List)inputs.get(0));
        guiItemStacks.set(1, (List)outputs.get(0));
        guiFluidStacks.set(0, (List)fluids.get(0));
        guiFluidStacks.addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {});
    }
}

