/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.plugins.jei;

import cofh.core.util.helpers.RenderHelper;
import cofh.thermalexpansion.block.storage.BlockCache;
import cofh.thermalexpansion.block.storage.BlockCell;
import cofh.thermalexpansion.block.storage.BlockStrongbox;
import cofh.thermalexpansion.block.storage.BlockTank;
import cofh.thermalexpansion.plugins.jei.Descriptions;
import cofh.thermalexpansion.plugins.jei.device.coolant.CoolantCategory;
import cofh.thermalexpansion.plugins.jei.device.factorizer.FactorizerRecipeCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.compression.CompressionFuelCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.enervation.EnervationFuelCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.magmatic.MagmaticFuelCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.numismatic.NumismaticFuelCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.reactant.ReactantFuelCategory;
import cofh.thermalexpansion.plugins.jei.dynamo.steam.SteamFuelCategory;
import cofh.thermalexpansion.plugins.jei.machine.brewer.BrewerRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.centrifuge.CentrifugeRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.charger.ChargerRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.compactor.CompactorRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.crafter.CrafterRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.crucible.CrucibleRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.enchanter.EnchanterRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.extruder.ExtruderRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.furnace.FurnaceRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.insolator.InsolatorRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.precipitator.PrecipitatorRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.pulverizer.PulverizerRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.refinery.RefineryRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.sawmill.SawmillRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.smelter.SmelterRecipeCategory;
import cofh.thermalexpansion.plugins.jei.machine.transposer.TransposerRecipeCategory;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@JEIPlugin
public class JEIPluginTE
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IGuiHelper guiHelper;
    public static IJeiRuntime jeiRuntime;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new Item[]{BlockCell.itemBlock});
        subtypeRegistry.useNbtForSubtypes(new Item[]{BlockTank.itemBlock});
        subtypeRegistry.useNbtForSubtypes(new Item[]{BlockCache.itemBlock});
        subtypeRegistry.useNbtForSubtypes(new Item[]{BlockStrongbox.itemBlock});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        guiHelper = jeiHelpers.getGuiHelper();
        FurnaceRecipeCategory.register(registry);
        PulverizerRecipeCategory.register(registry);
        SawmillRecipeCategory.register(registry);
        SmelterRecipeCategory.register(registry);
        InsolatorRecipeCategory.register(registry);
        CompactorRecipeCategory.register(registry);
        CrucibleRecipeCategory.register(registry);
        RefineryRecipeCategory.register(registry);
        TransposerRecipeCategory.register(registry);
        ChargerRecipeCategory.register(registry);
        CentrifugeRecipeCategory.register(registry);
        CrafterRecipeCategory.register(registry);
        BrewerRecipeCategory.register(registry);
        EnchanterRecipeCategory.register(registry);
        PrecipitatorRecipeCategory.register(registry);
        ExtruderRecipeCategory.register(registry);
        SteamFuelCategory.register(registry);
        MagmaticFuelCategory.register(registry);
        CompressionFuelCategory.register(registry);
        ReactantFuelCategory.register(registry);
        EnervationFuelCategory.register(registry);
        NumismaticFuelCategory.register(registry);
        FactorizerRecipeCategory.register(registry);
        CoolantCategory.register(registry);
    }

    public void register(IModRegistry registry) {
        jeiHelpers = registry.getJeiHelpers();
        guiHelper = jeiHelpers.getGuiHelper();
        FurnaceRecipeCategory.initialize(registry);
        PulverizerRecipeCategory.initialize(registry);
        SawmillRecipeCategory.initialize(registry);
        SmelterRecipeCategory.initialize(registry);
        InsolatorRecipeCategory.initialize(registry);
        CompactorRecipeCategory.initialize(registry);
        CrucibleRecipeCategory.initialize(registry);
        RefineryRecipeCategory.initialize(registry);
        TransposerRecipeCategory.initialize(registry);
        ChargerRecipeCategory.initialize(registry);
        CentrifugeRecipeCategory.initialize(registry);
        CrafterRecipeCategory.initialize(registry);
        BrewerRecipeCategory.initialize(registry);
        EnchanterRecipeCategory.initialize(registry);
        PrecipitatorRecipeCategory.initialize(registry);
        ExtruderRecipeCategory.initialize(registry);
        SteamFuelCategory.initialize(registry);
        MagmaticFuelCategory.initialize(registry);
        CompressionFuelCategory.initialize(registry);
        ReactantFuelCategory.initialize(registry);
        EnervationFuelCategory.initialize(registry);
        NumismaticFuelCategory.initialize(registry);
        FactorizerRecipeCategory.initialize(registry);
        CoolantCategory.initialize(registry);
        Descriptions.register(registry);
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIPluginTE.jeiRuntime = jeiRuntime;
    }

    public static void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null) {
            return;
        }
        GL11.glPushMatrix();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderHelper.setBlockTextureSheet();
        int color = fluid.getFluid().getColor(fluid);
        RenderHelper.setGLColorFromInt((int)color);
        JEIPluginTE.drawTiledTexture(x, y, RenderHelper.getTexture((ResourceLocation)fluid.getFluid().getStill(fluid)), width, height);
        GL11.glPopMatrix();
    }

    public static void drawTiledTexture(int x, int y, TextureAtlasSprite icon, int width, int height) {
        for (int i = 0; i < width; i += 16) {
            for (int j = 0; j < height; j += 16) {
                int drawWidth = Math.min(width - i, 16);
                int drawHeight = Math.min(height - j, 16);
                JEIPluginTE.drawScaledTexturedModelRectFromIcon(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawScaledTexturedModelRectFromIcon(int x, int y, TextureAtlasSprite icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.func_94209_e();
        double maxU = icon.func_94212_f();
        double minV = icon.func_94206_g();
        double maxV = icon.func_94210_h();
        BufferBuilder buffer = Tessellator.func_178181_a().func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0).func_181675_d();
        buffer.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a(minU + (maxU - minU) * (double)width / 16.0, minV).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(minU, minV).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

