/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.device;

import cofh.core.gui.GuiContainerCore;
import cofh.core.gui.element.ElementBase;
import cofh.core.gui.element.ElementButton;
import cofh.core.gui.element.ElementSimple;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalexpansion.block.device.TileItemBuffer;
import cofh.thermalexpansion.gui.client.device.GuiDeviceBase;
import cofh.thermalexpansion.gui.container.device.ContainerItemBuffer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiItemBuffer
extends GuiDeviceBase {
    public static final String TEX_PATH = "thermalexpansion:textures/gui/device/item_buffer.png";
    public static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/device/item_buffer.png");
    private TileItemBuffer myTile;
    private ElementButton decInput;
    private ElementButton incInput;
    private ElementButton decOutput;
    private ElementButton incOutput;

    public GuiItemBuffer(InventoryPlayer inventory, TileEntity tile) {
        super((Container)new ContainerItemBuffer(inventory, tile), tile, inventory.field_70458_d, TEXTURE);
        this.generateInfo("tab.thermalexpansion.device.item_buffer");
        this.myTile = (TileItemBuffer)tile;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ElementSimple infoInput = (ElementSimple)new ElementSimple((GuiContainerCore)this, 24, 16).setSize(20, 20).setTexture("cofh:textures/gui/elements/info_input.png", 20, 20);
        ElementSimple infoOutput = (ElementSimple)new ElementSimple((GuiContainerCore)this, 132, 16).setSize(20, 20).setTexture("cofh:textures/gui/elements/info_output.png", 20, 20);
        this.addElement((ElementBase)infoInput);
        this.addElement((ElementBase)infoOutput);
        this.decInput = new ElementButton((GuiContainerCore)this, 19, 56, "DecInput", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incInput = new ElementButton((GuiContainerCore)this, 35, 56, "IncInput", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.decOutput = new ElementButton((GuiContainerCore)this, 127, 56, "DecOutput", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incOutput = new ElementButton((GuiContainerCore)this, 143, 56, "IncOutput", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.decInput);
        this.addElement((ElementBase)this.incInput);
        this.addElement((ElementBase)this.decOutput);
        this.addElement((ElementBase)this.incOutput);
    }

    protected void updateElementInformation() {
        int change2;
        int change;
        super.updateElementInformation();
        if (GuiScreen.func_146272_n()) {
            change = 64;
            change2 = 32;
        } else if (GuiScreen.func_146271_m()) {
            change = 4;
            change2 = 1;
        } else {
            change = 16;
            change2 = 8;
        }
        if (this.myTile.amountInput > 0) {
            this.decInput.setActive();
            this.decInput.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.device.item_buffer.decInput") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.decInput.setDisabled();
            this.decInput.clearToolTip();
        }
        if (this.myTile.amountInput < 64) {
            this.incInput.setActive();
            this.incInput.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.device.item_buffer.incInput") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.incInput.setDisabled();
            this.incInput.clearToolTip();
        }
        if (this.myTile.amountOutput > 0) {
            this.decOutput.setActive();
            this.decOutput.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.device.item_buffer.decOutput") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.decOutput.setDisabled();
            this.decOutput.clearToolTip();
        }
        if (this.myTile.amountOutput < 64) {
            this.incOutput.setActive();
            this.incOutput.setToolTip(StringHelper.localize((String)"gui.thermalexpansion.device.item_buffer.incOutput") + " " + StringHelper.formatNumber((long)change) + "/" + StringHelper.formatNumber((long)change2));
        } else {
            this.incOutput.setDisabled();
            this.incOutput.clearToolTip();
        }
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
        float pitch;
        int change;
        if (GuiScreen.func_146272_n()) {
            change = 64;
            pitch = 0.9f;
            if (mouseButton == 1) {
                change = 32;
                pitch = 0.8f;
            }
        } else if (GuiScreen.func_146271_m()) {
            change = 4;
            pitch = 0.5f;
            if (mouseButton == 1) {
                change = 1;
                pitch = 0.4f;
            }
        } else {
            change = 16;
            pitch = 0.7f;
            if (mouseButton == 1) {
                change = 8;
                pitch = 0.6f;
            }
        }
        int curInput = this.myTile.amountInput;
        int curOutput = this.myTile.amountOutput;
        switch (buttonName) {
            case "DecInput": {
                this.myTile.amountInput -= change;
                pitch -= 0.1f;
                break;
            }
            case "IncInput": {
                this.myTile.amountInput += change;
                pitch += 0.1f;
                break;
            }
            case "DecOutput": {
                this.myTile.amountOutput -= change;
                pitch -= 0.1f;
                break;
            }
            case "IncOutput": {
                this.myTile.amountOutput += change;
                pitch += 0.1f;
            }
        }
        GuiItemBuffer.playClickSound((float)pitch);
        this.myTile.sendModePacket();
        this.myTile.amountInput = curInput;
        this.myTile.amountOutput = curOutput;
    }

    protected void func_146979_b(int x, int y) {
        String input = StringHelper.formatNumber((long)this.myTile.amountInput);
        String output = StringHelper.formatNumber((long)this.myTile.amountOutput);
        this.field_146289_q.func_78276_b(input, this.getCenteredOffset(input, 34), 42, 0x404040);
        this.field_146289_q.func_78276_b(output, this.getCenteredOffset(output, 142), 42, 0x404040);
        super.func_146979_b(x, y);
    }
}

