/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiCentrifuge;
import cofh.thermalexpansion.gui.container.machine.ContainerCentrifuge;
import cofh.thermalexpansion.util.managers.machine.CentrifugeManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileCentrifuge
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.CENTRIFUGE.getMetadata();
    public static int basePower = 20;
    private CentrifugeManager.CentrifugeRecipe curRecipe;
    private int inputTracker;
    private int outputTracker;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(8000);

    public static void initialize() {
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE] = new SideConfig();
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE].numConfig = 7;
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE].slotGroups = new int[][]{new int[0], {0}, {1, 2, 3, 4}, new int[0], {1, 2, 3, 4}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 4}};
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 7, 8};
        TileCentrifuge.SIDE_CONFIGS[TileCentrifuge.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TileCentrifuge.ALT_SIDE_CONFIGS[TileCentrifuge.TYPE] = new SideConfig();
        TileCentrifuge.ALT_SIDE_CONFIGS[TileCentrifuge.TYPE].numConfig = 2;
        TileCentrifuge.ALT_SIDE_CONFIGS[TileCentrifuge.TYPE].slotGroups = new int[][]{new int[0], {0}, {1, 2, 3, 4}, new int[0], {1, 2, 3, 4}, {0, 1, 2, 3, 4}, {0, 1, 2, 3, 4}};
        TileCentrifuge.ALT_SIDE_CONFIGS[TileCentrifuge.TYPE].sideTypes = new int[]{0, 7};
        TileCentrifuge.ALT_SIDE_CONFIGS[TileCentrifuge.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileCentrifuge.SLOT_CONFIGS[TileCentrifuge.TYPE] = new SlotConfig();
        TileCentrifuge.SLOT_CONFIGS[TileCentrifuge.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false, false, false};
        TileCentrifuge.SLOT_CONFIGS[TileCentrifuge.TYPE].allowExtractionSlot = new boolean[]{false, true, true, true, true, false};
        TileCentrifuge.VALID_AUGMENTS[TileCentrifuge.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        TileCentrifuge.LIGHT_VALUES[TileCentrifuge.TYPE] = 4;
        GameRegistry.registerTileEntity(TileCentrifuge.class, (String)"thermalexpansion:machine_centrifuge");
        TileCentrifuge.config();
    }

    public static void config() {
        String category = "Machine.Centrifuge";
        BlockMachine.enable[TileCentrifuge.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Centrifugal Separator. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 5000, comment);
        TileCentrifuge.ENERGY_CONFIGS[TileCentrifuge.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileCentrifuge() {
        this.inventory = new ItemStack[6];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < this.curRecipe.getInput().func_190916_E()) {
            return false;
        }
        FluidStack fluid = this.curRecipe.getFluid();
        List<ItemStack> outputs = this.curRecipe.getOutput();
        if (outputs.isEmpty()) {
            return fluid != null && this.tank.fill(fluid, false) == fluid.amount;
        }
        if (fluid != null && !this.augmentSecondaryNull && this.tank.fill(fluid, false) != fluid.amount) {
            return false;
        }
        boolean valid = true;
        for (int i = 0; i < outputs.size(); ++i) {
            ItemStack output = outputs.get(i);
            valid &= this.inventory[i + 1].func_190926_b() || ItemHelper.itemsIdentical((ItemStack)this.inventory[i + 1], (ItemStack)output) && this.inventory[i + 1].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
        }
        return valid;
    }

    @Override
    protected boolean hasValidInput() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            return false;
        }
        return this.curRecipe.getInput().func_190916_E() <= this.inventory[0].func_190916_E();
    }

    @Override
    protected void clearRecipe() {
        this.curRecipe = null;
    }

    @Override
    protected void getRecipe() {
        this.curRecipe = CentrifugeManager.getRecipe(this.inventory[0]);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.curRecipe.getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            this.processOff();
            return;
        }
        List<ItemStack> outputs = this.curRecipe.getOutput();
        List<Integer> chances = this.curRecipe.getChance();
        for (int i = 0; i < outputs.size(); ++i) {
            if (this.field_145850_b.field_73012_v.nextInt(this.secondaryChance) >= chances.get(i)) continue;
            if (this.inventory[i + 1].func_190926_b()) {
                this.inventory[i + 1] = ItemHelper.cloneStack((ItemStack)outputs.get(i));
                continue;
            }
            this.inventory[i + 1].func_190917_f(outputs.get(i).func_190916_E());
        }
        FluidStack fluid = this.curRecipe.getFluid();
        this.tank.fill(fluid, true);
        this.inventory[0].func_190918_g(this.curRecipe.getInput().func_190916_E());
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        this.transferOutputFluid();
        boolean foundOutput = false;
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]])) continue;
            for (int j = 1; j < 5; ++j) {
                if (!this.transferItem(j, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                foundOutput = true;
            }
            if (!foundOutput) continue;
            this.outputTracker = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!SideConfig.isSecondaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiCentrifuge(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerCentrifuge(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOut2");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("TrackOut2", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileCentrifuge.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, false, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileCentrifuge)TileCentrifuge.this).sideConfig.sideTypes[TileCentrifuge.this.sideCache[from.ordinal()]])) {
                        return TileCentrifuge.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileCentrifuge)TileCentrifuge.this).sideConfig.sideTypes[TileCentrifuge.this.sideCache[from.ordinal()]])) {
                        return TileCentrifuge.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

