/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.dynamo;

import cofh.core.fluid.FluidTankCore;
import cofh.core.gui.container.ContainerTileAugmentable;
import cofh.core.network.PacketBase;
import cofh.core.render.TextureHelper;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.dynamo.TileDynamoBase;
import cofh.thermalexpansion.gui.client.dynamo.GuiDynamoMagmatic;
import cofh.thermalexpansion.util.managers.device.CoolantManager;
import cofh.thermalexpansion.util.managers.dynamo.MagmaticManager;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileDynamoMagmatic
extends TileDynamoBase {
    protected static final EnergyConfig ENERGY_CONFIG = new EnergyConfig();
    protected static final HashSet<String> VALID_AUGMENTS = new HashSet();
    public static boolean enable = true;
    public static int basePower = 40;
    public static int fluidAmount = 100;
    private FluidTankCore fuelTank = new FluidTankCore(8000);
    private FluidTankCore coolantTank = new FluidTankCore(8000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.LAVA, 1000);
    private int coolantRF;
    private int coolantFactor;
    protected boolean augmentCoolant;
    protected boolean flagTank;

    public static void initialize() {
        VALID_AUGMENTS.addAll(VALID_AUGMENTS_BASE);
        VALID_AUGMENTS.add("dynamoBoiler");
        VALID_AUGMENTS.add("dynamoMagmaticCoolant");
        GameRegistry.registerTileEntity(TileDynamoMagmatic.class, (String)"thermalexpansion:dynamo_magmatic");
        TileDynamoMagmatic.config();
    }

    public static void config() {
        String category = "Dynamo.Magmatic";
        enable = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy generation (in RF/t) for a Magmatic Dynamo. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 1000, comment);
        ENERGY_CONFIG.setDefaultParams(basePower, smallStorage);
    }

    protected String getTileName() {
        return "tile.thermalexpansion.dynamo.magmatic.name";
    }

    @Override
    protected EnergyConfig getEnergyConfig() {
        return ENERGY_CONFIG;
    }

    @Override
    protected HashSet<String> getValidAugments() {
        return VALID_AUGMENTS;
    }

    @Override
    public int getLightValue() {
        return this.isActive ? 14 : 0;
    }

    @Override
    protected boolean canStart() {
        if (this.augmentBoiler || this.augmentCoolant) {
            return !(this.fuelRF <= 0 && this.fuelTank.getFluidAmount() < fluidAmount || this.coolantRF <= 0 && this.coolantTank.getFluidAmount() < fluidAmount);
        }
        return this.fuelTank.getFluidAmount() >= fluidAmount;
    }

    @Override
    protected boolean canFinish() {
        if (this.augmentBoiler || this.augmentCoolant) {
            return this.fuelRF <= 0 || this.coolantRF <= 0;
        }
        return this.fuelRF <= 0;
    }

    @Override
    protected void processStart() {
        if (this.augmentBoiler || this.augmentCoolant) {
            if (this.fuelRF <= 0) {
                this.fuelRF += MagmaticManager.getFuelEnergy100mB(this.fuelTank.getFluid()) * (this.energyMod + this.coolantFactor) / 100;
                this.fuelTank.drain(fluidAmount, true);
            }
            if (this.coolantRF <= 0) {
                this.coolantRF += CoolantManager.getCoolantRF100mB(this.coolantTank.getFluid());
                this.coolantFactor = this.augmentBoiler ? 0 : CoolantManager.getCoolantFactor(this.coolantTank.getFluid()) - 20;
                this.coolantTank.drain(fluidAmount, true);
            }
            return;
        }
        this.fuelRF += MagmaticManager.getFuelEnergy100mB(this.fuelTank.getFluid()) * this.energyMod / 100;
        this.fuelTank.drain(fluidAmount, true);
    }

    @Override
    protected int processTick() {
        if (this.augmentBoiler) {
            this.fuelRF -= this.energyConfig.maxPower;
            this.coolantRF -= this.energyConfig.maxPower;
            this.transferSteam();
            return this.energyConfig.maxPower;
        }
        this.lastEnergy = this.calcEnergy();
        this.energyStorage.modifyEnergyStored(this.lastEnergy);
        this.fuelRF -= this.lastEnergy;
        this.coolantRF -= this.augmentCoolant ? this.lastEnergy : 0;
        this.transferEnergy();
        return this.lastEnergy;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBaseUnderlayTexture() {
        return TextureHelper.getTexture((ResourceLocation)this.renderFluid.getFluid().getStill(this.renderFluid));
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiDynamoMagmatic(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTileAugmentable(inventory, (TileEntity)this);
    }

    @Override
    public FluidTankCore getTank(int tankIndex) {
        if (tankIndex == 0) {
            return this.fuelTank;
        }
        return this.coolantTank;
    }

    @Override
    public int getFuelEnergy(ItemStack stack) {
        FluidStack fluid = FluidHelper.getFluidForFilledItem((ItemStack)stack);
        return MagmaticManager.isValidFuel(fluid) ? MagmaticManager.getFuelEnergy(fluid) * (this.energyMod + this.coolantFactor) / 100 : 0;
    }

    public boolean showCoolantTank() {
        return (this.augmentBoiler || this.augmentCoolant) && this.flagTank;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.coolantRF = nbt.func_74762_e("Coolant");
        this.coolantFactor = nbt.func_74762_e("CoolantFactor");
        this.fuelTank.readFromNBT(nbt.func_74775_l("FuelTank"));
        this.coolantTank.readFromNBT(nbt.func_74775_l("CoolantTank"));
        if (!MagmaticManager.isValidFuel(this.fuelTank.getFluid())) {
            this.fuelTank.setFluid(null);
        }
        if (!CoolantManager.isValidCoolant(this.coolantTank.getFluid())) {
            this.coolantTank.setFluid(null);
        }
        if (this.fuelTank.getFluid() != null) {
            this.renderFluid = this.fuelTank.getFluid();
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Coolant", this.coolantRF);
        nbt.func_74768_a("CoolantFactor", this.coolantFactor);
        nbt.func_74782_a("FuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("CoolantTank", (NBTBase)this.coolantTank.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentCoolant);
        payload.addFluidStack(this.fuelTank.getFluid());
        payload.addFluidStack(this.coolantTank.getFluid());
        return payload;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addFluidStack(this.fuelTank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.augmentCoolant = payload.getBool();
        this.flagTank = this.augmentBoiler || this.augmentCoolant;
        this.fuelTank.setFluid(payload.getFluidStack());
        this.coolantTank.setFluid(payload.getFluidStack());
        if (this.augmentCoolant) {
            this.coolantFactor = Math.max(0, CoolantManager.getCoolantFactor(this.coolantTank.getFluid()) - 20);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        FluidStack tempRender = payload.getFluidStack();
        this.renderFluid = tempRender == null ? new FluidStack(FluidRegistry.LAVA, 1000) : tempRender;
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentCoolant = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (this.augmentBoiler) {
            this.coolantTank.setLock(FluidRegistry.WATER);
            this.coolantFactor = 0;
        } else if (!this.augmentCoolant) {
            this.coolantTank.drain(this.coolantTank.getCapacity(), true);
            this.coolantRF = 0;
            this.coolantFactor = 0;
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentBoiler && "dynamoBoiler".equals(id)) {
            this.augmentBoiler = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + this.getBasePower(this.level), smallStorage);
            this.energyStorage.setEnergyStored(0);
            this.energyMod -= 40;
            return true;
        }
        if (!this.augmentCoolant && "dynamoMagmaticCoolant".equals(id)) {
            this.augmentCoolant = true;
            this.hasModeAugment = true;
            this.energyConfig.setDefaultParams(this.energyConfig.maxPower + 3 * this.getBasePower(this.level), smallStorage);
            this.energyMod += 15;
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    return FluidTankProperties.convert((FluidTankInfo[])new FluidTankInfo[]{TileDynamoMagmatic.this.fuelTank.getInfo()});
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (from == null || TileDynamoMagmatic.this.augmentCoilDuct || from.ordinal() != TileDynamoMagmatic.this.facing) {
                        if (MagmaticManager.isValidFuel(resource)) {
                            return TileDynamoMagmatic.this.fuelTank.fill(resource, doFill);
                        }
                        if (TileDynamoMagmatic.this.augmentBoiler && resource.getFluid() == FluidRegistry.WATER) {
                            return TileDynamoMagmatic.this.coolantTank.fill(resource, doFill);
                        }
                        if (TileDynamoMagmatic.this.augmentCoolant && CoolantManager.isValidCoolant(resource)) {
                            return TileDynamoMagmatic.this.coolantTank.fill(resource, doFill);
                        }
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || TileDynamoMagmatic.this.augmentCoilDuct || from.ordinal() != TileDynamoMagmatic.this.facing) {
                        if (resource.equals((Object)TileDynamoMagmatic.this.fuelTank.getFluid())) {
                            return TileDynamoMagmatic.this.fuelTank.drain(resource.amount, doDrain);
                        }
                        if ((TileDynamoMagmatic.this.augmentBoiler || TileDynamoMagmatic.this.augmentCoolant) && resource.equals((Object)TileDynamoMagmatic.this.coolantTank.getFluid())) {
                            return TileDynamoMagmatic.this.coolantTank.drain(resource.amount, doDrain);
                        }
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || TileDynamoMagmatic.this.augmentCoilDuct || from.ordinal() != TileDynamoMagmatic.this.facing) {
                        FluidStack ret = TileDynamoMagmatic.this.fuelTank.drain(maxDrain, doDrain);
                        return ret != null ? ret : (TileDynamoMagmatic.this.augmentBoiler || TileDynamoMagmatic.this.augmentCoolant ? TileDynamoMagmatic.this.coolantTank.drain(maxDrain, doDrain) : null);
                    }
                    return null;
                }
            });
        }
        return super.getCapability(capability, from);
    }
}

