/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib.energy.systems;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mekanism.api.energy.IStrictEnergyAcceptor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.modcrafters.mclib.energy.IGenericEnergyStorage;
import net.ndrei.teslacorelib.energy.IEnergySystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J+\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\r0\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/MekanismSystem;", "Lnet/ndrei/teslacorelib/energy/IEnergySystem;", "()V", "MODID", "", "ModId", "getModId", "()Ljava/lang/String;", "hasCapability", "", "capability", "Lnet/minecraftforge/common/capabilities/Capability;", "wrapCapability", "T", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/minecraftforge/common/capabilities/Capability;Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)Ljava/lang/Object;", "wrapItemStack", "stack", "Lnet/minecraft/item/ItemStack;", "wrapTileEntity", "te", "Lnet/minecraft/tileentity/TileEntity;", "side", "Lnet/minecraft/util/EnumFacing;", "Wrapper", "tesla-core-lib"})
public final class MekanismSystem
implements IEnergySystem {
    @NotNull
    public static final String MODID = "mekanism";
    public static final MekanismSystem INSTANCE;

    @Override
    @NotNull
    public String getModId() {
        return MODID;
    }

    @Override
    public boolean hasCapability(@NotNull Capability<?> capability) {
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        return this.isAvailable() && Intrinsics.areEqual((Object)capability.getName(), (Object)"mekanism.api.energy.IStrictEnergyAcceptor");
    }

    @Override
    @Nullable
    public <T> T wrapCapability(@NotNull Capability<T> capability, @NotNull IGenericEnergyStorage energy) {
        Object object;
        Intrinsics.checkParameterIsNotNull(capability, (String)"capability");
        Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
        if (this.hasCapability(capability)) {
            Wrapper wrapper = new Wrapper(energy);
            if (!(wrapper instanceof Object)) {
                wrapper = null;
            }
            object = wrapper;
        } else {
            object = null;
        }
        return (T)object;
    }

    @Override
    @Nullable
    public IGenericEnergyStorage wrapTileEntity(@NotNull TileEntity te, @NotNull EnumFacing side) {
        Intrinsics.checkParameterIsNotNull((Object)te, (String)"te");
        Intrinsics.checkParameterIsNotNull((Object)side, (String)"side");
        return null;
    }

    @Override
    @Nullable
    public IGenericEnergyStorage wrapItemStack(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull((Object)stack, (String)"stack");
        return null;
    }

    private MekanismSystem() {
    }

    static {
        MekanismSystem mekanismSystem;
        INSTANCE = mekanismSystem = new MekanismSystem();
    }

    @Override
    public boolean isAvailable() {
        return IEnergySystem.DefaultImpls.isAvailable(this);
    }

    @Optional.Interface(iface="mekanism.api.energy.IStrictEnergyAcceptor", modid="mekanism")
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\r2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\f\u0010\u000f\u001a\u00020\u0010*\u00020\bH\u0002J\f\u0010\u0011\u001a\u00020\b*\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lnet/ndrei/teslacorelib/energy/systems/MekanismSystem$Wrapper;", "Lmekanism/api/energy/IStrictEnergyAcceptor;", "energy", "Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "(Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;)V", "getEnergy", "()Lnet/modcrafters/mclib/energy/IGenericEnergyStorage;", "acceptEnergy", "", "side", "Lnet/minecraft/util/EnumFacing;", "amount", "simulate", "", "canReceiveEnergy", "fromMekanismUnit", "", "toMekanismUnit", "tesla-core-lib"})
    public static final class Wrapper
    implements IStrictEnergyAcceptor {
        @NotNull
        private final IGenericEnergyStorage energy;

        public boolean canReceiveEnergy(@Nullable EnumFacing side) {
            return this.energy.getCanGive();
        }

        private final double toMekanismUnit(long $receiver) {
            return (double)$receiver * 2.5;
        }

        private final long fromMekanismUnit(double $receiver) {
            return (long)($receiver * 0.4);
        }

        public double acceptEnergy(@Nullable EnumFacing side, double amount, boolean simulate) {
            long l;
            long it = l = this.energy.givePower(amount == 1.0 ? 1L : this.fromMekanismUnit(amount), simulate);
            return it == 1L && amount == 1.0 ? 1.0 : this.toMekanismUnit(it);
        }

        @NotNull
        public final IGenericEnergyStorage getEnergy() {
            return this.energy;
        }

        public Wrapper(@NotNull IGenericEnergyStorage energy) {
            Intrinsics.checkParameterIsNotNull((Object)energy, (String)"energy");
            this.energy = energy;
        }
    }
}

