/*
 * Decompiled with CFR 0.152.
 */
package com.gibraltar.strait.entity.item;

import com.google.common.base.Predicate;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import org.apache.commons.lang3.Validate;

public class EntityFlatFrame
extends EntityItemFrame
implements IEntityAdditionalSpawnData {
    private static final Predicate<Entity> IS_HANGING_ENTITY = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityHanging;
        }
    };
    public EnumFacing realFacingDirection;
    private float itemDropChance = 1.0f;

    public EntityFlatFrame(World worldIn) {
        super(worldIn);
    }

    public EntityFlatFrame(World worldIn, BlockPos pos, EnumFacing facing) {
        super(worldIn, pos, facing);
        this.func_70105_a(0.5f, 0.03125f);
    }

    private double offs(int i) {
        return i % 32 == 0 ? 0.5 : 0.0;
    }

    protected void func_174859_a(EnumFacing facingDirectionIn) {
        Validate.notNull((Object)facingDirectionIn);
        this.realFacingDirection = facingDirectionIn;
        this.field_174860_b = EnumFacing.SOUTH;
        this.field_70177_z = this.realFacingDirection.func_176740_k() == EnumFacing.Axis.Y ? 0.0f : (float)(this.realFacingDirection.func_176736_b() * 90);
        this.field_70125_A = this.realFacingDirection == EnumFacing.UP ? -90.0f : 90.0f;
        this.field_70126_B = this.field_70177_z;
        this.func_174856_o();
    }

    public boolean func_70518_d() {
        if (this.realFacingDirection.func_176740_k() == EnumFacing.Axis.Y) {
            if (!this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
                return false;
            }
            BlockPos blockpos = this.field_174861_a.func_177972_a(this.realFacingDirection.func_176734_d());
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (!(iblockstate.isSideSolid((IBlockAccess)this.field_70170_p, blockpos, this.realFacingDirection) || iblockstate.func_185904_a().func_76220_a() || BlockRedstoneDiode.func_185546_B((IBlockState)iblockstate))) {
                return false;
            }
            return this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ(), IS_HANGING_ENTITY).isEmpty();
        }
        return super.func_70518_d();
    }

    protected void func_174856_o() {
        if (this.realFacingDirection == null) {
            return;
        }
        if (this.realFacingDirection.func_176740_k() == EnumFacing.Axis.Y) {
            double d0 = (double)this.field_174861_a.func_177958_n() + 0.5;
            double d1 = (double)this.field_174861_a.func_177956_o() + 0.5;
            double d2 = (double)this.field_174861_a.func_177952_p() + 0.5;
            double d6 = this.func_82330_g();
            double d7 = -((double)this.realFacingDirection.func_96559_d());
            double d8 = this.func_82330_g();
            this.field_70165_t = d0;
            this.field_70163_u = (d1 -= (double)this.realFacingDirection.func_96559_d() * 0.46875) - (d7 /= 32.0);
            this.field_70161_v = d2;
            this.field_70131_O = 0.0625f;
            this.func_174826_a(new AxisAlignedBB(d0 - d6, d1 - d7, d2 - (d8 /= 32.0), d0 + (d6 /= 32.0), d1 + d7, d2 + d8));
        } else {
            super.func_174856_o();
        }
    }

    public void func_146065_b(Entity entityIn, boolean p_146065_2_) {
        if (!p_146065_2_) {
            super.func_146065_b(entityIn, p_146065_2_);
            return;
        }
        if (this.func_130014_f_().func_82736_K().func_82766_b("doEntityDrops")) {
            ItemStack itemstack = this.func_82335_i();
            if (entityIn instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entityIn;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    this.removeFrameFromMap(itemstack);
                    return;
                }
            }
            this.func_70099_a(new ItemStack(Items.field_151160_bD, 1), 0.0f);
            if (!itemstack.func_190926_b() && this.field_70146_Z.nextFloat() < this.itemDropChance) {
                itemstack = itemstack.func_77946_l();
                this.removeFrameFromMap(itemstack);
                this.func_70099_a(itemstack, 0.0f);
            }
        }
    }

    private void removeFrameFromMap(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemMap) {
                MapData mapdata = ((ItemMap)stack.func_77973_b()).func_77873_a(stack, this.func_130014_f_());
                mapdata.field_76203_h.remove("frame-" + this.func_145782_y());
            }
            stack.func_82842_a((EntityItemFrame)null);
        }
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t + (double)((float)this.realFacingDirection.func_82601_c() * 0.15f), this.field_70163_u + (double)offsetY, this.field_70161_v + (double)((float)this.realFacingDirection.func_82599_e() * 0.15f), stack);
        entityitem.func_174869_p();
        if (this.realFacingDirection == EnumFacing.DOWN) {
            entityitem.field_70181_x = -entityitem.field_70181_x;
        }
        this.field_70170_p.func_72838_d((Entity)entityitem);
        return entityitem;
    }

    public void func_174826_a(AxisAlignedBB bb) {
        super.func_174826_a(bb);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("RealFacing", (byte)this.realFacingDirection.func_176745_a());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_174859_a(EnumFacing.func_82600_a((int)compound.func_74771_c("RealFacing")));
        NBTTagCompound nbttagcompound = compound.func_74775_l("Item");
        if (nbttagcompound != null && !nbttagcompound.func_82582_d() && compound.func_150297_b("ItemDropChance", 99)) {
            this.itemDropChance = compound.func_74760_g("ItemDropChance");
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeShort(this.realFacingDirection.func_176745_a());
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_174859_a(EnumFacing.func_82600_a((int)additionalData.readShort()));
    }
}

