/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen;

import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.TreasureManager;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IBlockFactory;
import greymerk.roguelike.worldgen.IPositionInfo;
import greymerk.roguelike.worldgen.IStair;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.PositionInfo;
import greymerk.roguelike.worldgen.VanillaStructure;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.ChunkProviderServer;

public class WorldEditor
implements IWorldEditor {
    World world;
    private Map<Block, Integer> stats;
    private TreasureManager chests;
    private static List<Material> invalid;

    public WorldEditor(World world) {
        invalid = new ArrayList<Material>();
        invalid.add(Material.field_151575_d);
        invalid.add(Material.field_151586_h);
        invalid.add(Material.field_151570_A);
        invalid.add(Material.field_151597_y);
        invalid.add(Material.field_151577_b);
        invalid.add(Material.field_151572_C);
        invalid.add(Material.field_151584_j);
        invalid.add(Material.field_151585_k);
        this.world = world;
        this.stats = new HashMap<Block, Integer>();
        this.chests = new TreasureManager();
    }

    private boolean setBlock(Coord pos, MetaBlock block, int flags, boolean fillAir, boolean replaceSolid) {
        boolean isAir;
        MetaBlock currentBlock = this.getBlock(pos);
        if (currentBlock.func_177230_c() == Blocks.field_150486_ae) {
            return false;
        }
        if (currentBlock.func_177230_c() == Blocks.field_150447_bR) {
            return false;
        }
        if (currentBlock.func_177230_c() == Blocks.field_150474_ac) {
            return false;
        }
        boolean bl = isAir = currentBlock.func_177230_c() == Blocks.field_150350_a;
        if (!fillAir && isAir) {
            return false;
        }
        if (!replaceSolid && !isAir) {
            return false;
        }
        try {
            this.world.func_180501_a(pos.getBlockPos(), block.getState(), flags);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Block type = block.func_177230_c();
        Integer count = this.stats.get(type);
        if (count == null) {
            this.stats.put(type, 1);
        } else {
            this.stats.put(type, count + 1);
        }
        return true;
    }

    @Override
    public boolean setBlock(Coord pos, MetaBlock block, boolean fillAir, boolean replaceSolid) {
        return this.setBlock(pos, block, block.getFlag(), fillAir, replaceSolid);
    }

    @Override
    public boolean isAirBlock(Coord pos) {
        return this.world.func_175623_d(pos.getBlockPos());
    }

    @Override
    public long getSeed() {
        return this.world.func_72905_C();
    }

    @Override
    public Random getSeededRandom(int a, int b, int c) {
        return this.world.func_72843_D(a, b, c);
    }

    @Override
    public void spiralStairStep(Random rand, Coord origin, IStair stair, IBlockFactory fill) {
        MetaBlock air = BlockType.get(BlockType.AIR);
        Coord start = new Coord(origin);
        start.add(new Coord(-1, 0, -1));
        Coord end = new Coord(origin);
        end.add(new Coord(1, 0, 1));
        RectSolid.fill(this, rand, start, end, air);
        fill.set(this, rand, origin);
        Cardinal dir = Cardinal.directions[origin.getY() % 4];
        Coord cursor = new Coord(origin);
        cursor.add(dir);
        stair.setOrientation(Cardinal.left(dir), false).set(this, cursor);
        cursor.add(Cardinal.right(dir));
        stair.setOrientation(Cardinal.right(dir), true).set(this, cursor);
        cursor.add(Cardinal.reverse(dir));
        stair.setOrientation(Cardinal.reverse(dir), true).set(this, cursor);
    }

    @Override
    public void fillDown(Random rand, Coord origin, IBlockFactory blocks) {
        Coord cursor = new Coord(origin);
        while (!this.getBlock(cursor).func_185914_p() && cursor.getY() > 1) {
            blocks.set(this, rand, cursor);
            cursor.add(Cardinal.DOWN);
        }
    }

    @Override
    public MetaBlock getBlock(Coord pos) {
        return new MetaBlock(this.world.func_180495_p(pos.getBlockPos()));
    }

    @Override
    public TileEntity getTileEntity(Coord pos) {
        return this.world.func_175625_s(pos.getBlockPos());
    }

    @Override
    public boolean validGroundBlock(Coord pos) {
        if (this.isAirBlock(pos)) {
            return false;
        }
        MetaBlock block = this.getBlock(pos);
        return !invalid.contains(block.func_185904_a());
    }

    @Override
    public int getStat(Block type) {
        if (!this.stats.containsKey(type)) {
            return 0;
        }
        return this.stats.get(type);
    }

    @Override
    public Map<Block, Integer> getStats() {
        return this.stats;
    }

    @Override
    public void addChest(ITreasureChest toAdd) {
        this.chests.add(toAdd);
    }

    @Override
    public TreasureManager getTreasure() {
        return this.chests;
    }

    @Override
    public boolean canPlace(MetaBlock block, Coord pos, Cardinal dir) {
        if (!this.isAirBlock(pos)) {
            return false;
        }
        return block.func_177230_c().func_176198_a(this.world, pos.getBlockPos(), Cardinal.facing(dir));
    }

    @Override
    public IPositionInfo getInfo(Coord pos) {
        return new PositionInfo(this.world, pos);
    }

    @Override
    public Coord findNearestStructure(VanillaStructure type, Coord pos) {
        ChunkProviderServer chunkProvider = ((WorldServer)this.world).func_72863_F();
        String structureName = VanillaStructure.getName(type);
        BlockPos structurebp = null;
        try {
            structurebp = chunkProvider.func_180513_a(this.world, structureName, pos.getBlockPos(), false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (structurebp == null) {
            return null;
        }
        return new Coord(structurebp);
    }

    public String toString() {
        String toReturn = "";
        for (Map.Entry<Block, Integer> pair : this.stats.entrySet()) {
            toReturn = toReturn + pair.getKey().func_149732_F() + ": " + pair.getValue() + "\n";
        }
        return toReturn;
    }
}

