/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.treasure.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import greymerk.roguelike.treasure.ITreasureChest;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.treasure.TreasureManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.ResourceLocation;

public class LootTableRule {
    private ResourceLocation table;
    private List<Treasure> type;
    List<Integer> level;

    public LootTableRule(JsonObject json) throws Exception {
        if (!json.has("table")) {
            throw new Exception("Loot table requires a table field");
        }
        this.table = new ResourceLocation(json.get("table").getAsString());
        if (json.has("type")) {
            this.type = new ArrayList<Treasure>();
            JsonElement typeElement = json.get("type");
            if (typeElement.isJsonArray()) {
                JsonArray arr = typeElement.getAsJsonArray();
                for (JsonElement e : arr) {
                    this.type.add(Treasure.valueOf(e.getAsString()));
                }
            } else {
                this.type.add(Treasure.valueOf(typeElement.getAsString()));
            }
        }
        if (json.has("level")) {
            this.level = this.parseLevels(json.get("level"));
        }
    }

    public void process(TreasureManager treasure) {
        List<ITreasureChest> chests = this.getMatching(treasure);
        for (ITreasureChest chest : chests) {
            if (chest.getType() == Treasure.EMPTY) continue;
            chest.setLootTable(this.table);
        }
    }

    private List<ITreasureChest> getMatching(TreasureManager treasure) {
        if (this.type == null && this.level == null) {
            return treasure.getChests();
        }
        ArrayList<ITreasureChest> chests = new ArrayList<ITreasureChest>();
        if (this.type == null) {
            Iterator<Object> iterator = this.level.iterator();
            while (iterator.hasNext()) {
                int level = (Integer)iterator.next();
                chests.addAll(treasure.getChests(level));
            }
        }
        if (this.level == null) {
            for (Treasure type : this.type) {
                chests.addAll(treasure.getChests(type));
            }
        }
        return chests;
    }

    private List<Integer> parseLevels(JsonElement e) {
        ArrayList<Integer> levels = new ArrayList<Integer>();
        if (e.isJsonArray()) {
            JsonArray arr = e.getAsJsonArray();
            for (JsonElement i : arr) {
                levels.add(i.getAsInt());
            }
            return levels;
        }
        levels.add(e.getAsInt());
        return levels;
    }
}

