/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin;

import greymerk.roguelike.dungeon.base.DungeonFactory;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.SecretFactory;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.base.SettingsBase;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.filter.Filter;
import java.util.ArrayList;
import net.minecraftforge.common.BiomeDictionary;

public class SettingsGrasslandTheme
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "grassland");

    public SettingsGrasslandTheme() {
        this.id = ID;
        this.inherit.add(SettingsBase.ID);
        this.criteria = new SpawnCriteria();
        ArrayList<BiomeDictionary.Type> biomes = new ArrayList<BiomeDictionary.Type>();
        biomes.add(BiomeDictionary.Type.PLAINS);
        this.criteria.setBiomeTypes(biomes);
        this.towerSettings = new TowerSettings(Tower.HOUSE, Theme.getTheme(Theme.HOUSE));
        for (int i = 0; i < 5; ++i) {
            LevelSettings level = new LevelSettings();
            SecretFactory secrets = new SecretFactory();
            DungeonFactory rooms = new DungeonFactory();
            switch (i) {
                case 0: {
                    secrets.addRoom(DungeonRoom.FIREWORK);
                    secrets.addRoom(DungeonRoom.SMITH);
                    level.setSecrets(secrets);
                    break;
                }
                case 1: {
                    rooms.addSingle(DungeonRoom.PIT);
                    rooms.addSingle(DungeonRoom.MESS);
                    rooms.addRandom(DungeonRoom.CORNER, 10);
                    rooms.addRandom(DungeonRoom.BRICK, 3);
                    level.setSecrets(secrets);
                    level.setRooms(rooms);
                    break;
                }
                case 2: {
                    rooms.addSingle(DungeonRoom.LAB);
                    level.setRooms(rooms);
                    break;
                }
                case 3: {
                    rooms.addSingle(DungeonRoom.MUSIC);
                    level.setRooms(rooms);
                    break;
                }
                case 4: {
                    rooms.addSingle(DungeonRoom.BTEAM);
                    rooms.addSingle(DungeonRoom.ENDER);
                    level.setRooms(rooms);
                    break;
                }
            }
            this.levels.put(i, level);
        }
        ((LevelSettings)this.levels.get(3)).addFilter(Filter.VINE);
    }
}

