/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.settings.builtin;

import greymerk.roguelike.dungeon.base.DungeonFactory;
import greymerk.roguelike.dungeon.base.DungeonRoom;
import greymerk.roguelike.dungeon.base.SecretFactory;
import greymerk.roguelike.dungeon.segment.Segment;
import greymerk.roguelike.dungeon.segment.SegmentGenerator;
import greymerk.roguelike.dungeon.settings.DungeonSettings;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.dungeon.settings.SettingIdentifier;
import greymerk.roguelike.dungeon.settings.SpawnCriteria;
import greymerk.roguelike.dungeon.settings.TowerSettings;
import greymerk.roguelike.dungeon.settings.base.SettingsBase;
import greymerk.roguelike.dungeon.towers.Tower;
import greymerk.roguelike.theme.Theme;
import greymerk.roguelike.worldgen.filter.Filter;
import java.util.ArrayList;
import net.minecraftforge.common.BiomeDictionary;

public class SettingsForestTheme
extends DungeonSettings {
    public static final SettingIdentifier ID = new SettingIdentifier("builtin", "forest");

    public SettingsForestTheme() {
        this.id = ID;
        this.inherit.add(SettingsBase.ID);
        this.criteria = new SpawnCriteria();
        ArrayList<BiomeDictionary.Type> biomes = new ArrayList<BiomeDictionary.Type>();
        biomes.add(BiomeDictionary.Type.FOREST);
        this.criteria.setBiomeTypes(biomes);
        this.towerSettings = new TowerSettings(Tower.ROGUE, Theme.getTheme(Theme.TOWER));
        for (int i = 0; i < 5; ++i) {
            LevelSettings level = new LevelSettings();
            switch (i) {
                case 0: {
                    DungeonFactory rooms = new DungeonFactory();
                    rooms.addRandom(DungeonRoom.CORNER, 8);
                    rooms.addRandom(DungeonRoom.BRICK, 3);
                    rooms.addSingle(DungeonRoom.CAKE);
                    rooms.addSingle(DungeonRoom.DARKHALL);
                    rooms.addSingle(DungeonRoom.LIBRARY);
                    level.setRooms(rooms);
                    SecretFactory secrets = new SecretFactory();
                    secrets.addRoom(DungeonRoom.SMITH);
                    secrets.addRoom(DungeonRoom.BEDROOM, 2);
                    level.setSecrets(secrets);
                    level.setTheme(Theme.getTheme(Theme.SPRUCE));
                    SegmentGenerator segments = new SegmentGenerator(Segment.ARCH);
                    segments.add(Segment.DOOR, 8);
                    segments.add(Segment.LAMP, 2);
                    segments.add(Segment.WHEAT, 3);
                    segments.add(Segment.FLOWERS, 2);
                    segments.add(Segment.INSET, 1);
                    segments.add(Segment.PLANT, 2);
                    segments.add(Segment.SHELF, 1);
                    segments.add(Segment.CHEST, 1);
                    level.setSegments(segments);
                    break;
                }
                case 1: {
                    DungeonFactory rooms = new DungeonFactory();
                    rooms.addSingle(DungeonRoom.MUSIC);
                    rooms.addSingle(DungeonRoom.PIT);
                    rooms.addSingle(DungeonRoom.LAB);
                    rooms.addSingle(DungeonRoom.SLIME, 2);
                    rooms.addRandom(DungeonRoom.CORNER, 10);
                    rooms.addRandom(DungeonRoom.BRICK, 3);
                    level.setRooms(rooms);
                    level.setTheme(Theme.getTheme(Theme.DARKHALL));
                    SegmentGenerator segments = new SegmentGenerator(Segment.ARCH);
                    segments.add(Segment.DOOR, 10);
                    segments.add(Segment.FLOWERS, 2);
                    segments.add(Segment.INSET, 2);
                    segments.add(Segment.PLANT, 2);
                    segments.add(Segment.SHELF, 2);
                    segments.add(Segment.CHEST, 1);
                    level.setSegments(segments);
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            this.levels.put(i, level);
        }
        ((LevelSettings)this.levels.get(3)).addFilter(Filter.VINE);
    }
}

