/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon;

import greymerk.roguelike.dungeon.DungeonNode;
import greymerk.roguelike.dungeon.DungeonTunnel;
import greymerk.roguelike.dungeon.ILevelLayout;
import greymerk.roguelike.dungeon.base.IDungeonRoom;
import greymerk.roguelike.worldgen.IBounded;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class LevelLayout
implements ILevelLayout {
    private List<DungeonNode> nodes = new ArrayList<DungeonNode>();
    private List<DungeonTunnel> tunnels = new ArrayList<DungeonTunnel>();
    private DungeonNode start;
    private DungeonNode end;

    public void setStart(DungeonNode start) {
        this.start = start;
        this.addNode(start);
    }

    public void setEnd(DungeonNode end) {
        this.end = end;
        this.addNode(end);
    }

    @Override
    public DungeonNode getStart() {
        return this.start;
    }

    @Override
    public DungeonNode getEnd() {
        return this.end;
    }

    public void addNode(DungeonNode node) {
        this.nodes.add(node);
    }

    public void addTunnel(DungeonTunnel tunnel) {
        this.tunnels.add(tunnel);
    }

    public void addTunnels(List<DungeonTunnel> tunnels) {
        this.tunnels.addAll(tunnels);
    }

    @Override
    public List<DungeonNode> getNodes() {
        return this.nodes;
    }

    @Override
    public List<DungeonTunnel> getTunnels() {
        return this.tunnels;
    }

    public void setStartEnd(Random rand, DungeonNode start) {
        this.start = start;
        int attempts = 0;
        do {
            this.end = this.nodes.get(rand.nextInt(this.nodes.size()));
        } while (this.end == this.start || this.end.getPosition().distance(start.getPosition()) > (double)(16 + ++attempts * 2));
    }

    public boolean overlaps(DungeonNode node, int size) {
        for (DungeonTunnel tunnel : this.getTunnels()) {
            if (node.connectsTo(tunnel) || !node.getBoundingBox(size).collide(tunnel)) continue;
            return true;
        }
        for (DungeonNode n : this.getNodes()) {
            if (node == n || !node.getBoundingBox(size).collide(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DungeonNode getBestFit(IDungeonRoom room) {
        for (DungeonNode node : this.getNodes()) {
            if (node == this.start || node == this.end || node.getRoom() != null || this.overlaps(node, room.getSize())) continue;
            return node;
        }
        for (DungeonNode node : this.getNodes()) {
            if (node == this.start || node == this.end || node.getRoom() != null) continue;
            return node;
        }
        return null;
    }

    @Override
    public boolean hasEmptyRooms() {
        for (DungeonNode node : this.nodes) {
            if (node == this.start || node == this.end || node.getRoom() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IBounded> getBoundingBoxes() {
        ArrayList<IBounded> boxes = new ArrayList<IBounded>();
        boxes.addAll(this.nodes);
        boxes.addAll(this.tunnels);
        return boxes;
    }
}

