/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.shapes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftools.shapes.RenderData;
import mcjty.rftools.shapes.ShapeID;

public class ShapeDataManagerClient {
    static final Map<ShapeID, RenderData> renderDataMap = new HashMap<ShapeID, RenderData>();
    private static int cleanupCounter = 20;

    @Nullable
    public static RenderData getRenderData(ShapeID shapeID) {
        return renderDataMap.get(shapeID);
    }

    @Nonnull
    public static RenderData getRenderDataAndCreate(ShapeID shapeID) {
        RenderData data = renderDataMap.get(shapeID);
        if (data == null) {
            data = new RenderData();
            renderDataMap.put(shapeID, data);
        }
        return data;
    }

    public static void cleanupOldRenderers() {
        if (--cleanupCounter >= 0) {
            return;
        }
        cleanupCounter = 20;
        HashSet<ShapeID> toRemove = new HashSet<ShapeID>();
        for (Map.Entry<ShapeID, RenderData> entry : renderDataMap.entrySet()) {
            if (!entry.getValue().tooOld()) continue;
            toRemove.add(entry.getKey());
        }
        for (ShapeID id : toRemove) {
            RenderData data = renderDataMap.get(id);
            data.cleanup();
            renderDataMap.remove(id);
        }
    }
}

