/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.bindings.DefaultAction;
import mcjty.lib.bindings.IAction;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.NullSidedInvWrapper;
import mcjty.rftools.RFTools;
import mcjty.rftools.api.general.IInventoryTracker;
import mcjty.rftools.blocks.storage.ModularStorageContainer;
import mcjty.rftools.blocks.storage.ModularStorageSetup;
import mcjty.rftools.blocks.storage.RemoteStorageIdRegistry;
import mcjty.rftools.blocks.storage.RemoteStorageTileEntity;
import mcjty.rftools.compat.jei.JEIRecipeAcceptor;
import mcjty.rftools.craftinggrid.CraftingGrid;
import mcjty.rftools.craftinggrid.CraftingGridInventory;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.InventoriesItemSource;
import mcjty.rftools.craftinggrid.StorageCraftingTools;
import mcjty.rftools.items.storage.StorageFilterCache;
import mcjty.rftools.items.storage.StorageModuleItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.CapabilityItemHandler;

public class ModularStorageTileEntity
extends GenericTileEntity
implements ITickable,
DefaultSidedInventory,
IInventoryTracker,
CraftingGridProvider,
JEIRecipeAcceptor {
    public static final String CMD_SETTINGS = "storage.settings";
    public static final Key<String> PARAM_FILTER = new Key("filter", Type.STRING);
    public static final Key<String> PARAM_VIEWMODE = new Key("viewmode", Type.STRING);
    public static final Key<String> PARAM_SORTMODE = new Key("sortmode", Type.STRING);
    public static final Key<Boolean> PARAM_GROUPMODE = new Key("groupmode", Type.BOOLEAN);
    public static final String ACTION_COMPACT = "compact";
    public static final String ACTION_CYCLE = "cycle";
    public static final String ACTION_CLEARGRID = "clearGrid";
    private int[] accessible = null;
    private int maxSize = 0;
    private int version = 0;
    private StorageFilterCache filterCache = null;
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ModularStorageContainer.factory, 301);
    private CraftingGrid craftingGrid = new CraftingGrid();
    private String sortMode = "";
    private String viewMode = "";
    private boolean groupMode = false;
    private String filter = "";
    private int numStacks = -1;
    private int remoteId = 0;
    private int prevLevel = -3;
    private int timer = 10;
    private RemoteStorageTileEntity cachedRemoteStorage;
    private int cachedRemoteStorageId;

    public IAction[] getActions() {
        return new IAction[]{new DefaultAction(ACTION_COMPACT, this::compact), new DefaultAction(ACTION_CYCLE, this::cycle), new DefaultAction(ACTION_CLEARGRID, this::clearGrid)};
    }

    protected boolean needsCustomInvWrapper() {
        return false;
    }

    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            this.checkStateServer();
        }
    }

    private void checkStateServer() {
        --this.timer;
        if (this.timer > 0) {
            return;
        }
        this.timer = 10;
        this.cachedRemoteStorage = null;
        this.cachedRemoteStorageId = -1;
        if (this.isRemote()) {
            int level;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            int si = -1;
            if (storageTileEntity != null) {
                si = storageTileEntity.findRemoteIndex(this.remoteId);
            }
            if (si == -1) {
                if (this.prevLevel != -2) {
                    this.prevLevel = -2;
                    this.clearInventory();
                }
                return;
            }
            this.numStacks = storageTileEntity.getCount(si);
            int newMaxSize = storageTileEntity.getMaxStacks(si);
            if (newMaxSize != this.maxSize) {
                this.setMaxSize(newMaxSize);
            }
            if ((level = this.getRenderLevel()) != this.prevLevel) {
                this.prevLevel = level;
                this.markDirtyClient();
            }
        }
    }

    private void clearInventory() {
        this.setMaxSize(0);
        this.numStacks = -1;
        for (int i = 1; i < 300; ++i) {
            this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), i, ItemStack.field_190927_a);
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    @Override
    public void setRecipe(int index, ItemStack[] stacks) {
        this.craftingGrid.setRecipe(index, stacks);
        this.func_70296_d();
    }

    @Override
    public void storeRecipe(int index) {
        this.getCraftingGrid().storeRecipe(index);
    }

    @Override
    public void setGridContents(List<ItemStack> stacks) {
        for (int i = 0; i < stacks.size(); ++i) {
            this.craftingGrid.getCraftingGridInventory().func_70299_a(i, stacks.get(i));
        }
        this.func_70296_d();
    }

    @Override
    public CraftingGrid getCraftingGrid() {
        return this.craftingGrid;
    }

    @Override
    public void markInventoryDirty() {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public int[] craft(EntityPlayer player, int n, boolean test) {
        InventoriesItemSource itemSource = new InventoriesItemSource().add((IInventory)player.field_71071_by, 0).add((IInventory)this, 1);
        if (test) {
            return StorageCraftingTools.testCraftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        }
        StorageCraftingTools.craftItems(player, n, this.craftingGrid.getActiveRecipe(), itemSource);
        this.updateStackCount();
        return new int[0];
    }

    public int[] func_180463_a(EnumFacing side) {
        if (this.accessible == null) {
            this.accessible = new int[this.maxSize];
            for (int i = 0; i < this.maxSize; ++i) {
                this.accessible[i] = 1 + i;
            }
        }
        return this.accessible;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return index >= 1 && this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= 1 && this.func_94041_b(index, stack);
    }

    public boolean isGroupMode() {
        return this.groupMode;
    }

    public void setGroupMode(boolean groupMode) {
        this.groupMode = groupMode;
        this.func_70296_d();
    }

    public String getSortMode() {
        return this.sortMode;
    }

    public void setSortMode(String sortMode) {
        this.sortMode = sortMode;
        this.func_70296_d();
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.func_70296_d();
    }

    public String getViewMode() {
        return this.viewMode;
    }

    public void setViewMode(String viewMode) {
        this.viewMode = viewMode;
        this.func_70296_d();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int func_70302_i_() {
        return 1 + this.maxSize;
    }

    private boolean containsItem(int index) {
        if (this.isStorageAvailableRemotely(index)) {
            --index;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return false;
            }
            ItemStackList slots = storageTileEntity.findStacksForId(this.remoteId);
            if (index >= slots.size()) {
                return false;
            }
            return !((ItemStack)slots.get(index)).func_190926_b();
        }
        return this.inventoryHelper.containsItem(index);
    }

    private boolean isStorageAvailableRemotely(int index) {
        return this.isServer() && this.isRemote() && index >= 1;
    }

    private boolean isRemote() {
        return this.remoteId != 0;
    }

    public int getRemoteId() {
        return this.remoteId;
    }

    public ItemStack func_70301_a(int index) {
        if (index >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        if (this.isStorageAvailableRemotely(index)) {
            --index;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return ItemStack.field_190927_a;
            }
            ItemStackList slots = storageTileEntity.findStacksForId(this.remoteId);
            if (index >= slots.size()) {
                return ItemStack.field_190927_a;
            }
            return (ItemStack)slots.get(index);
        }
        return this.inventoryHelper.getStackInSlot(index);
    }

    private void handleNewAmount(boolean containsBefore, int index) {
        if (index < 1) {
            return;
        }
        boolean containsAfter = this.containsItem(index);
        if (containsBefore == containsAfter) {
            return;
        }
        int rlold = this.getRenderLevel();
        this.numStacks = containsBefore ? --this.numStacks : ++this.numStacks;
        StorageModuleItem.updateStackSize(this.func_70301_a(0), this.numStacks);
        int rlnew = this.getRenderLevel();
        if (rlold != rlnew) {
            this.markDirtyClient();
        }
    }

    public int getRenderLevel() {
        if (this.numStacks == -1 || this.maxSize == 0) {
            return -1;
        }
        return (this.numStacks + 6) * 7 / this.maxSize;
    }

    public int getNumStacks() {
        return this.numStacks;
    }

    public ItemStack func_70304_b(int index) {
        ++this.version;
        if (this.isStorageAvailableRemotely(index)) {
            --index;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return ItemStack.field_190927_a;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return ItemStack.field_190927_a;
            }
            storageTileEntity.updateVersion();
            return storageTileEntity.removeStackFromSlotRemote(si, index);
        }
        boolean containsBefore = this.containsItem(index);
        ItemStack stack = this.inventoryHelper.removeStackFromSlot(index);
        this.handleNewAmount(containsBefore, index);
        return stack;
    }

    private ItemStack decrStackSizeHelper(int index, int amount) {
        if (this.isStorageAvailableRemotely(index)) {
            --index;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return ItemStack.field_190927_a;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return ItemStack.field_190927_a;
            }
            storageTileEntity.updateVersion();
            return storageTileEntity.decrStackSizeRemote(si, index, amount);
        }
        return this.inventoryHelper.decrStackSize(index, amount);
    }

    public ItemStack func_70298_a(int index, int amount) {
        ++this.version;
        if (index == 0 && !this.func_145831_w().field_72995_K) {
            this.copyToModule();
        }
        boolean containsBefore = this.containsItem(index);
        ItemStack itemStack = this.decrStackSizeHelper(index, amount);
        this.handleNewAmount(containsBefore, index);
        if (index == 0) {
            ItemStack stackInSlot = this.inventoryHelper.getStackInSlot(0);
            this.copyFromModule(stackInSlot);
        }
        return itemStack;
    }

    private void setInventorySlotContentsHelper(int limit, int index, ItemStack stack) {
        if (this.isStorageAvailableRemotely(index)) {
            --index;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return;
            }
            storageTileEntity.updateVersion();
            storageTileEntity.updateRemoteSlot(si, limit, index, stack);
        } else {
            this.inventoryHelper.setInventorySlotContents(this.func_70297_j_(), index, stack);
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        ++this.version;
        if (index == 0 && this.isServer()) {
            this.copyToModule();
        }
        boolean containsBefore = this.containsItem(index);
        this.setInventorySlotContentsHelper(this.func_70297_j_(), index, stack);
        if (index == 0 && this.isServer()) {
            this.copyFromModule(stack);
        }
        this.handleNewAmount(containsBefore, index);
    }

    public boolean func_191420_l() {
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index >= this.func_70302_i_()) {
            return false;
        }
        switch (index) {
            case 0: {
                return !stack.func_190926_b() && ModularStorageSetup.storageModuleItem == stack.func_77973_b();
            }
        }
        if (index < 1) {
            return true;
        }
        if (this.isStorageAvailableRemotely(index)) {
            --index;
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return false;
            }
            ItemStackList stacks = storageTileEntity.findStacksForId(this.remoteId);
            if (index >= stacks.size()) {
                return false;
            }
        }
        return true;
    }

    public void copyToModule() {
        ItemStack stack = this.inventoryHelper.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return;
        }
        if (stack.func_77952_i() == 6) {
            this.remoteId = 0;
            return;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        int cnt = this.writeBufferToItemNBT(tagCompound);
        tagCompound.func_74768_a("count", cnt);
    }

    public void copyFromModule(ItemStack stack) {
        for (int i = 1; i < this.inventoryHelper.getCount(); ++i) {
            this.inventoryHelper.setInventorySlotContents(0, i, ItemStack.field_190927_a);
        }
        if (stack.func_190926_b()) {
            this.clearInventory();
            return;
        }
        this.remoteId = 0;
        if (stack.func_77952_i() == 6) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null || !tagCompound.func_74764_b("id")) {
                this.clearInventory();
                return;
            }
            this.remoteId = tagCompound.func_74762_e("id");
            RemoteStorageTileEntity remoteStorageTileEntity = this.getRemoteStorage(this.remoteId);
            if (remoteStorageTileEntity == null) {
                this.clearInventory();
                return;
            }
            ItemStack storageStack = remoteStorageTileEntity.findStorageWithId(this.remoteId);
            if (storageStack.func_190926_b()) {
                this.clearInventory();
                return;
            }
            this.setMaxSize(StorageModuleItem.MAXSIZE[storageStack.func_77952_i()]);
        } else {
            this.setMaxSize(StorageModuleItem.MAXSIZE[stack.func_77952_i()]);
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null) {
                this.readBufferFromItemNBT(tagCompound);
            }
        }
        this.updateStackCount();
    }

    private RemoteStorageTileEntity getRemoteStorage(int id) {
        if (id != this.cachedRemoteStorageId) {
            this.cachedRemoteStorage = null;
        }
        if (this.cachedRemoteStorage != null) {
            return this.cachedRemoteStorage;
        }
        World world = this.getWorldSafe();
        this.cachedRemoteStorage = RemoteStorageIdRegistry.getRemoteStorage(world, id);
        this.cachedRemoteStorageId = this.cachedRemoteStorage != null ? id : -1;
        return this.cachedRemoteStorage;
    }

    private void updateStackCount() {
        this.numStacks = 0;
        if (this.isServer() && this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            int si = storageTileEntity.findRemoteIndex(this.remoteId);
            if (si == -1) {
                return;
            }
            ItemStackList stacks = storageTileEntity.getRemoteStacks(si);
            for (int i = 0; i < Math.min(this.maxSize, stacks.size()); ++i) {
                if (((ItemStack)stacks.get(i)).func_190926_b()) continue;
                ++this.numStacks;
            }
            storageTileEntity.updateCount(si, this.numStacks);
        } else {
            for (int i = 1; i < 1 + this.maxSize; ++i) {
                if (!this.inventoryHelper.containsItem(i)) continue;
                ++this.numStacks;
            }
        }
        StorageModuleItem.updateStackSize(this.func_70301_a(0), this.numStacks);
    }

    private boolean isServer() {
        if (this.func_145831_w() != null) {
            return !this.func_145831_w().field_72995_K;
        }
        return FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER;
    }

    private World getWorldSafe() {
        Object world = this.func_145831_w();
        if (world == null) {
            world = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? RFTools.proxy.getClientWorld() : DimensionManager.getWorld((int)0);
        }
        return world;
    }

    private void setMaxSize(int ms) {
        this.maxSize = ms;
        this.inventoryHelper.setNewCount(1 + this.maxSize);
        this.accessible = null;
        this.markDirtyClient();
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        this.numStacks = tagCompound.func_74762_e("numStacks");
        this.maxSize = tagCompound.func_74762_e("maxSize");
        this.remoteId = tagCompound.func_74762_e("remoteId");
        this.inventoryHelper.setNewCount(1 + this.maxSize);
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("numStacks", this.numStacks);
        tagCompound.func_74768_a("maxSize", this.maxSize);
        tagCompound.func_74768_a("remoteId", this.remoteId);
    }

    public void syncInventoryFromServer(int maxSize, int numStacks, String sortMode, String viewMode, boolean groupMode, String filter) {
        this.sortMode = sortMode;
        this.viewMode = viewMode;
        this.groupMode = groupMode;
        this.filter = filter;
        this.numStacks = numStacks;
        this.maxSize = maxSize;
        int newcount = 1 + maxSize;
        if (newcount != this.inventoryHelper.getCount()) {
            this.inventoryHelper.setNewCount(newcount);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.numStacks = tagCompound.func_74762_e("numStacks");
        this.maxSize = tagCompound.func_74762_e("maxSize");
        this.remoteId = tagCompound.func_74762_e("remoteId");
        this.sortMode = tagCompound.func_74779_i("sortMode");
        this.viewMode = tagCompound.func_74779_i("viewMode");
        this.groupMode = tagCompound.func_74767_n("groupMode");
        this.version = tagCompound.func_74762_e("version");
        this.filter = tagCompound.func_74779_i("filter");
        this.inventoryHelper.setNewCount(1 + this.maxSize);
        this.accessible = null;
        this.readBufferFromNBT(tagCompound);
        this.craftingGrid.readFromNBT(tagCompound.func_74775_l("grid"));
        if (this.isServer()) {
            this.updateStackCount();
        }
    }

    private void readBufferFromItemNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            this.inventoryHelper.setStackInSlot(i + 1, new ItemStack(nbtTagCompound));
        }
    }

    private void readBufferFromNBT(NBTTagCompound tagCompound) {
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        if (tagCompound.func_74764_b("SlotStorage")) {
            for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
                this.inventoryHelper.setStackInSlot(i + 1, new ItemStack(nbtTagCompound));
            }
            this.inventoryHelper.setStackInSlot(0, new ItemStack(tagCompound.func_74775_l("SlotStorage")));
        } else {
            int index = 0;
            for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
                NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
                this.inventoryHelper.setStackInSlot(index, new ItemStack(nbtTagCompound));
                ++index;
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound);
        this.writeSlot(tagCompound, 0, "SlotStorage");
        tagCompound.func_74768_a("numStacks", this.numStacks);
        tagCompound.func_74768_a("maxSize", this.maxSize);
        tagCompound.func_74768_a("remoteId", this.remoteId);
        tagCompound.func_74778_a("sortMode", this.sortMode);
        tagCompound.func_74778_a("viewMode", this.viewMode);
        tagCompound.func_74757_a("groupMode", this.groupMode);
        tagCompound.func_74778_a("filter", this.filter);
        tagCompound.func_74768_a("version", this.version);
        tagCompound.func_74782_a("grid", (NBTBase)this.craftingGrid.writeToNBT());
    }

    private void writeSlot(NBTTagCompound tagCompound, int index, String name) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        ItemStack stack = this.inventoryHelper.getStackInSlot(index);
        if (!stack.func_190926_b()) {
            stack.func_77955_b(nbtTagCompound);
        }
        tagCompound.func_74782_a(name, (NBTBase)nbtTagCompound);
    }

    private void writeBufferToNBT(NBTTagCompound tagCompound) {
        boolean sendToClient = this.isServer() && this.isRemote();
        NBTTagList bufferTagList = new NBTTagList();
        if (sendToClient) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity != null) {
                ItemStackList slots = storageTileEntity.findStacksForId(this.remoteId);
                for (ItemStack stack : slots) {
                    NBTTagCompound nbtTagCompound = new NBTTagCompound();
                    if (!stack.func_190926_b()) {
                        stack.func_77955_b(nbtTagCompound);
                    }
                    bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
                }
            }
        } else {
            for (int i = 1; i < this.inventoryHelper.getCount(); ++i) {
                ItemStack stack = this.inventoryHelper.getStackInSlot(i);
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                if (!stack.func_190926_b()) {
                    stack.func_77955_b(nbtTagCompound);
                }
                bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
            }
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
    }

    private int writeBufferToItemNBT(NBTTagCompound tagCompound) {
        int cnt = 0;
        NBTTagList bufferTagList = new NBTTagList();
        for (int i = 1; i < this.inventoryHelper.getCount(); ++i) {
            ItemStack stack = this.inventoryHelper.getStackInSlot(i);
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (!stack.func_190926_b()) {
                stack.func_77955_b(nbtTagCompound);
                if (stack.func_190916_E() > 0) {
                    ++cnt;
                }
            }
            bufferTagList.func_74742_a((NBTBase)nbtTagCompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)bufferTagList);
        return cnt;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, TypedMap params) {
        boolean rc = super.execute(playerMP, command, params);
        if (rc) {
            return true;
        }
        if (CMD_SETTINGS.equals(command)) {
            this.setFilter((String)params.get(PARAM_FILTER));
            this.setViewMode((String)params.get(PARAM_VIEWMODE));
            this.setSortMode("name");
            this.setGroupMode((Boolean)params.get(PARAM_GROUPMODE));
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    private void clearGrid() {
        CraftingGridInventory inventory = this.craftingGrid.getCraftingGridInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    private void cycle() {
        if (this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            this.remoteId = storageTileEntity.cycle(this.remoteId);
            this.func_70301_a(0).func_77978_p().func_74768_a("id", this.remoteId);
            this.markDirtyClient();
        }
    }

    public void compact() {
        if (this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return;
            }
            storageTileEntity.compact(this.remoteId);
        } else {
            InventoryHelper.compactStacks((InventoryHelper)this.inventoryHelper, (int)1, (int)this.maxSize);
        }
        this.updateStackCount();
        this.markDirtyClient();
    }

    @Override
    public int getVersion() {
        if (this.isRemote()) {
            RemoteStorageTileEntity storageTileEntity = this.getRemoteStorage(this.remoteId);
            if (storageTileEntity == null) {
                return this.version;
            }
            return storageTileEntity.getVersion();
        }
        return this.version;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.invHandlerNull == null) {
                this.invHandlerNull = new NullSidedInvWrapper((ISidedInventory)this);
            }
            return (T)this.invHandlerNull;
        }
        return (T)super.getCapability(capability, facing);
    }
}

