/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.storage;

import appeng.integration.Integrations;
import java.awt.Rectangle;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalAlignment;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.AbstractWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.storage.ModularStorageConfiguration;
import mcjty.rftools.blocks.storage.ModularStorageContainer;
import mcjty.rftools.blocks.storage.ModularStorageItemContainer;
import mcjty.rftools.blocks.storage.ModularStorageItemInventory;
import mcjty.rftools.blocks.storage.ModularStorageTileEntity;
import mcjty.rftools.blocks.storage.RemoteStorageItemContainer;
import mcjty.rftools.blocks.storage.RemoteStorageItemInventory;
import mcjty.rftools.blocks.storage.sorters.NameItemSorter;
import mcjty.rftools.craftinggrid.CraftingGridProvider;
import mcjty.rftools.craftinggrid.GuiCraftingGrid;
import mcjty.rftools.network.RFToolsMessages;
import mcjty.rftools.setup.CommandHandler;
import mcjty.rftools.setup.GuiProxy;
import mezz.jei.gui.overlay.IngredientListOverlay;
import net.minecraft.block.Block;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiModularStorage
extends GenericGuiContainer<ModularStorageTileEntity> {
    public static final int STORAGE_WIDTH = 256;
    private static final ResourceLocation iconLocationTop = new ResourceLocation("rftools", "textures/gui/modularstoragetop.png");
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/modularstorage.png");
    private final GuiCraftingGrid craftingGrid = new GuiCraftingGrid();
    private WidgetList itemList;
    private Button compactButton;
    private Label topLabel;
    private Label middleLabel;
    private Label bottomLabel;
    private boolean guiInited = false;

    public GuiModularStorage(ModularStorageTileEntity modularStorageTileEntity, ModularStorageContainer container) {
        this(modularStorageTileEntity, (Container)container);
    }

    public GuiModularStorage(RemoteStorageItemContainer container) {
        this(null, (Container)container);
    }

    public GuiModularStorage(ModularStorageItemContainer container) {
        this(null, (Container)container);
    }

    public GuiModularStorage(ModularStorageTileEntity modularStorageTileEntity, Container container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)modularStorageTileEntity, container, GuiProxy.GUI_MANUAL_MAIN, "storage");
        this.field_146999_f = 256;
        this.field_147000_g = ModularStorageConfiguration.height2.get();
        IInventory gridInventory = ((GenericContainer)container).getInventory("grid");
        for (Object o : container.field_75151_b) {
            Slot slot = (Slot)o;
            if (slot.field_75224_c == gridInventory) continue;
            slot.field_75221_f = slot.field_75221_f + this.field_147000_g - ModularStorageConfiguration.height1.get();
        }
    }

    public void func_73866_w_() {
        CraftingGridProvider provider;
        super.func_73866_w_();
        if (!this.guiInited) {
            Integrations.jei().setSearchText("");
            this.guiInited = true;
        }
        IngredientListOverlay.searchField.func_146195_b(true);
        this.itemList = ((WidgetList)((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("items")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 3, 235, this.field_147000_g - 89))).setNoSelectionMode(true).setUserObject((Object)new Integer(-1))).setLeftMargin(0).setRowheight(-1);
        Slider slider = ((Slider)((Slider)new Slider(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(241, 3, 11, this.field_147000_g - 89))).setDesiredWidth(11)).setVertical().setScrollableName("items");
        this.compactButton = (Button)((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setName("compact")).setChannel("compact")).setLayoutHint(6, this.field_147000_g - 24, 16, 16)).setText("C")).setTooltips(new String[]{"Compact equal stacks"});
        this.topLabel = (Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("")).setLayoutHint(6, this.field_147000_g - 60, 24, 16)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.middleLabel = (Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("of")).setLayoutHint(6, this.field_147000_g - 52, 24, 16)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        this.bottomLabel = (Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText("")).setLayoutHint(6, this.field_147000_g - 44, 24, 16)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT);
        Panel toplevel = (Panel)((Panel)((Panel)((Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).addChild((Widget)this.itemList)).addChild((Widget)slider)).addChild((Widget)this.compactButton)).addChild((Widget)this.topLabel)).addChild((Widget)this.middleLabel)).addChild((Widget)this.bottomLabel);
        toplevel.setBackgrounds(iconLocationTop, iconLocation);
        toplevel.setBackgroundLayout(false, this.field_147000_g - ModularStorageConfiguration.height1.get() + 2);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.event("compact", (source, params) -> this.compact());
        BlockPos pos = null;
        if (this.tileEntity != null) {
            provider = (CraftingGridProvider)this.tileEntity;
            pos = ((ModularStorageTileEntity)this.tileEntity).func_174877_v();
        } else if (this.field_147002_h instanceof ModularStorageItemContainer) {
            ModularStorageItemContainer storageItemContainer = (ModularStorageItemContainer)this.field_147002_h;
            provider = storageItemContainer.getCraftingGridProvider();
        } else if (this.field_147002_h instanceof RemoteStorageItemContainer) {
            RemoteStorageItemContainer storageItemContainer = (RemoteStorageItemContainer)this.field_147002_h;
            provider = storageItemContainer.getCraftingGridProvider();
        } else {
            throw new RuntimeException("Should not happen!");
        }
        this.craftingGrid.initGui(this.modBase, this.network, this.field_146297_k, this, pos, provider, this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g);
        this.sendServerCommand("rftools", "requestGridSync", TypedMap.builder().put(CommandHandler.PARAM_POS, (Object)pos).build());
    }

    private void compact() {
        if (this.tileEntity != null) {
            this.window.sendAction(RFToolsMessages.INSTANCE, this.tileEntity, "compact");
        } else {
            this.sendServerCommand("rftools", "compact");
        }
    }

    private Slot findEmptySlot() {
        for (Object slotObject : this.field_147002_h.field_75151_b) {
            Slot slot = (Slot)slotObject;
            if (this.tileEntity != null && slot.getSlotIndex() < 1 || slot.func_75216_d() && slot.func_75211_c().func_190916_E() != 0) continue;
            return slot;
        }
        return null;
    }

    public boolean func_146981_a(Slot slotIn, int x, int y) {
        if (slotIn.field_75224_c instanceof ModularStorageTileEntity || slotIn.field_75224_c instanceof ModularStorageItemInventory || slotIn.field_75224_c instanceof RemoteStorageItemInventory) {
            Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
            if (widget instanceof BlockRender) {
                Object userObject = widget.getUserObject();
                if (userObject instanceof Integer) {
                    Integer slotIndex = (Integer)userObject;
                    return slotIndex.intValue() == slotIn.getSlotIndex();
                }
            } else {
                return super.func_146981_a(slotIn, x, y);
            }
            return false;
        }
        return super.func_146981_a(slotIn, x, y);
    }

    public Slot func_146975_c(int x, int y) {
        Object userObject;
        Widget widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget != null && (userObject = widget.getUserObject()) instanceof Integer) {
            Integer slotIndex = (Integer)userObject;
            if (slotIndex != -1) {
                return this.field_147002_h.func_75139_a(slotIndex.intValue());
            }
            return this.findEmptySlot();
        }
        return super.func_146975_c(x, y);
    }

    private void dumpClasses(String name, Object o) {
        Logging.log((String)(name + ":" + o.getClass().getCanonicalName()));
        Class<?>[] classes = o.getClass().getClasses();
        for (Class<?> a : classes) {
            Logging.log((String)("        " + a.getCanonicalName()));
        }
        Logging.log((String)("        Super:" + o.getClass().getGenericSuperclass()));
        for (Type type : o.getClass().getGenericInterfaces()) {
            Logging.log((String)("        type:" + type.getClass().getCanonicalName()));
        }
    }

    private void checkAndMove(Slot mouseSlot, int button, int startSlot, int endSlot) {
        if (mouseSlot != null && mouseSlot.field_75222_d >= startSlot && mouseSlot.field_75222_d <= endSlot) {
            for (int i = startSlot; i <= endSlot; ++i) {
                if (!this.field_147002_h.func_75139_a(i).func_75216_d() || this.field_147002_h.func_75139_a(i).func_75211_c().func_190916_E() <= 0) continue;
                this.func_184098_a(this.field_147002_h.func_75139_a(i), i, button, ClickType.QUICK_MOVE);
            }
        }
    }

    protected void func_73864_a(int x, int y, int button) throws IOException {
        Slot slot;
        if ((Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157)) && (slot = this.func_146975_c(x, y)) != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            Item item = stack.func_77973_b();
            if (item instanceof ItemBlock) {
                Block block = ((ItemBlock)item).func_179223_d();
                this.dumpClasses("Block", block);
            } else {
                this.dumpClasses("Item", item);
            }
        }
        if (Keyboard.isKeyDown((int)57)) {
            if (button == 0 && this.tileEntity != null) {
                Slot mouseSlot = this.func_146975_c(x, y);
                this.window.sendAction(RFToolsMessages.INSTANCE, this.tileEntity, "compact");
                this.checkAndMove(mouseSlot, button, 301, 327);
                this.checkAndMove(mouseSlot, button, 328, 336);
            }
            return;
        }
        super.func_73864_a(x, y, button);
        this.craftingGrid.getWindow().mouseClicked(x, y, button);
        if (button == 1 && (slot = this.func_146975_c(x, y)) instanceof GhostOutputSlot) {
            if (this.tileEntity != null) {
                this.window.sendAction(RFToolsMessages.INSTANCE, this.tileEntity, "clearGrid");
            } else {
                this.sendServerCommand("rftools", "clearGrid");
            }
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.craftingGrid.getWindow().handleMouseInput();
    }

    protected void func_146286_b(int x, int y, int state) {
        super.func_146286_b(x, y, state);
        this.craftingGrid.getWindow().mouseMovedOrUp(x, y, state);
    }

    private void updateList() {
        this.itemList.removeChildren();
        if (this.tileEntity != null && !this.field_147002_h.func_75139_a(0).func_75216_d()) {
            this.compactButton.setEnabled(false);
            this.topLabel.setText("");
            this.middleLabel.setText("");
            this.bottomLabel.setText("");
            return;
        }
        String filterText = Integrations.jei().getSearchText().toLowerCase().trim();
        int numcolumns = 12;
        int labelWidth = 0;
        int spacing = 3;
        ArrayList<Pair> items = new ArrayList<Pair>();
        int count = 0;
        for (int i = 1; i < ((ModularStorageTileEntity)this.tileEntity).func_70302_i_(); ++i) {
            ItemStack stack = ((ModularStorageTileEntity)this.tileEntity).func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ++count;
            String displayName = stack.func_82833_r();
            if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
            items.add(Pair.of((Object)stack, (Object)i));
        }
        this.topLabel.setText(count + "");
        this.middleLabel.setText("of");
        this.bottomLabel.setText(((ModularStorageTileEntity)this.tileEntity).func_70302_i_() - 1 + "");
        int max = ((ModularStorageTileEntity)this.tileEntity).func_70302_i_() - 1;
        this.compactButton.setEnabled(max > 0);
        NameItemSorter itemSorter = new NameItemSorter();
        Collections.sort(items, itemSorter.getComparator());
        Pair<Panel, Integer> currentPos = MutablePair.of(null, (Object)0);
        ((ModularStorageTileEntity)this.tileEntity).setSortMode("name");
        Pair prevItem = null;
        for (Pair item : items) {
            currentPos = this.addItemToList((ItemStack)item.getKey(), this.itemList, currentPos, numcolumns, labelWidth, spacing, (Integer)item.getValue(), prevItem == null || !itemSorter.isSameGroup(prevItem, (Pair<ItemStack, Integer>)item), itemSorter.getGroupName((Pair<ItemStack, Integer>)item));
            prevItem = item;
        }
        int newfirst = -1;
        if (this.itemList.getCountSelected() == 0) {
            if (this.itemList.getBounds() != null) {
                this.itemList.setFirstSelected(0);
                newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
                if (newfirst < 0) {
                    newfirst = 0;
                }
            }
        } else if (this.itemList.getFirstSelected() > this.itemList.getChildCount() - this.itemList.getCountSelected()) {
            newfirst = this.itemList.getChildCount() - this.itemList.getCountSelected();
        }
        if (newfirst >= 0) {
            this.itemList.setFirstSelected(newfirst);
        }
    }

    private Pair<Panel, Integer> addItemToList(ItemStack stack, WidgetList itemList, Pair<Panel, Integer> currentPos, int numcolumns, int labelWidth, int spacing, int slot, boolean newgroup, String groupName) {
        Panel panel = (Panel)currentPos.getKey();
        if (panel == null || (Integer)currentPos.getValue() >= numcolumns || newgroup && groupName != null) {
            if (newgroup && groupName != null) {
                AbstractWidget groupLabel = ((Label)((Label)((Label)((Label)((Label)((Label)new Label(this.field_146297_k, (Gui)this).setText(groupName)).setColor(ModularStorageConfiguration.groupForeground.get())).setColor(StyleConfig.colorTextInListNormal)).setHorizontalAlignment(HorizontalAlignment.ALIGN_LEFT)).setFilledBackground(ModularStorageConfiguration.groupBackground.get())).setDesiredHeight(10)).setDesiredWidth(231);
                itemList.addChild((Widget)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setHorizontalMargin(2)).setVerticalMargin(0)).setDesiredHeight(10)).addChild((Widget)groupLabel));
            }
            panel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout().setSpacing(spacing)).setDesiredHeight(12)).setUserObject((Object)new Integer(-1))).setDesiredHeight(16);
            currentPos = MutablePair.of((Object)panel, (Object)0);
            itemList.addChild((Widget)panel);
        }
        BlockRender blockRender = ((BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)stack).setUserObject((Object)new Integer(slot))).setOffsetX(-1).setOffsetY(-1);
        panel.addChild((Widget)blockRender);
        currentPos.setValue((Object)((Integer)currentPos.getValue() + 1));
        return currentPos;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.window.keyTyped(typedChar, keyCode)) {
            if (typedChar >= '1' && typedChar <= '9') {
                return;
            }
            super.func_73869_a(typedChar, keyCode);
        }
        this.craftingGrid.getWindow().keyTyped(typedChar, keyCode);
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.updateList();
        this.drawWindow();
    }

    protected void func_146979_b(int i1, int i2) {
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        List tooltips = this.craftingGrid.getWindow().getTooltips();
        if (tooltips != null) {
            this.drawHoveringText(tooltips, this.window.getTooltipItems(), x - this.field_147003_i, y - this.field_147009_r, this.field_146297_k.field_71466_p);
        }
        super.func_146979_b(i1, i2);
    }

    protected void drawWindow() {
        super.drawWindow();
        this.craftingGrid.draw();
    }
}

